from System.Windows.Media import SolidColorBrush, Color, Colors
from System.Windows.Controls import(ComboBox,ComboBoxItem)
from System.Windows import TextAlignment,FontWeights
import math
   
text_grey = SolidColorBrush(Color.FromArgb(153,153,153,0))
text_black = SolidColorBrush(Colors.Black)

def System_Update_Run_Once():

    UIC_VCO_START_FREQ.Foreground=text_grey
    UIC_PLL_NUM.Foreground=text_grey
    UIC_Fpd_FREQ.Foreground=text_grey
    UIC_flexACC_START.Foreground=text_grey
    
    UIC_RAMP_THRESH.Foreground=text_grey
    UIC_RAMP_DLY_CNT.Foreground=text_grey
    UIC_RAMP_SCALE_CNT.Foreground=text_grey    
    
    UIC_RAMP_LIMIT_HIGH_dec.Foreground=text_grey
    UIC_RAMP_LIMIT_HIGH.Foreground=text_grey
    
    UIC_RAMP_LIMIT_LOW_dec.Foreground=text_grey
    UIC_RAMP_LIMIT_LOW.Foreground=text_grey

    UIC_ACT_END_FREQ0.Foreground=text_grey
    UIC_ACT_END_FREQ1.Foreground=text_grey

    UIC_RAMP0_LEN.Foreground=text_grey
    UIC_RAMP1_LEN.Foreground=text_grey
    
    UIC_RAMP0_INC_dec.Foreground=text_grey
    UIC_RAMP1_INC_dec.Foreground=text_grey

    UIC_RAMP0_INC.Foreground=text_grey
    UIC_RAMP1_INC.Foreground=text_grey 
    
    UIC_RAMP0_ActualLength.Foreground=text_grey
    UIC_RAMP1_ActualLength.Foreground=text_grey 
    
    UIC_RAMP0_Status.Text=""
    UIC_RAMP1_Status.Text=""
    
    UpdateRamps();
    UpdateLimits(RAMP_LIMIT_LOW_FREQ,RAMP_LIMIT_LOW_dec,RAMP_LIMIT_LOW);
    UpdateLimits(RAMP_LIMIT_HIGH_FREQ,RAMP_LIMIT_HIGH_dec,RAMP_LIMIT_HIGH);
    UpdateThreshold();
    ValidateSettings();
    btnUpdateRampGUI.Background=brush_alert
    btnUpdateRampGUI.ToolTip="The Update Ramp GUI should be pressed initially to ensure the GUI is updated."
    
def System_Update_Loaded_Mode():
    UpdateRamps();
    UpdateLimits(RAMP_LIMIT_LOW_FREQ,RAMP_LIMIT_LOW_dec,RAMP_LIMIT_LOW);
    UpdateLimits(RAMP_LIMIT_HIGH_FREQ,RAMP_LIMIT_HIGH_dec,RAMP_LIMIT_HIGH);
    UpdateThreshold();
    ValidateSettings();
    btnUpdateRampGUI.Background=brush_alert
    btnUpdateRampGUI.ToolTip="The Update Ramp GUI should be pressed initially to ensure the GUI is updated."
    
def btnUpdateRampGUI_Update():
    btnUpdateRampGUI.Background=brush_white
    btnUpdateRampGUI.ToolTip=None

    if (PLL_DEN.iValue<4294967295):
        UpdateStatusBar("PLL_DEN must be 4294967295 in Ramping Mode.  Forcing this value on the PLL tab.")
        Fvco=Fvco_FREQ.dValue
        PLL_DEN.iValue=4294967295
        Fvco_FREQ.dValue=Fvco
        Fvco_FREQ_Update()
        
    if (OUT_MUTE.iValue==1):
        UpdateStatusBar("OUT_MUTE must be disabled for ramping to work.  Disabling this bit.")
        OUT_MUTE.iValue=0
        
    if (OUT_FORCE.iValue==0):
        UpdateStatusBar("OUT_FORCE must be enabled for ramping to work. Enabling this bit.")
        OUT_FORCE.iValue=1
        
    if (GetPin("SYNC")==1):
        UpdateStatusBar("Setting SYNC Pin LOW as this is required for ramping.")
        SetPin("SYNC",0)
            
            
            
    UpdateRamps();
    UpdateLimits(RAMP_LIMIT_LOW_FREQ,RAMP_LIMIT_LOW_dec,RAMP_LIMIT_LOW);
    UpdateLimits(RAMP_LIMIT_HIGH_FREQ,RAMP_LIMIT_HIGH_dec,RAMP_LIMIT_HIGH);
    UpdateThreshold();
    UpdateCalTime();
    ValidateSettings();
    
def RAMP_EN_Update():
    ValidateSettings();

def btnUpdateRampGUI_Update_UI():
    ValidateSettings();

def ReverseDirection_Update():
    if (RAMP_MANUAL.iValue==1):
        if (GetPin("RampDIR_CE")==0):
            SetPin("RampDIR_CE",1)
            UpdateStatusBar("RampDIR_CE Pin State is now high.")
            UIC_RAMP0_Status.Text=""
            UIC_RAMP1_Status.Text=" <- Active"
        else:
            SetPin("RampDIR_CE",0)
            UpdateStatusBar("RampDIR_CE Pin State is now low.")
            UIC_RAMP0_Status.Text=" <- Active"
            UIC_RAMP1_Status.Text=""
  
def ToggleRampCLKPin_Update():
    if (GetPin("RampCLK")==1):
        SetPin("RampCLK",0)
        SetPin("RampCLK",1)
    else:    
        SetPin("RampCLK",1)
        SetPin("RampCLK",0)
        
    UpdateStatusBar("One pulse sent to RampCLK pin.")
    
def RampThreshold_FREQ_Update():
    UpdateThreshold();
    pass;
    
def RampThreshold_FREQ_Update_UI():
    ValidateSettings();
    pass;
    
def RampMinCalTime_Update():
    UpdateCalTime();
    ValidateSettings();  

def RAMP_BURST_EN_Update():
    UpdateRamps();
    ValidateSettings();
    
    

    
def RAMP0_NEXT_TRIG_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP1_NEXT_TRIG_Update():
    UpdateRamps();
    ValidateSettings();

def RAMP_TRIGA_Update():
    UpdateRamps();
    
def RAMP_TRIGB_Update():
    UpdateRamps();
    ValidateSettings();
    
    
def DES_END_FREQ0_Update():
    UpdateRamps();
    ValidateSettings();
    
def DES_END_FREQ0_Update_UI():
    ValidateSettings();

def DES_END_FREQ1_Update():
    UpdateRamps();
    ValidateSettings();
    
def DES_END_FREQ1_Update_UI():
    ValidateSettings();

def DURATION0_Update():
    UpdateRamps();
    ValidateSettings();

def DURATION1_Update():
    UpdateRamps();
    ValidateSettings();

def RAMP0_DLY_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP1_DLY_Update():
    UpdateRamps();

def RAMP0_RST_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP1_RST_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP0_NEXT_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP1_NEXT_Update():
    UpdateRamps();
    ValidateSettings();
    
def RAMP0_STEP_FREQ_Update():
    UpdateRamps()
    ValidateSettings();
    
def RAMP1_STEP_FREQ_Update():
    UpdateRamps()
    ValidateSettings();
    
def RAMP_MANUAL_Update():
    btnUpdateRampGUI.Background=brush_alert
    btnUpdateRampGUI.ToolTip="The Update Ramp GUI needs to be pressed to ensure that all settings are applied."
    ValidateSettings();
             
def RAMP_LIMIT_LOW_FREQ_Update():
    if RAMP_LIMIT_LOW_FREQ.dValue<Fvco_FREQ.dValue-256*Fpd_FREQ.dValue:
        RAMP_LIMIT_LOW_FREQ.dValue=Fvco_FREQ.dValue-256*Fpd_FREQ.dValue
        UpdateStatusBar("Lower ramp limit has been adjusted;  it can be no more than 256xFpd lower than Fvco.")
    UpdateLimits(RAMP_LIMIT_LOW_FREQ,RAMP_LIMIT_LOW_dec,RAMP_LIMIT_LOW);
    pass;
    
def RAMP_LIMIT_LOW_FREQ_Update_UI():
    ValidateSettings();
    pass;

def RAMP_LIMIT_HIGH_FREQ_Update():
    if RAMP_LIMIT_HIGH_FREQ.dValue>Fvco_FREQ.dValue+256*Fpd_FREQ.dValue:
        RAMP_LIMIT_HIGH_FREQ.dValue=Fvco_FREQ.dValue+256*Fpd_FREQ.dValue
        UpdateStatusBar("Upper ramp limit has been adjusted;  it can be no more than 256xFpd higher than Fvco.")
    UpdateLimits(RAMP_LIMIT_HIGH_FREQ,RAMP_LIMIT_HIGH_dec,RAMP_LIMIT_HIGH);
    pass;
    
def RAMP_LIMIT_HIGH_FREQ_Update_UI():
    ValidateSettings();
    pass;
    
    

def UpdateLimits(Freq,DEC,MAIN):
    VCO_START_FREQ.dValue=Fvco_FREQ.dValue
    flexACC_START.iValue=(16777216*PLL_N.iValue)+int(PLL_NUM.iValue/256)
    
    if (Fpd_FREQ.dValue<0.000001):
        DEC.iValue=0
        MAIN.iValue=0
    else:
        DEC.iValue=int((round(Freq.dValue/Fpd_FREQ.dValue,4)-PLL_N.iValue)*16777216)
        if (DEC.iValue>4294967295):
            DEC.iValue=4294967295
        if (DEC.iValue<-4294967295):
            DEC.iValue=-4294967295         
        
        if (DEC.iValue>0):
            MAIN.iValue=DEC.iValue
        else:
            MAIN.iValue=8589934592+DEC.iValue

def UpdateThreshold():
    VCO_START_FREQ.dValue=Fvco_FREQ.dValue
    flexACC_START.iValue=(16777216*PLL_N.iValue)+int(PLL_NUM.iValue/256)
    
    if (RampThreshold_FREQ.dValue<0.00001) or (Fpd_FREQ.dValue<0.000001):
        RAMP_THRESH.iValue=0
    else:
        RAMP_THRESH.iValue = RampThreshold_FREQ.dValue/Fpd_FREQ.dValue*16777216

def UpdateCalTime():
    if (RampMinCalTime.dValue<0.05):
        RAMP_DLY_CNT.iValue=0
        RAMP_SCALE_CNT.iValue=1
    else:
        Scale = math.ceil(math.log(RampMinCalTime.dValue*Fpd_FREQ.dValue/1023)/math.log(2.0))
        if (Scale<0):
            Scale=1
        if (Scale>6):
            Scale=6
        RAMP_SCALE_CNT.iValue=Scale+1
        DLY = int(RampMinCalTime.dValue*Fpd_FREQ.dValue/pow(2,Scale))
        if (DLY<0):
            DLY=0
        if (DLY>1023):
            DLY=1023
        RAMP_DLY_CNT.iValue=DLY
    
def UpdateRamps():
    VCO_START_FREQ.dValue=Fvco_FREQ.dValue
    flexACC_START.iValue=(16777216*PLL_N.iValue)+int(PLL_NUM.iValue/256)
    
    if (RAMP_MANUAL.iValue==1):
    
        #   Update RAMP Increments
        dF0= RAMP0_STEP_FREQ.dValue               
        RAMP0_INC_dec.iValue=int(round(16777216*dF0/Fpd_FREQ.dValue))
        if (RAMP0_INC_dec.iValue>1073741823):
            RAMP0_INC_dec.iValue=1073741823
        if (RAMP0_INC_dec.iValue<-1073741823):
            RAMP0_INC_dec.iValue=-1073741823
            
        if (RAMP0_INC_dec.iValue >-1):
            RAMP0_INC.iValue=RAMP0_INC_dec.iValue
        else:
            RAMP0_INC.iValue=int(1073741824.0 + RAMP0_INC_dec.iValue)
            
        dF1= RAMP1_STEP_FREQ.dValue               
        RAMP1_INC_dec.iValue=int(round(16777216*dF1/Fpd_FREQ.dValue))
        if (RAMP1_INC_dec.iValue>1073741823):
            RAMP1_INC_dec.iValue=1073741823
        if (RAMP1_INC_dec.iValue<-1073741823):
            RAMP1_INC_dec.iValue=-1073741823
            
        if (RAMP1_INC_dec.iValue >-1):
            RAMP1_INC.iValue=RAMP1_INC_dec.iValue
        else:
            RAMP1_INC.iValue=int(1073741824.0 + RAMP1_INC_dec.iValue) 
            
    else:
      
        if (Fpd_FREQ.dValue>0.0):   
            #   Update Ramp Lengths
            MaxDelay0 =(RAMP0_DLY.iValue+1)*65535.0/Fpd_FREQ.dValue
            if (DURATION0.dValue>MaxDelay0):
                DURATION0.dValue = MaxDelay0
            RAMP0_LEN.iValue = int(round(Fpd_FREQ.dValue*DURATION0.dValue/(RAMP0_DLY.iValue+1)))
                
            MaxDelay1 =(RAMP1_DLY.iValue+1)*65535.0/Fpd_FREQ.dValue
            if (DURATION1.dValue>MaxDelay1):
                DURATION1.dValue = MaxDelay1                     
            RAMP1_LEN.iValue = int(round(Fpd_FREQ.dValue*DURATION1.dValue/(RAMP1_DLY.iValue+1)))
        else:
            RAMP0_LEN.iValue=0
            RAMP1_LEN.iValue=0
            
        #   Update Ramp Increments and  Actual Frequency
        if  (RAMP0_LEN.iValue==0):
            RAMP0_INC.iValue=0
        else:
            ACT_START_FREQ0.dValue=VCO_START_FREQ.dValue 
            dF0= DES_END_FREQ0.dValue-VCO_START_FREQ.dValue
            RAMP0_INC_dec.iValue=int(round(16777216*dF0/(Fpd_FREQ.dValue*RAMP0_LEN.iValue)))

            if (RAMP0_INC_dec.iValue>1073741823):
                RAMP0_INC_dec.iValue=1073741823
            if (RAMP0_INC_dec.iValue<-1073741823):
                RAMP0_INC_dec.iValue=-1073741823
                
            if (RAMP0_INC_dec.iValue >-1):
                RAMP0_INC.iValue=RAMP0_INC_dec.iValue
            else:
                RAMP0_INC.iValue=int(1073741824.0 + RAMP0_INC_dec.iValue)
                
            
        ACT_END_FREQ0.dValue=ACT_START_FREQ0.dValue + RAMP0_INC_dec.iValue*RAMP0_LEN.iValue*Fpd_FREQ.dValue/16777216
        
        ACT_START_FREQ1.dValue=ACT_END_FREQ0.dValue
        if (RampThreshold_FREQ.dValue<1):
            RAMP0_ActualLength.dValue = RAMP0_LEN.iValue*(1+RAMP0_DLY.iValue)*1.0/Fpd_FREQ.dValue
        else:
            RAMP0_ActualLength.dValue = RAMP0_LEN.iValue*(1+RAMP0_DLY.iValue)*1.0/Fpd_FREQ.dValue+RampMinCalTime.dValue*math.floor(0.00001+abs(ACT_END_FREQ0.dValue-ACT_START_FREQ0.dValue)/RampThreshold_FREQ.dValue)
  
        if  (RAMP1_LEN.iValue==0):
            RAMP1_INC.iValue=0
        else:
            
            dF1= DES_END_FREQ1.dValue-ACT_START_FREQ1.dValue

            
            RAMP1_INC_dec.iValue=int(round(16777216*dF1/(Fpd_FREQ.dValue*RAMP1_LEN.iValue)))
            if (RAMP1_INC_dec.iValue>1073741823):
                RAMP1_INC_dec.iValue=1073741823
            if (RAMP1_INC_dec.iValue<-1073741823):
                RAMP1_INC_dec.iValue=-1073741823
                
            if (RAMP1_INC_dec.iValue >-1):
                RAMP1_INC.iValue=RAMP1_INC_dec.iValue
            else:
                RAMP1_INC.iValue=int(1073741824.0 + RAMP1_INC_dec.iValue)
        
        ACT_END_FREQ1.dValue=ACT_START_FREQ1.dValue + RAMP1_INC_dec.iValue*RAMP1_LEN.iValue*1.0/(1+RAMP1_DLY.iValue)*Fpd_FREQ.dValue/16777216
         
        if (RampThreshold_FREQ.dValue<1):
            RAMP1_ActualLength.dValue = RAMP1_LEN.iValue*(1+RAMP1_DLY.iValue)*1.0/Fpd_FREQ.dValue
        else:
            RAMP1_ActualLength.dValue = RAMP1_LEN.iValue*(1+RAMP1_DLY.iValue)*1.0/Fpd_FREQ.dValue+RampMinCalTime.dValue*math.floor(0.00001+abs(ACT_END_FREQ1.dValue-ACT_START_FREQ1.dValue)/RampThreshold_FREQ.dValue)
  

def ValidateSettings():
   #    Now do the Validation
    
    if (RAMP_EN.iValue==0):
    
        Dim(RAMP_LIMIT_HIGH_FREQ)
        Dim(RAMP_LIMIT_LOW_FREQ)
        Dim(RampThreshold_FREQ)
        Dim(RampMinCalTime)
        Dim(RAMP_TRIG_CAL)
        
        UIC_ACT_START_FREQ0.Foreground=text_grey
        Dim(DES_END_FREQ0)
        Dim(DURATION0)
        Dim(RAMP0_DLY)
        Dim(RAMP0_NEXT)
        Dim(RAMP0_NEXT_TRIG)
        Dim(RAMP0_RST)
       
        UIC_ACT_START_FREQ1.Foreground=text_grey
        Dim(DES_END_FREQ1)
        Dim(DURATION1)
        Dim(RAMP1_DLY)
        Dim(RAMP1_NEXT)
        Dim(RAMP1_NEXT_TRIG)
        Dim(RAMP1_RST)
        
        Dim(RAMP_BURST_COUNT)
        Dim(RAMP_BURST_EN)
        
        Dim(RAMP_MANUAL)
        Dim(RAMP0_STEP_FREQ)
        Dim(RAMP1_STEP_FREQ)
        
        Dim(RAMP_BURST_EN)
        Dim(RAMP_BURST_COUNT)
        Dim(RAMP_BURST_TRIG)
    else:
        UnDim(RAMP_LIMIT_HIGH_FREQ)
        UnDim(RAMP_LIMIT_LOW_FREQ)
        UnDim(RampThreshold_FREQ)
        UnDim(RAMP_MANUAL)
        UnDim(RAMP0_NEXT_TRIG)
        UnDim(RAMP1_NEXT_TRIG)
        
        #   Validate Ramp Limits
        if (RAMP_LIMIT_LOW_FREQ.dValue>Fvco_FREQ.dValue):
            UIC_RAMP_LIMIT_LOW_FREQ.Background=brush_alert
            UIC_RAMP_LIMIT_LOW_FREQ.ToolTip="The lower ramp limit needs to be less than or equal to the starting VCO frequency."   

        if (RAMP_LIMIT_HIGH_FREQ.dValue<Fvco_FREQ.dValue):
            UIC_RAMP_LIMIT_LOW_FREQ.Background=brush_alert
            UIC_RAMP_LIMIT_LOW_FREQ.ToolTip="The upper ramp limit needs to be greater than or equal to the starting VCO frequency."            
        
        #   Validate Phase Detector Frequency
        Rdivide=PLL_R.iValue*PLL_R_PRE.iValue
        Multiply = (OSC_2X.iValue+1)*(MULT.iValue)
        FpdMin =50
        FpdMax=125
        
        UIC_Fpd_FREQ.Background=brush_white
        UIC_Fpd_FREQ.ToolTip=None 
        
        if (Multiply==1):
            if (Rdivide==1):
                if (CAL_CLK_DIV.iValue>0):
                    UIC_Fpd_FREQ.Background=brush_alert
                    UIC_Fpd_FREQ.ToolTip="CAL_CLK_DIV needs to be 0 for this condition for ramping."              
            elif (Rdivide==2):
                if (CAL_CLK_DIV.iValue<>1):
                    UIC_Fpd_FREQ.Background=brush_alert
                    UIC_Fpd_FREQ.ToolTip="CAL_CLK_DIV needs to be 1 for this condition for ramping." 
            elif (Rdivide<5):
                if (CAL_CLK_DIV.iValue<>2):
                    UIC_Fpd_FREQ.Background=brush_alert
                    UIC_Fpd_FREQ.ToolTip="CAL_CLK_DIV needs to be 2 for this condition for ramping."             
            elif (Rdivide<8):
                if (CAL_CLK_DIV.iValue<3):
                    UIC_Fpd_FREQ.Background=brush_alert
                    UIC_Fpd_FREQ.ToolTip="CAL_CLK_DIV needs to be 3 for this condition for ramping."              
            else:
                UIC_Fpd_FREQ.Background=brush_alert
                UIC_Fpd_FREQ.ToolTip="Ramping can not be used for a total R divide in the PLL that is greater than 8."
        else:
            if (Rdivide==1):
                if (Multiply==2):
                    FpdMin = 80
                    FpdMax = 200
                elif (Multiply>2):
                    FpdMin = 80
                    FpdMax = 125               
            else:
                UIC_Fpd_FREQ.Background=brush_alert
                UIC_Fpd_FREQ.ToolTip="When Ramping is used, one can not use both the R divider and input multiplier."            
        
        if (Fpd_FREQ.dValue>125) and (RAMP_MANUAL.iValue==0):
            UIC_Fpd_FREQ.Background=brush_alert
            UIC_Fpd_FREQ.ToolTip="In automatic ramping mode, the phase detector frequency should not exceed 125 MHz."

                 
        if (RAMP_MANUAL.iValue==1):
        
            UnDim(RAMP0_STEP_FREQ)
            UnDim(RAMP1_STEP_FREQ)      
        
    
            Dim(RampMinCalTime)
            Dim(RAMP_TRIG_CAL)
            
            UIC_ACT_START_FREQ0.Foreground=text_grey
            Dim(DES_END_FREQ0)
            Dim(DURATION0)
            Dim(RAMP0_DLY)
            Dim(RAMP0_NEXT)
            Dim(RAMP0_RST)
           
            UIC_ACT_START_FREQ1.Foreground=text_grey
            Dim(DES_END_FREQ1)
            Dim(DURATION1)
            Dim(RAMP1_DLY)
            Dim(RAMP1_NEXT)
            Dim(RAMP1_RST)
            
            Dim(RAMP_BURST_COUNT)
            Dim(RAMP_BURST_EN)
            Dim(RAMP_BURST_TRIG)
            
            if ( GetPin("RampDIR_CE")==0):
                UIC_RAMP0_Status.Text=" <- Active"
                UIC_RAMP1_Status.Text=""
            else:
                UIC_RAMP0_Status.Text=""
                UIC_RAMP1_Status.Text=" <- Active"
            
            if (RAMP0_NEXT_TRIG.iValue==0) or ( (RAMP0_NEXT_TRIG.iValue==1) and (RAMP_TRIGA.iValue<>1) ) or ( (RAMP0_NEXT_TRIG.iValue==2) and (RAMP_TRIGB.iValue<>1) ) or ( (RAMP0_NEXT_TRIG.iValue==3) and (RAMP_TRIGC.iValue<>1) ):
                UIC_RAMP0_NEXT_TRIG.Background=brush_alert
                UIC_RAMP0_NEXT_TRIG.ToolTip="In Manual Ramping mode, a trigger needs to be selected that points to a rising edge of the RampCLK pin."
            else:
                UIC_RAMP0_NEXT_TRIG.Background=brush_white
                UIC_RAMP0_NEXT_TRIG.ToolTip=None         

            if (RAMP1_NEXT_TRIG.iValue==0) or ( (RAMP1_NEXT_TRIG.iValue==1) and (RAMP_TRIGA.iValue<>1) ) or ( (RAMP1_NEXT_TRIG.iValue==2) and (RAMP_TRIGB.iValue<>1) ) or ( (RAMP1_NEXT_TRIG.iValue==3) and (RAMP_TRIGC.iValue<>1) ):
                UIC_RAMP1_NEXT_TRIG.Background=brush_alert
                UIC_RAMP1_NEXT_TRIG.ToolTip="In Manual Ramping mode, a trigger needs to be selected that points to a rising edge of the RampCLK pin."
            else:
                UIC_RAMP1_NEXT_TRIG.Background=brush_white
                UIC_RAMP1_NEXT_TRIG.ToolTip=None                         

        else:
            UnDim(RampMinCalTime)
            UnDim(RAMP_TRIG_CAL)
            UnDim(DES_END_FREQ0)
            UnDim(DURATION0)
            UnDim(RAMP0_DLY)
            UnDim(RAMP0_NEXT)
            UnDim(RAMP0_RST)
            UnDim(RAMP_BURST_EN)
            UnDim(RAMP_BURST_COUNT)
            
            Dim(RAMP0_STEP_FREQ)    
            Dim(RAMP1_STEP_FREQ)
            UIC_ACT_START_FREQ0.Foreground=text_black
            UIC_RAMP0_Status.Text=""
            UIC_RAMP1_Status.Text=""
            
            if (RAMP_BURST_EN.iValue==1):
                UnDim(RAMP_BURST_COUNT)
                UnDim(RAMP_BURST_EN)
                UnDim(RAMP_BURST_TRIG)
            else:
                Dim(RAMP_BURST_COUNT)
                Dim(RAMP_BURST_EN)
                Dim(RAMP_BURST_TRIG)
            
            if (RAMP0_NEXT_TRIG.iValue>0):
                UIC_RAMP0_NEXT_TRIG.Background=brush_alert
                UIC_RAMP0_NEXT_TRIG.ToolTip="In Automatic Ramping mode, it us usually, but not always the case where one wants to use the TOC Timeout for the ramp trigger."
            else:
                UIC_RAMP0_NEXT_TRIG.Background=brush_white
                UIC_RAMP0_NEXT_TRIG.ToolTip=None         

            if (RAMP1_NEXT_TRIG.iValue>0):
                UIC_RAMP1_NEXT_TRIG.Background=brush_alert
                UIC_RAMP1_NEXT_TRIG.ToolTip="In Automatic Ramping mode, it us usually, but not always the case where one wants to use the TOC Timeout for the ramp trigger."
            else:
                UIC_RAMP1_NEXT_TRIG.Background=brush_white
                UIC_RAMP1_NEXT_TRIG.ToolTip=None  
            
            if (RAMP0_NEXT.iValue==0):
                UIC_ACT_START_FREQ1.Foreground=text_grey
                Dim(DES_END_FREQ1)
                Dim(DURATION1)
                Dim(RAMP1_DLY)
                Dim(RAMP1_NEXT)
                Dim(RAMP1_RST)
                
            else:
                UIC_ACT_START_FREQ1.Foreground=text_black
                UnDim(DES_END_FREQ1)
                UnDim(DURATION1)
                UnDim(RAMP1_DLY)
                UnDim(RAMP1_NEXT)
                UnDim(RAMP1_RST) 
                
        #   Validate Threshold
        if (RampThreshold_FREQ.dValue>50):
            UIC_RampThreshold_FREQ.Background=brush_alert
            UIC_RampThreshold_FREQ.ToolTip="Ensure that the VCO calibration threshold is not too large for the VCO frequency and the final design is tested over parts and temperature."
        else:
            UIC_RampThreshold_FREQ.Background=brush_white
            UIC_RampThreshold_FREQ.ToolTip=None
        
        #   Validate Automatic Ramping Frequencies
        LowLimit=7500
        HighLimit=15000
        if (RAMP_MANUAL.iValue==0):
            if  ( (DES_END_FREQ0.dValue<LowLimit) or (DES_END_FREQ0.dValue>HighLimit) ):
                UIC_DES_END_FREQ0.Background=brush_alert
                UIC_DES_END_FREQ0.ToolTip="For this VCO start frequency of "+str(Fvco_FREQ.dValue)+" the VCO needs to stay in the range of " + str(LowLimit)+" to "+ str(HighLimit)+ " or the ramp will get stuck.  If this happens, it may be necessary to use the RESET bit."
            else:
                UIC_DES_END_FREQ0.Background=brush_white
                UIC_DES_END_FREQ0.ToolTip=None
                
            if  ( (DES_END_FREQ1.dValue<LowLimit) or (DES_END_FREQ1.dValue>HighLimit) ):
                UIC_DES_END_FREQ1.Background=brush_alert
                UIC_DES_END_FREQ1.ToolTip="For this VCO start frequency of "+str(Fvco_FREQ.dValue)+" the VCO needs to stay in the range of " + str(LowLimit)+" to "+ str(HighLimit)+ " or the ramp will get stuck.  If this happens, it may be necessary to use the RESET bit."
            else:
                UIC_DES_END_FREQ1.Background=brush_white
                UIC_DES_END_FREQ1.ToolTip=None
                
    
