/*
 * Frangline Jose
 *
 * Code to initialize LMX2594 using MSP-EXP430FR5969
 *
 * Example msp430fr59xx_euscia0_spi_09.c from:
 *   C:\ti\msp\MSP430Ware_3_80_08_01\examples\devices\MSP430FR5xx_6xx\MSP430FR596x_MSP430FR595x_MSP430FR594x_MSP430FR586x_MSP430FR585x_MSP430FR584x_Code_Examples\C
 *
 *                  MSP430FR5969
 *                 -----------------
 *            /|\ |              XIN|-
 *             |  |                 |  32KHz Crystal
 *             ---|RST          XOUT|-
 *                |                 |
 *                |             P2.0|-> Data Out (UCA0SIMO)
 *                |                 |
 *                |             P2.1|<- Data In (UCA0SOMI)  [Not used]
 *                |                 |
 *                |             P1.5|-> Serial Clock Out (UCA0CLK)
 *                |                 |
 *                |             P1.4|-> GPIO - for LMX CSB
 *
 * optional: P1.2[LSB] and P3.0[MSB] of FR5969 used as LMX config select.
 *
 *  ON LMX EVM connect CMB, SDI, SCK, GND pins.
 *  Leave all other pins of LMX2594EVM unconnected.
 *
 *
 */
#include <msp430.h>
#include <stdint.h>
void init_LMX_01(void);

uint8_t k;
uint32_t read_arr[6];

void writeLMX(unsigned int regLMX,unsigned int dataLMX)
{
    P1OUT &= ~BIT4;                                 // CSB --> Low
//    __delay_cycles(5);
    while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = (unsigned int)(regLMX & 0xff);
    while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = (unsigned int)((dataLMX>>8) & 0xff);
     while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = (unsigned int)((dataLMX) & 0xff);
    while (!(UCA0IFG & UCTXIFG)) ;
//    __delay_cycles(200);
    ////__delay_cycles(200);
    P1OUT |= BIT4;                                  //CSB --> high
    //__delay_cycles(2);
//    __delay_cycles(5);
}

unsigned int readLMX(unsigned int regLMX)
{
    uint8_t temp1;
    unsigned int dataLMX;

    P1OUT &= ~BIT4;                                 // CSB --> Low
    __delay_cycles(5);

    while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = (unsigned int)(0x80 | (regLMX & 0xff));

    while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = 0xff;
    while (!(UCA0IFG & UCRXIFG)) ;
    temp1 = UCA0RXBUF;

    dataLMX = temp1;
    dataLMX = dataLMX << 8;

    while (!(UCA0IFG & UCTXIFG)) ;
    UCA0TXBUF = 0xff;
    while (!(UCA0IFG & UCRXIFG)) ;
    temp1 = UCA0RXBUF;

    dataLMX |= temp1;

    __delay_cycles(600);
    P1OUT |= BIT4;                                  //CSB --> high
    __delay_cycles(2);
    __delay_cycles(5);
    return dataLMX;
}

void main(void)
{

    WDTCTL = WDTPW | WDTHOLD;                 // Stop watchdog timer
#if 0
    // SHASHANK - START - 16 MHZ
    // Configure one FRAM waitstate as required by the device datasheet for MCLK
    // operation beyond 8MHz _before_ configuring the clock system.
    // Disable the GPIO power-on default high-impedance mode to activate
    // previously configured port settings

    PM5CTL0 &= ~LOCKLPM5;

    FRCTL0 = FRCTLPW | NWAITS_1;

    // Clock System Setup
    CSCTL0_H = CSKEY >> 8;                    // Unlock CS registers
    CSCTL1 = DCORSEL | DCOFSEL_4;             // Set DCO to 16MHz
    CSCTL2 = SELA__VLOCLK | SELS__DCOCLK | SELM__DCOCLK;
    CSCTL3 = DIVA__1 | DIVS__1 | DIVM__1;     // Set all dividers

    CSCTL0_H = 0;                             // Lock CS registerss
    // SHASHANK - END - 16 MHZ
#endif


    P1OUT = BIT1;                             // Pull-up resistor on P1.1
    P1REN = BIT1;                             // Select pull-up mode for P1.1
    P1DIR |=BIT1;
    P1DIR |=BIT4;
    P1IES = BIT1;                             // P1.1 Hi/Lo edge
    P1IFG = 0;                                // Clear all P1 interrupt flags
    P1IE = BIT1;                              // P1.1 interrupt enabled

      // Configure GPIO
      P1SEL1 |= BIT5;                           // USCI_A0 operation
      P2SEL1 |= BIT0 | BIT1;                    // USCI_A0 operation
      P2SEL0 &= (BIT0 | BIT1);
      PJSEL0 |= BIT4 | BIT5;                    // For XT1

#if 0
      // Disable the GPIO power-on default high-impedance mode to activate
      // previously configured port settings
      PM5CTL0 &= ~LOCKLPM5;

      // XT1 Setup
      CSCTL0_H = CSKEY >> 8;                    // Unlock CS registers
      CSCTL1 = DCOFSEL_0;                       // Set DCO to 1MHz
      CSCTL2 = SELA__LFXTCLK | SELS__DCOCLK | SELM__DCOCLK;
      CSCTL3 = DIVA__1 | DIVS__1 | DIVM__1;     // set all dividers
      CSCTL4 &= ~LFXTOFF;
      do
      {
        CSCTL5 &= ~LFXTOFFG;                    // Clear XT1 fault flag
        SFRIFG1 &= ~OFIFG;
      }while (SFRIFG1&OFIFG);                   // Test oscillator fault flag
      CSCTL0_H = 0;                             // Lock CS registers
#endif

#if 1
    // SHASHANK - START - 16 MHZ
    // Configure one FRAM waitstate as required by the device datasheet for MCLK
    // operation beyond 8MHz _before_ configuring the clock system.
    // Disable the GPIO power-on default high-impedance mode to activate
    // previously configured port settings

    PM5CTL0 &= ~LOCKLPM5;

    FRCTL0 = FRCTLPW | NWAITS_1;

    // Clock System Setup
    CSCTL0_H = CSKEY >> 8;                    // Unlock CS registers
    CSCTL1 = DCORSEL | DCOFSEL_4;             // Set DCO to 16MHz
    CSCTL2 = SELA__VLOCLK | SELS__DCOCLK | SELM__DCOCLK;
    CSCTL3 = DIVA__1 | DIVS__1 | DIVM__1;     // Set all dividers

    CSCTL0_H = 0;                             // Lock CS registerss
    // SHASHANK - END - 16 MHZ
#endif

      // Configure USCI_A0 for SPI operation
      UCA0CTLW0 = UCSWRST;                      // **Put state machine in reset**
      UCA0CTLW0 |= UCMST | UCSYNC | UCCKPL | UCMSB;  // 3-pin, 8-bit SPI master  UCMSB |  | UCCKPH;
                                                // Clock polarity high, MSB
      UCA0CTLW0 |= UCSSEL__SMCLK;                // ACLK
      UCA0BR0 = 0x01;                           // /2
      UCA0BR1 = 0;                              //
      UCA0MCTLW = 0;                            // No modulation
      UCA0CTLW0 &= ~UCSWRST;                    // **Initialize USCI state machine**


      init_LMX_01();


}

void init_LMX_01(){

// LMX2594
#if 0
    writeLMX(0x70,0x0104);
    writeLMX(0x6F,0x0094);
    writeLMX(0x6E,0x0428);
    writeLMX(0x6D,0x9D7D);
    writeLMX(0x6C,0x00F2);
    writeLMX(0x6B,0x8801);
    writeLMX(0x6A,0x0007);
    writeLMX(0x69,0x4440);
    writeLMX(0x68,0x0000);
    writeLMX(0x67,0x0000);
    writeLMX(0x66,0x0000);
    writeLMX(0x65,0x0000);
    writeLMX(0x64,0x0000);
    writeLMX(0x63,0x0000);
    writeLMX(0x62,0x0000);
    writeLMX(0x61,0x0000);
    writeLMX(0x60,0x0000);
    writeLMX(0x5F,0x0000);
    writeLMX(0x5E,0x0000);
    writeLMX(0x5D,0x0000);
    writeLMX(0x5C,0x0000);
    writeLMX(0x5B,0x0000);
    writeLMX(0x5A,0x0000);
    writeLMX(0x59,0x0000);
    writeLMX(0x58,0x0000);
    writeLMX(0x57,0x0000);
    writeLMX(0x56,0x0000);
    writeLMX(0x55,0x0000);
    writeLMX(0x54,0x0000);
    writeLMX(0x53,0x0000);
    writeLMX(0x52,0x0000);
    writeLMX(0x51,0x0000);
    writeLMX(0x50,0x0000);
    writeLMX(0x4F,0x0000);
    writeLMX(0x4E,0x0003);
    writeLMX(0x4D,0x0000);
    writeLMX(0x4C,0x000C);
    writeLMX(0x4B,0x0800);
    writeLMX(0x4A,0x0000);
    writeLMX(0x49,0x003F);
    writeLMX(0x48,0x0001);
    writeLMX(0x47,0x0081);
    writeLMX(0x46,0xC350);
    writeLMX(0x45,0x0000);
    writeLMX(0x44,0x03E8);
    writeLMX(0x43,0x0000);
    writeLMX(0x42,0x01F4);
    writeLMX(0x41,0x0000);
    writeLMX(0x40,0x1388);
    writeLMX(0x3F,0x0000);
    writeLMX(0x3E,0x0322);
    writeLMX(0x3D,0x00A8);
    writeLMX(0x3C,0x0000);
    writeLMX(0x3B,0x0001);
    writeLMX(0x3A,0x9001);
    writeLMX(0x39,0x0020);
    writeLMX(0x38,0x0000);
    writeLMX(0x37,0x0000);
    writeLMX(0x36,0x0000);
    writeLMX(0x35,0x0000);
    writeLMX(0x34,0x0820);
    writeLMX(0x33,0x0080);
    writeLMX(0x32,0x0000);
    writeLMX(0x31,0x4180);
    writeLMX(0x30,0x0300);
    writeLMX(0x2F,0x0300);
    writeLMX(0x2E,0x07FC);
    writeLMX(0x2D,0xC8DF);
    writeLMX(0x2C,0x1FA3);
    writeLMX(0x2B,0x0000);
    writeLMX(0x2A,0x0000);
    writeLMX(0x29,0x0000);
    writeLMX(0x28,0x0000);
    writeLMX(0x27,0x03E8);
    writeLMX(0x26,0x0000);
    writeLMX(0x25,0x0404);
    writeLMX(0x24,0x02EE);
    writeLMX(0x23,0x0004);
    writeLMX(0x22,0x0000);
    writeLMX(0x21,0x1E21);
    writeLMX(0x20,0x0393);
    writeLMX(0x1F,0x43EC);
    writeLMX(0x1E,0x318C);
    writeLMX(0x1D,0x318C);
    writeLMX(0x1C,0x0488);
    writeLMX(0x1B,0x0002);
    writeLMX(0x1A,0x0DB0);
    writeLMX(0x19,0x0624);
    writeLMX(0x18,0x071A);
    writeLMX(0x17,0x007C);
    writeLMX(0x16,0x0001);
    writeLMX(0x15,0x0401);
    writeLMX(0x14,0xCC48);
    writeLMX(0x13,0x27A6);
    writeLMX(0x12,0x0064);
    writeLMX(0x11,0x012C);
    writeLMX(0x10,0x0102);
    writeLMX(0xF,0x064F);
    writeLMX(0xE,0x1E70);
    writeLMX(0xD,0x4000);
    writeLMX(0xC,0x5001);
    writeLMX(0xB,0x0058);
    writeLMX(0xA,0x10D8);
    writeLMX(0x9,0x0604);
    writeLMX(0x8,0x6800);
    writeLMX(0x7,0x40B2);
    writeLMX(0x6,0xC802);
    writeLMX(0x5,0x00C8);
    writeLMX(0x4,0x0A43);
    writeLMX(0x3,0x0642);
    writeLMX(0x2,0x0500);
    writeLMX(0x1,0x0808);
    writeLMX(0x0,0x2418);

#endif

#if 1
    writeLMX(0x72,0x026F);
    writeLMX(0x71,0x0000);
    writeLMX(0x70,0x00DE);
    writeLMX(0x6F,0x0039);
    writeLMX(0x6E,0x0428);
    writeLMX(0x6D,0x9D7D);
    writeLMX(0x6C,0x00F2);
    writeLMX(0x6B,0x8801);
    writeLMX(0x6A,0x0007);
    writeLMX(0x69,0x4440);
    writeLMX(0x68,0x0000);
    writeLMX(0x67,0x0000);
    writeLMX(0x66,0x0000);
    writeLMX(0x65,0x0000);
    writeLMX(0x64,0x0000);
    writeLMX(0x63,0x0000);
    writeLMX(0x62,0x0000);
    writeLMX(0x61,0x0000);
    writeLMX(0x60,0x0000);
    writeLMX(0x5F,0x0000);
    writeLMX(0x5E,0x0000);
    writeLMX(0x5D,0x0000);
    writeLMX(0x5C,0x0000);
    writeLMX(0x5B,0x0000);
    writeLMX(0x5A,0x0000);
    writeLMX(0x59,0x0000);
    writeLMX(0x58,0x0000);
    writeLMX(0x57,0x0000);
    writeLMX(0x56,0x0000);
    writeLMX(0x55,0x0000);
    writeLMX(0x54,0x0000);
    writeLMX(0x53,0x0000);
    writeLMX(0x52,0x0000);
    writeLMX(0x51,0x0000);
    writeLMX(0x50,0x0000);
    writeLMX(0x4F,0x0000);
    writeLMX(0x4E,0x0064);
    writeLMX(0x4D,0x0000);
    writeLMX(0x4C,0x000C);
    writeLMX(0x4B,0x0800);
    writeLMX(0x4A,0x0000);
    writeLMX(0x49,0x003F);
    writeLMX(0x48,0x0001);
    writeLMX(0x47,0x0080);
    writeLMX(0x46,0xC350);
    writeLMX(0x45,0x0000);
    writeLMX(0x44,0x03E8);
    writeLMX(0x43,0x0000);
    writeLMX(0x42,0x01F4);
    writeLMX(0x41,0x0000);
    writeLMX(0x40,0x1388);
    writeLMX(0x3F,0x0000);
    writeLMX(0x3E,0x0322);
    writeLMX(0x3D,0x00A8);
    writeLMX(0x3C,0x09C4);
    writeLMX(0x3B,0x0001);
    writeLMX(0x3A,0x8001);
    writeLMX(0x39,0x0020);
    writeLMX(0x38,0x0000);
    writeLMX(0x37,0x0000);
    writeLMX(0x36,0x0000);
    writeLMX(0x35,0x0000);
    writeLMX(0x34,0x0420);
    writeLMX(0x33,0x0080);
    writeLMX(0x32,0x0000);
    writeLMX(0x31,0x4180);
    writeLMX(0x30,0x0300);
    writeLMX(0x2F,0x0300);
    writeLMX(0x2E,0x07FD);
    writeLMX(0x2D,0xC8DF);
    writeLMX(0x2C,0x1FA1);
    writeLMX(0x2B,0xED40);
    writeLMX(0x2A,0x7EA8);
    writeLMX(0x29,0x0000);
    writeLMX(0x28,0x0000);
    writeLMX(0x27,0xDA80);
    writeLMX(0x26,0xFD51);
    writeLMX(0x25,0x8404);
    writeLMX(0x24,0x0029);
    writeLMX(0x23,0x0004);
    writeLMX(0x22,0x0000);
    writeLMX(0x21,0x1E21);
    writeLMX(0x20,0x0393);
    writeLMX(0x1F,0x43EC);
    writeLMX(0x1E,0x318C);
    writeLMX(0x1D,0x318C);
    writeLMX(0x1C,0x0488);
    writeLMX(0x1B,0x0002);
    writeLMX(0x1A,0x0DB0);
    writeLMX(0x19,0x0624);
    writeLMX(0x18,0x071A);
    writeLMX(0x17,0x007C);
    writeLMX(0x16,0x0001);
    writeLMX(0x15,0x0401);
    writeLMX(0x14,0xCC48);
    writeLMX(0x13,0x2739);
    writeLMX(0x12,0x0064);
    writeLMX(0x11,0x012C);
    writeLMX(0x10,0x00DE);
    writeLMX(0x0F,0x064F);
    writeLMX(0x0E,0x1E70);
    writeLMX(0x0D,0x4000);
    writeLMX(0x0C,0x5001);
    writeLMX(0x0B,0x0018);
    writeLMX(0x0A,0x10D8);
    writeLMX(0x09,0x1604);
    writeLMX(0x08,0x6800);
    writeLMX(0x07,0x00B2);
    writeLMX(0x06,0x7802);
    writeLMX(0x05,0x03E8);
    writeLMX(0x04,0x0E43);
    writeLMX(0x03,0x0642);
    writeLMX(0x02,0x0500);
    writeLMX(0x01,0x080C);
    writeLMX(0x00,0x211C);

#endif


    // Constants
    writeLMX(43,0x0000);
    writeLMX(42,0x0000);
    writeLMX(38,0x0000);
    writeLMX(39,0x03E8);
    writeLMX(34,0x0000); //34 is MSB

    // PLL R = 1

//    writeLMX(0xB,0x0018);

//    for(k=0; k<50; ++k) {
//        __delay_cycles(50000);
//    }

    while(1)
   {
//        __delay_cycles(20000);

        writeLMX(0x0F,0x064F);
        writeLMX(0x08,0x7800);

// Lock at 7.01 GHz
#if 1
        writeLMX(45,0xC0DF);
        writeLMX(42,0x1954);
        writeLMX(43,0xFC40);
        writeLMX(39,0xDA80);
        writeLMX(38,0xFD51);
        writeLMX(36,0x0046); //36 is LSB
//            writeLMX(36,0x0096);
        writeLMX(20,0xF448);
        writeLMX(19,0x2723);
        writeLMX(16,0x00E8);
#endif




        // VCO Sel: 1
        // VCO Capctrl: 166
        // VCO DACISET: 258
#if 1

            __delay_cycles(2000);

//            writeLMX(0x0F,0x065F);
//            // Call function to lock at 7 GHz
            writeLMX(42,0x0000);
            writeLMX(43,0x0000);
            writeLMX(39,0xDA80);
            writeLMX(38,0xFD51);
            writeLMX(45,0xC0DF);
            writeLMX(36,0x0046);
            writeLMX(20,0xF448);
            writeLMX(19,0x2725);
//            __delay_cycles(5);

//            writeLMX(36,0x0098);
            writeLMX(0x0F,0x065F);
            writeLMX(16,0x00AE);
            __delay_cycles(5);
            writeLMX(0x0F,0x064F);



#endif

    //        while(1);

#if 0
      // Call function to lock at 3 GHz when using FSWP of Agilent

            writeLMX(45,0xC0DF);
            writeLMX(36,0x003C);
            writeLMX(20,0xE448);
            writeLMX(19,0x2714);
            writeLMX(16,0x00F9);

#endif

//            __delay_cycles(20000);

#if 0

            // Call function to switch to 7.01 GHz

            writeLMX(45,0xC0DF);
            writeLMX(42,0x1954);
            writeLMX(43,0xFC40);
            writeLMX(39,0xDA80);
            writeLMX(38,0xFD51);
            writeLMX(36,0x0046); //36 is LSB
//            writeLMX(36,0x0096);
            writeLMX(20,0xF448);
            writeLMX(19,0x2723);
            writeLMX(16,0x00E8);

#endif

#if 0
            writeLMX(45,0xC0DF);
            writeLMX(42,0x32A9);
            writeLMX(43,0xF880);
            writeLMX(39,0xDA80);
            writeLMX(38,0xFD51);
            writeLMX(36,0x003C);
            writeLMX(20,0xE448);
            writeLMX(19,0x2710);
            writeLMX(16,0x00F5);

#endif

            __delay_cycles(5000);
//            writeLMX(45,0xC0DF);
//            writeLMX(36,0x0046);
////            writeLMX(36,0x0098);
//            writeLMX(20,0xF448);
//            writeLMX(19,0x2725);
//            writeLMX(16,0x00AE);
//
//            writeLMX(45,0xC0DF);
//            writeLMX(42,0x1954);
//            writeLMX(43,0xFC40);
//            writeLMX(39,0xDA80);
//            writeLMX(38,0xFD51);
//            writeLMX(36,0x0046); //36 is LSB
////            writeLMX(36,0x0096);
//            writeLMX(20,0xF448);
//            writeLMX(19,0x2723);
//            writeLMX(16,0x00B0);
//
//            writeLMX(45,0xC0DF);
//            writeLMX(36,0x0046);
////            writeLMX(36,0x0098);
//            writeLMX(20,0xF448);
//            writeLMX(19,0x2725);
//            writeLMX(16,0x00AE);
//
//            writeLMX(45,0xC0DF);
//            writeLMX(42,0x1954);
//            writeLMX(43,0xFC40);
//            writeLMX(39,0xDA80);
//            writeLMX(38,0xFD51);
//            writeLMX(36,0x0046); //36 is LSB
////            writeLMX(36,0x0096);
//            writeLMX(20,0xF448);
//            writeLMX(19,0x2723);
//            writeLMX(16,0x00B0);











    }
}
