#include <stdint.h>
#include <stddef.h>

#include <xdc/std.h>
#include <xdc/runtime/Error.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Task.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>
#include <ti/display/Display.h>
#include <ti/drivers/ADC.h>
#include <sx126x_hal.h>
#include <sx126x.h>
/* Example/Board Header files */
#include "Board.h"

Task_Struct myTask;
#define THREADSTACKSIZE    1024
uint8_t myTaskStack[THREADSTACKSIZE];

uint16_t adcValue;


Semaphore_Handle adcSem;



/********** myThread **********/
Task_FuncPtr *myThread(void *arg0) {

//    ADC_Handle   adc;
//    ADC_Params   params;

    uint8_t buf[]={0x01};
     uint32_t rx_data;
     const  uint8_t *IC;
     uint8_t tt=1;
     uint8_t write_buffer[4]={0x05,0x06,0x07,0x08};
     uint8_t read_buffer[4]={0x00,0x00,0x00,0x00};
     sx126x_pkt_type_t pkt_type;
     sx126x_mod_params_lora_t mod_params_lora;
     sx126x_pkt_params_lora_t pkt_params_lora;
     sx126x_chip_status_t radio_status;
     sx126x_pkt_status_lora_t  pkt_status_lora;
     sx126x_rx_buffer_status_t rx_buffer_status;
     sx126x_irq_mask_t lora_irq;
     int16_t SSI;
     sx126x_errors_mask_t errors;
     sx126x_pa_cfg_params_t params1;
     mod_params_lora.bw=SX126X_LORA_BW_250;
     mod_params_lora.cr=SX126X_LORA_CR_4_5;
     mod_params_lora.ldro=0x00;
     mod_params_lora.sf=SX126X_LORA_SF9 ;


     pkt_params_lora.crc_is_on=true;
     pkt_params_lora.header_type=SX126X_LORA_PKT_EXPLICIT;
     pkt_params_lora.invert_iq_is_on=false;
     pkt_params_lora.pld_len_in_bytes=0x04;
     pkt_params_lora.preamble_len_in_symb=0x08;

     params1.device_sel=0x00;
    params1.hp_max=0x07;
     params1.pa_duty_cycle=0x04;
     params1.pa_lut=0x01;

     /* 1 second delay */
     uint32_t time = 1;
    Semaphore_Params semParams;

    Semaphore_Params_init(&semParams);
    adcSem = Semaphore_create(0, &semParams, Error_IGNORE);
    if(adcSem == NULL)
    {
        /* Semaphore_create() failed */
   //     Display_print0(dispHandle, 0, 0, "adcSem Semaphore creation failed\n");
        while (1);
    }

    /* Initialize ADC and GPIO drivers */
  //  GPIO_init();
//    ADC_init();



     /* Call driver init functions */
  //   GPIO_init();
     // I2C_init();
  //    SPI_init();
  //    SPI0_init();
     // UART_init();
     // Watchdog_init();
      /* install Button callback */
 //     GPIO_setConfig(KEY, GPIO_CFG_IN_PU | GPIO_CFG_IN_INT_FALLING);
   //   GPIO_setCallback(DIO1, DIO1_Callback);
  //    GPIO_setCallback(KEY, KEYCALLBACK);

      /* Enable interrupts */
 //     GPIO_enableInt(DIO1);
//      GPIO_enableInt(KEY);

     /* Configure the LED pin */
      sx126x_hal_reset();
    //  delay_us(200);
          //CDC_Transmit_FS(&tt, 0x01);
          /*-----------设置STDBY模式-------------*/

          /*  NSS(10);
              HAL_Delay(1);
              NSS(0);
              SPIWROneByte(0x80);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/
      GPIO_toggle(LED0);
      GPIO_toggle(LED0);
      sx126x_get_status( IC,  &radio_status );
  //    sx126x_get_status( IC,  &radio_status );
  //    sx126x_get_status( IC,  &radio_status );
      delay_us(100);
     delay_us(100);
         sx126x_set_standby(IC, SX126X_STANDBY_CFG_RC);
          delay_us(100);
    //      sx126x_get_device_errors(IC,  &errors );
     //     delay_us(100);

          /*-----------设置射频�?????关由DIO2控制-------------*/
          /*  NSS(0);
              SPIWROneByte(0x9D);
              SPIWROneByte(0x01);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/

         sx126x_set_dio2_as_rf_sw_ctrl(IC, true);
    //      delay_us(100);
          /*-----------设置芯片采用DCDC+LDO供电方式-------------*/
          /*  NSS(0);
              SPIWROneByte(0x96);
              SPIWROneByte(0x01);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/

         sx126x_set_reg_mode(IC, SX126X_REG_MODE_DCDC);
     //     delay_us(100);
          /*-----------设置包类型为LORA-------------*/

          /*  NSS(0);
              SPIWROneByte(0x8A);
              SPIWROneByte(0x01);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/
          /*-----------设置发射接收数据缓冲基地�?????-------------*/

          /*  NSS(0);
              SPIWROneByte(0x8F);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/
          sx126x_set_buffer_base_address(IC, 0x00, 0x00);
         delay_us(100);
         sx126x_set_pkt_type(IC, SX126X_PKT_TYPE_LORA);
        delay_us(100);
         sx126x_get_status( IC,  &radio_status );






          /*-----------设置射频频率�?????470M-------------*/

          /*  NSS(0);
              SPIWROneByte(0x86);
              SPIWROneByte(0x1D);
              SPIWROneByte(0x60);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/
          sx126x_set_rf_freq(IC, 470000000);
         delay_us(100);

          /*-----------设置发射功率20dB RampTime200us-------------*/

          /*NSS(0);
          SPIWROneByte(0x8E);
          SPIWROneByte(0x14);
          SPIWROneByte(0x02);
          HAL_Delay(1);
          NSS(1);
          HAL_Delay(1);*/
          sx126x_set_pa_cfg( IC, &params1 );

          delay_us(100);
          sx126x_set_tx_params(IC, 0x12, SX126X_RAMP_40_US);
          delay_us(100);

          /*-----------发�?�数据到缓存-------------*/

          /*  NSS(0);
              SPIWROneByte(0x0E);
              SPIWROneByte(0x00);
              SPIWROneByte(0x01);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);

              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/

          sx126x_write_buffer(IC, 0x00, write_buffer, 4);
          delay_us(100);



          /*-----------设置调制参数-------------*/

          /*  NSS(0);
              SPIWROneByte(0x8B);
              SPIWROneByte(0x09);
              SPIWROneByte(0x05);
              SPIWROneByte(0x01);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/

          sx126x_set_lora_mod_params(IC, &mod_params_lora);
          delay_us(100);
          /*-----------设置IRQ标志-------------*/

          /*  NSS(0);
              SPIWROneByte(0x08);
              SPIWROneByte(0x02);
              SPIWROneByte(0x01);
              SPIWROneByte(0x02);
              SPIWROneByte(0x01);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);*/
      //  sx126x_set_dio_irq_params(IC, 0x0201, 0x0201, 0x00, 0x00);
          sx126x_set_dio_irq_params(IC, 0xFFFF, 0xFFFF, 0x00, 0x00);
     //     delay_us(100);

          /*-----------设置包参�?????-------------*/

          /*  NSS(0);
              SPIWROneByte(0x8C);
              SPIWROneByte(0x00);
              SPIWROneByte(0x08);
              SPIWROneByte(0x00);
              SPIWROneByte(0x04);
              SPIWROneByte(0x01);
              SPIWROneByte(0x00);
              HAL_Delay(1);
              NSS(1);
              HAL_Delay(1);
          */
          sx126x_set_lora_pkt_params(IC, &pkt_params_lora);
          delay_us(100);
          sx126x_get_pkt_type(IC,&pkt_type);
         delay_us(100);

        sx126x_set_tx(IC,0x3FFFC);
   //   sx126x_set_rx(IC,0x3FFFC);
        delay_us(100);
         sx126x_get_device_errors(IC,  &errors );
          sx126x_get_status( IC,  &radio_status );
          delay_us(100);

          sx126x_get_irq_status(IC,&lora_irq);
          delay_us(100);
          sx126x_get_rx_buffer_status(IC,&rx_buffer_status);
          delay_us(100);
          sx126x_read_buffer(IC,0x00,&read_buffer,4);
          memcpy(&rx_data,read_buffer ,4);


          delay_us(100);
          sx126x_get_rssi_inst(IC,&SSI);
          delay_us(100);
          sx126x_get_lora_pkt_status( IC, &pkt_status_lora );
          delay_us(100);

    GPIO_toggle(LED0);
    GPIO_toggle(LED0);
    GPIO_toggle(LED0);
   // GPIO_setConfig(Board_GPIO_BUTTON0, GPIO_CFG_IN_PU | GPIO_CFG_IN_INT_FALLING);

    /* install Button callback */
 //   GPIO_setCallback(Board_GPIO_BUTTON0, gpioButtonFxn0);

    /* Enable interrupts */
  //  GPIO_enableInt(Board_GPIO_BUTTON0);

//    ADC_Params_init(&params);
  //  adc = ADC_open(Board_ADC0, &params);

  //  if (adc == NULL) {
       //     Display_printf(dispHandle, 6, 0, "Error initializing ADC channel 0\n");
 //           while (1);
 //   }

    while (1) {

        /* Pend on semaphore, tmp116Sem */
     //   Semaphore_pend(adcSem, BIOS_WAIT_FOREVER);

        /* Blocking mode conversion */
   //     ADC_convert(adc, &adcValue);
      //  Display_printf(dispHandle, 6, 0, "ADC value: %d\n", adcValue);
    }
}

/********** myThread_create **********/
void myThread_create(void) {
    Task_Params taskParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = myTaskStack;
    taskParams.stackSize = THREADSTACKSIZE;
    taskParams.priority = 2;

   Task_construct(&myTask, myThread, &taskParams, Error_IGNORE);
}
