/*********************************************************************
 * INCLUDES
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#if !(defined __TI_COMPILER_VERSION__)
#include <intrinsics.h>
#endif

#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>
#include <util.h>

#include <ti/drivers/PIN.h>

#include <ti/display/Display.h>

#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(driverlib/sys_ctrl.h)

/* Application specific includes */
#include "Startup/board.h"

#include "gprs.h"
#include "logging.h"

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * CONSTANTS
 */
// Task configuration
#define GPRS_TASK_PRIORITY                      3

#ifndef GPRS_TASK_STACK_SIZE
#define GPRS_TASK_STACK_SIZE                    4096
#endif

/*********************************************************************
 * TYPEDEFS
 */

/*********************************************************************
 * GLOBAL VARIABLES
 */
// Task configuration
Task_Struct gprsTask;
#if defined __TI_COMPILER_VERSION__
#pragma DATA_ALIGN(gprsTaskStack, 8)
#else
#pragma data_alignment=8
#endif

uint8_t gprsTaskStack[GPRS_TASK_STACK_SIZE];

Display_Handle dispHandle = NULL;

/*********************************************************************
 * LOCAL VARIABLES
 */

/*********************************************************************
 * LOCAL FUNCTIONS
 */

/*********************************************************************
 * @fn      gprs_taskFxn
 *
 * @brief   Application task entry point for the GPRS Task.
 *
 * @param   a0, a1 - not used.
 */
static void gprs_taskFxn(UArg a0, UArg a1)
{
  // Application main loop
  printf("[GPRS]: Waiting for GPRS UART task to start up (%s:%d)\n", __FILE__, __LINE__);

  dispHandle = Display_open(Display_Type_ANY, NULL);
}

/*********************************************************************
 * @fn      gprs_createTask
 *
 * @brief   Task creation function for the GPRS Task
 *
 * @param   gprsTaskConfig - Configuration of important module settings
 *                           with settings from FLASH memory
 */
void gprs_createTask ()
{
    Task_Params taskParams;

    // Configure task
    Task_Params_init(&taskParams);
    taskParams.stack = gprsTaskStack;
    taskParams.stackSize = GPRS_TASK_STACK_SIZE;
    taskParams.priority = GPRS_TASK_PRIORITY;

    Task_construct(&gprsTask, gprs_taskFxn, &taskParams, NULL);
}
