/*********************************************************************
 * INCLUDES
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

#include <time.h>
#include <ti/sysbios/hal/Seconds.h>

// Non-volatile storage driver
#include <ti/drivers/NVS.h>

#include "Startup/board.h"

#include "logging.h"

#include <icall.h>

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * CONSTANTS
 */

/*********************************************************************
 * TYPEDEFS
 */

/*********************************************************************
 * GLOBAL VARIABLES
 */

/*********************************************************************
 * LOCAL VARIABLES
 */

// NVS variables
static NVS_Handle nvsHandle;
static NVS_Attrs  nvsRegionAttrs;

/*********************************************************************
 * PROTOTYPES
 */

/*********************************************************************
 * LOCAL FUNCTIONS
 */

/*********************************************************************
 * @fn      LoggingInit
 *
 * @brief   Initializes everything that has to do with logging, like the
 *          non-volatile storage (NVS) driver.
 *          It also includes other functionalities that use that driver,
 *          like managing the device configuration.
 */
void LoggingInit ()
{
  uint8_t *pInitReadBuffer = ICall_malloc(0x1);
  if (!pInitReadBuffer)
  {
    printf("Could not allocate memory (%s:%d)\n", __FILE__, __LINE__);

    return;
  }

  // TODO Fix this
  memcpy((void *) pInitReadBuffer, (void *) 0x48000, 0x1);

  ICall_heapStats_t ICallheapStats;
  ICall_getHeapStats(&ICallheapStats);

  printf("0x%X\n", ICallheapStats.totalSize);

  /* NOTE: The below code will also not work
  uint16_t i;
  for (i = 0; i < nvsRegionAttrs.regionSize; i++)
  {
    memcpy((void *) (pInitBuffer + i), (nvsRegionAttrs.regionBase + i), 1);
  }
  */

  /* NOTE: The above memcpy is what is going wrong in the following nvs_read call:
  if (NVS_read(nvsHandle, 0, (void *) pInitBuffer, nvsRegionAttrs.regionSize) != NVS_STATUS_SUCCESS)
  {
    printf("Couldn't read from FLASH (%s:%d)\n", __FILE__, __LINE__);
  }
  */

  free(pInitReadBuffer);
}
