/*
 * Copyright (c) 2017-2018, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/** ===========================================================================
 *  @file       IPC_V2.h
 *
 *  @brief      IPC_V2 Board Specific header file.
 *
 *  The IPC_V2 header file should be included in an application as
 *  follows:
 *  @code
 *  #include "IPC_V2.h"
 *  @endcode
 *
 *  ===========================================================================
 */
#ifndef __IPC_V2_BOARD_H__
#define __IPC_V2_BOARD_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes */
#include <ti/drivers/PIN.h>
#include <ti/devices/cc13x2_cc26x2/driverlib/ioc.h>

/* Externs */
extern const PIN_Config BoardGpioInitTable[];

/* Defines */
#define IPC_V2

/* Mapping of pins to board signals using general board aliases
 *      <board signal alias>         <pin mapping>   <comments>
 */

/* Mapping of pins to board signals using general board aliases
 *      <board signal alias>                  <pin mapping>
 */
/* Analog Capable DIOs */
#define IPC_V2_DIO23_ANALOG          IOID_23
#define IPC_V2_DIO24_ANALOG          IOID_24
#define IPC_V2_DIO25_ANALOG          IOID_25
#define IPC_V2_DIO26_ANALOG          IOID_26
#define IPC_V2_DIO27_ANALOG          IOID_27
#define IPC_V2_DIO28_ANALOG          IOID_28
#define IPC_V2_DIO29_ANALOG          IOID_29

/* Digital IOs */
#define IPC_V2_DIO12                 IOID_12
#define IPC_V2_DIO15                 IOID_15
#define IPC_V2_DIO16_TDO             IOID_16
#define IPC_V2_DIO17_TDI             IOID_17
#define IPC_V2_DIO21                 IOID_21
#define IPC_V2_DIO22                 IOID_22
#define IPC_V2_DIO30                 IOID_30

/* Discrete Inputs */
#define IPC_V2_PIN_SW1               IOID_15

/* GPIO */
#define IPC_V2_GPIO_LED_ON           1
#define IPC_V2_GPIO_LED_OFF          0

/* I2C */
#define IPC_V2_I2C0_SCL0             IOID_4
#define IPC_V2_I2C0_SDA0             IOID_5

/* I2S */
#define IPC_V2_I2S_ADO               IOID_25
#define IPC_V2_I2S_ADI               IOID_26
#define IPC_V2_I2S_BCLK              IOID_27
#define IPC_V2_I2S_MCLK              PIN_UNASSIGNED
#define IPC_V2_I2S_WCLK              IOID_28

/* LEDs */
#define IPC_V2_PIN_WDC_LED           IOID_30

/* Factory default jumper */
#define IPC_V2_PIN_JMP1              IOID_5

/* PWM Outputs */
#define IPC_V2_PWMPIN0               IPC_V2_PIN_WDC_LED
#define IPC_V2_PWMPIN1               PIN_UNASSIGNED
#define IPC_V2_PWMPIN2               PIN_UNASSIGNED
#define IPC_V2_PWMPIN3               PIN_UNASSIGNED
#define IPC_V2_PWMPIN4               PIN_UNASSIGNED
#define IPC_V2_PWMPIN5               PIN_UNASSIGNED
#define IPC_V2_PWMPIN6               PIN_UNASSIGNED
#define IPC_V2_PWMPIN7               PIN_UNASSIGNED

/* SPI */
#define IPC_V2_SPI_FLASH_CS          IOID_20
#define IPC_V2_FLASH_CS_ON           0
#define IPC_V2_FLASH_CS_OFF          1

/* SPI Board */
#define IPC_V2_SPI0_MISO             IOID_8          /* RF1.20 */
#define IPC_V2_SPI0_MOSI             IOID_9          /* RF1.18 */
#define IPC_V2_SPI0_CLK              IOID_10         /* RF1.16 */
#define IPC_V2_SPI0_CSN              PIN_UNASSIGNED
#define IPC_V2_SPI1_MISO             PIN_UNASSIGNED
#define IPC_V2_SPI1_MOSI             PIN_UNASSIGNED
#define IPC_V2_SPI1_CLK              PIN_UNASSIGNED
#define IPC_V2_SPI1_CSN              PIN_UNASSIGNED

/* UART Board */
#define IPC_V2_UART_RS485            IPC_V2_UART0
#define IPC_V2_UART0_RX              IOID_13         /* RXD */
#define IPC_V2_UART0_TX              IOID_12         /* TXD */
#define IPC_V2_UART_RS485_EN_TX      IOID_14         /* Enable TXD */

#define IPC_V2_UART_GPRS             IPC_V2_UART1
#define IPC_V2_UART1_RX              IOID_7
#define IPC_V2_UART1_TX              IOID_6
#define IPC_V2_UART1_CTS             IOID_25
#define IPC_V2_UART1_RTS             IOID_26
#define IPC_V2_GPRS_PWR              IOID_24
#define IPC_V2_GPRS_EN               IOID_3

/* For backward compatibility */
#define IPC_V2_UART_RX               IPC_V2_UART0_RX
#define IPC_V2_UART_TX               IPC_V2_UART0_TX
#define IPC_V2_UART_CTS              IPC_V2_UART0_CTS
#define IPC_V2_UART_RTS              IPC_V2_UART0_RTS

/*!
 *  @brief  Initialize the general board specific settings
 *
 *  This function initializes the general board specific settings.
 */
void IPC_V2_initGeneral(void);

/*!
 *  @brief  Shut down the external flash present on the board files
 *
 *  This function bitbangs the SPI sequence necessary to turn off
 *  the external flash on LaunchPads.
 */
void IPC_V2_shutDownExtFlash(void);

/*!
 *  @brief  Wake up the external flash present on the board files
 *
 *  This function toggles the chip select for the amount of time needed
 *  to wake the chip up.
 */
void IPC_V2_wakeUpExtFlash(void);

/*!
 *  @def    IPC_V2_ADCBufName
 *  @brief  Enum of ADCs
 */
typedef enum IPC_V2_ADCBufName {
    IPC_V2_ADCBUF0 = 0,

    IPC_V2_ADCBUFCOUNT
} IPC_V2_ADCBufName;

/*!
 *  @def    IPC_V2_ADCBuf0SourceName
 *  @brief  Enum of ADCBuf channels
 */
typedef enum IPC_V2_ADCBuf0ChannelName {
    IPC_V2_ADCBUF0CHANNEL0 = 0,
    IPC_V2_ADCBUF0CHANNEL1,
    IPC_V2_ADCBUF0CHANNEL2,
    IPC_V2_ADCBUF0CHANNEL3,
    IPC_V2_ADCBUF0CHANNEL4,
    IPC_V2_ADCBUF0CHANNEL5,
    IPC_V2_ADCBUF0CHANNEL6,
    IPC_V2_ADCBUF0CHANNELVDDS,
    IPC_V2_ADCBUF0CHANNELDCOUPL,
    IPC_V2_ADCBUF0CHANNELVSS,

    IPC_V2_ADCBUF0CHANNELCOUNT
} IPC_V2_ADCBuf0ChannelName;

/*!
 *  @def    IPC_V2_ADCName
 *  @brief  Enum of ADCs
 */
typedef enum IPC_V2_ADCName {
    IPC_V2_ADC4 = 0,
    IPC_V2_ADC5,

    IPC_V2_ADCCOUNT
} IPC_V2_ADCName;

/*!
 *  @def    IPC_V2_ECDHName
 *  @brief  Enum of ECDH names
 */
typedef enum IPC_V2_ECDHName {
    IPC_V2_ECDH0 = 0,

    IPC_V2_ECDHCOUNT
} IPC_V2_ECDHName;

/*!
 *  @def    IPC_V2_ECDSAName
 *  @brief  Enum of ECDSA names
 */
typedef enum IPC_V2_ECDSAName {
    IPC_V2_ECDSA0 = 0,

    IPC_V2_ECDSACOUNT
} IPC_V2_ECDSAName;

/*!
 *  @def    IPC_V2_ECJPAKEName
 *  @brief  Enum of ECJPAKE names
 */
typedef enum IPC_V2_ECJPAKEName {
    IPC_V2_ECJPAKE0 = 0,

    IPC_V2_ECJPAKECOUNT
} IPC_V2_ECJPAKEName;

/*!
 *  @def    IPC_V2_AESCCMName
 *  @brief  Enum of AESCCM names
                IPC_V2_AESCCM0 = 0 \\ BLE
                IPC_V2_AESCCM1 = 1 \\ TIMAC
                etc...
 */
typedef enum IPC_V2_AESCCMName {
    IPC_V2_AESCCM0 = 0,

    IPC_V2_AESCCMCOUNT
} IPC_V2_AESCCMName;

/*!
 *  @def    IPC_V2_AESGCMName
 *  @brief  Enum of AESGCM names
 */
typedef enum IPC_V2_AESGCMName {
    IPC_V2_AESGCM0 = 0,

    IPC_V2_AESGCMCOUNT
} IPC_V2_AESGCMName;

/*!
 *  @def    IPC_V2_AESCBCName
 *  @brief  Enum of AESCBC names
 */
typedef enum IPC_V2_AESCBCName {
    IPC_V2_AESCBC0 = 0,

    IPC_V2_AESCBCCOUNT
} IPC_V2_AESCBCName;

/*!
 *  @def    IPC_V2_AESCTRName
 *  @brief  Enum of AESCTR names
 */
typedef enum IPC_V2_AESCTRName {
    IPC_V2_AESCTR0 = 0,

    IPC_V2_AESCTRCOUNT
} IPC_V2_AESCTRName;

/*!
 *  @def    IPC_V2_AESECBName
 *  @brief  Enum of AESECB names
 */
typedef enum IPC_V2_AESECBName {
    IPC_V2_AESECB0 = 0,

    IPC_V2_AESECBCOUNT
} IPC_V2_AESECBName;

/*!
 *  @def    IPC_V2_AESCTRDRBGName
 *  @brief  Enum of AESCTRDRBG names
 */
typedef enum IPC_V2_AESCTRDRBGName {
    IPC_V2_AESCTRDRBG0 = 0,

    IPC_V2_AESCTRDRBGCOUNT
} IPC_V2_AESCTRDRBGName;

/*!
 *  @def    IPC_V2_SHA2Name
 *  @brief  Enum of SHA2 names
 */
typedef enum IPC_V2_SHA2Name {
    IPC_V2_SHA20 = 0,

    IPC_V2_SHA2COUNT
} IPC_V2_SHA2Name;

/*!
 *  @def    IPC_V2_TRNGName
 *  @brief  Enum of TRNG names
 */
typedef enum IPC_V2_TRNGName {
    IPC_V2_TRNG0 = 0,

    IPC_V2_TRNGCOUNT
} IPC_V2_TRNGName;

/*!
 *  @def    IPC_V2_GPIOName
 *  @brief  Enum of GPIO names
 */
typedef enum IPC_V2_GPIOName {
    IPC_V2_GPIO_S1 = 0,
    IPC_V2_GPIO_S2,
    IPC_V2_SPI_MASTER_READY,
    IPC_V2_SPI_SLAVE_READY,
    IPC_V2_GPIO_LED_GREEN,
    IPC_V2_GPIO_LED_RED,
    IPC_V2_GPIO_TMP116_EN,
    IPC_V2_GPIO_SPI_FLASH_CS,
    IPC_V2_SDSPI_CS,
    IPC_V2_GPIO_LCD_CS,
    IPC_V2_GPIO_LCD_POWER,
    IPC_V2_GPIO_LCD_ENABLE,
    IPC_V2_GPIOCOUNT
} IPC_V2_GPIOName;

/*!
 *  @def    IPC_V2_GPTimerName
 *  @brief  Enum of GPTimer parts
 */
typedef enum IPC_V2_GPTimerName {
    IPC_V2_GPTIMER0A = 0,
    IPC_V2_GPTIMER0B,
    IPC_V2_GPTIMER1A,
    IPC_V2_GPTIMER1B,
    IPC_V2_GPTIMER2A,
    IPC_V2_GPTIMER2B,
    IPC_V2_GPTIMER3A,
    IPC_V2_GPTIMER3B,

    IPC_V2_GPTIMERPARTSCOUNT
} IPC_V2_GPTimerName;

/*!
 *  @def    IPC_V2_GPTimers
 *  @brief  Enum of GPTimers
 */
typedef enum IPC_V2_GPTimers {
    IPC_V2_GPTIMER0 = 0,
    IPC_V2_GPTIMER1,
    IPC_V2_GPTIMER2,
    IPC_V2_GPTIMER3,

    IPC_V2_GPTIMERCOUNT
} IPC_V2_GPTimers;

/*!
 *  @def    IPC_V2_I2CName
 *  @brief  Enum of I2C names
 */
typedef enum IPC_V2_I2CName {
    IPC_V2_I2C0 = 0,

    IPC_V2_I2CCOUNT
} IPC_V2_I2CName;

/*!
 *  @def    IPC_V2_I2SName
 *  @brief  Enum of I2S names
 */
typedef enum IPC_V2_I2SName {
    IPC_V2_I2S0 = 0,

    IPC_V2_I2SCOUNT
} IPC_V2_I2SName;

/*!
 *  @def    IPC_V2_PDMName
 *  @brief  Enum of I2S names
 */
typedef enum IPC_V2_PDMCOUNT {
    IPC_V2_PDM0 = 0,

    IPC_V2_PDMCOUNT
} IPC_V2_PDMName;

/*!
 *  @def    IPC_V2_NVSName
 *  @brief  Enum of NVS names
 */
typedef enum IPC_V2_NVSName {
#ifndef Board_EXCLUDE_NVS_INTERNAL_FLASH
    IPC_V2_NVSCC26XX0 = 0,
    IPC_V2_NVSCC26XX1,
    IPC_V2_NVSCC26XX2,
    IPC_V2_NVSCC26XX3,
    IPC_V2_NVSCC26XX4,
#endif

    IPC_V2_NVSCOUNT
} IPC_V2_NVSName;

/*!
 *  @def    IPC_V2_PWM
 *  @brief  Enum of PWM outputs
 */
typedef enum IPC_V2_PWMName {
    IPC_V2_PWM0 = 0,
    IPC_V2_PWM1,
    IPC_V2_PWM2,
    IPC_V2_PWM3,
    IPC_V2_PWM4,
    IPC_V2_PWM5,
    IPC_V2_PWM6,
    IPC_V2_PWM7,

    IPC_V2_PWMCOUNT
} IPC_V2_PWMName;

/*!
 *  @def    IPC_V2_SDName
 *  @brief  Enum of SD names
 */
typedef enum IPC_V2_SDName {
    IPC_V2_SDSPI0 = 0,

    IPC_V2_SDCOUNT
} IPC_V2_SDName;

/*!
 *  @def    IPC_V2_SPIName
 *  @brief  Enum of SPI names
 */
typedef enum IPC_V2_SPIName {
    IPC_V2_SPI0 = 0,
    IPC_V2_SPI1,

    IPC_V2_SPICOUNT
} IPC_V2_SPIName;

/*!
 *  @def    IPC_V2_UARTName
 *  @brief  Enum of UARTs
 */
typedef enum IPC_V2_UARTName {
    IPC_V2_UART0 = 0,
    IPC_V2_UART1,

    IPC_V2_UARTCOUNT
} IPC_V2_UARTName;

/*!
 *  @def    IPC_V2_UDMAName
 *  @brief  Enum of DMA buffers
 */
typedef enum IPC_V2_UDMAName {
    IPC_V2_UDMA0 = 0,

    IPC_V2_UDMACOUNT
} IPC_V2_UDMAName;

/*!
 *  @def    IPC_V2_WatchdogName
 *  @brief  Enum of Watchdogs
 */
typedef enum IPC_V2_WatchdogName {
    IPC_V2_WATCHDOG0 = 0,

    IPC_V2_WATCHDOGCOUNT
} IPC_V2_WatchdogName;


#ifdef __cplusplus
}
#endif

#endif /* __IPC_V2_BOARD_H__ */
