/*
 * Copyright (c) 2017-2018, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __BOARD_H
#define __BOARD_H

#define Board_IPC_V2

#ifdef __cplusplus
extern "C" {
#endif

#include <ti/drivers/Board.h>

#define Board_initGeneral()     Board_init()  /* deprecated */

#include "IPC_V2.h"

#define Board_shutDownExtFlash() IPC_V2_shutDownExtFlash()
#define Board_wakeUpExtFlash()   IPC_V2_wakeUpExtFlash()

/* These #defines allow us to reuse TI-RTOS across other device families */

#define Board_ADC0              IPC_V2_ADC4
#define Board_ADC1              IPC_V2_ADC5

#define Board_ADCBUF0           IPC_V2_ADCBUF0
#define Board_ADCBUF0CHANNEL0   IPC_V2_ADCBUF0CHANNEL0
#define Board_ADCBUF0CHANNEL1   IPC_V2_ADCBUF0CHANNEL1

#define Board_ECDH0             IPC_V2_ECDH0
#define Board_ECDSA0            IPC_V2_ECDSA0
#define Board_ECJPAKE0          IPC_V2_ECJPAKE0
#define Board_AESCCM0           IPC_V2_AESCCM0
#define Board_AESGCM0           IPC_V2_AESGCM0
#define Board_AESCBC0           IPC_V2_AESCBC0
#define Board_AESCTR0           IPC_V2_AESCTR0
#define Board_AESECB0           IPC_V2_AESECB0
#define Board_AESCTRDRBG0       IPC_V2_AESCTRDRBG0
#define Board_SHA20             IPC_V2_SHA20
#define Board_TRNG0             IPC_V2_TRNG0

#define Board_DIO12             IPC_V2_DIO12
#define Board_DIO15             IPC_V2_DIO15
#define Board_DIO16_TDO         IPC_V2_DIO16_TDO
#define Board_DIO17_TDI         IPC_V2_DIO17_TDI
#define Board_DIO21             IPC_V2_DIO21
#define Board_DIO22             IPC_V2_DIO22

#define Board_DIO23_ANALOG      IPC_V2_DIO23_ANALOG
#define Board_DIO24_ANALOG      IPC_V2_DIO24_ANALOG
#define Board_DIO25_ANALOG      IPC_V2_DIO25_ANALOG
#define Board_DIO26_ANALOG      IPC_V2_DIO26_ANALOG
#define Board_DIO27_ANALOG      IPC_V2_DIO27_ANALOG
#define Board_DIO28_ANALOG      IPC_V2_DIO28_ANALOG
#define Board_DIO29_ANALOG      IPC_V2_DIO29_ANALOG

/*
 *  Board_RF_SUB1GHZ is the name generated by SysConfig. Define it
 *  here so that RF callback function can reference it.
 */
#define Board_RF_SUB1GHZ        IPC_V2_DIO30_RF_SUB1GHZ

#define Board_GPIO_BUTTON0      IPC_V2_GPIO_S1
#define Board_GPIO_BUTTON1      IPC_V2_GPIO_S2
#define Board_GPIO_BTN1         IPC_V2_GPIO_S1
#define Board_GPIO_BTN2         IPC_V2_GPIO_S2
#define Board_GPIO_LED0         IPC_V2_GPIO_LED_RED
#define Board_GPIO_LED1         IPC_V2_GPIO_LED_GREEN
#define Board_GPIO_LED2         IPC_V2_GPIO_LED_RED
#define Board_GPIO_RLED         IPC_V2_GPIO_LED_RED
#define Board_GPIO_GLED         IPC_V2_GPIO_LED_GREEN
#define Board_GPIO_LED_ON       IPC_V2_GPIO_LED_ON
#define Board_GPIO_LED_OFF      IPC_V2_GPIO_LED_OFF
#define Board_GPIO_TMP116_EN    IPC_V2_GPIO_TMP116_EN

#define Board_GPTIMER0A         IPC_V2_GPTIMER0A
#define Board_GPTIMER0B         IPC_V2_GPTIMER0B
#define Board_GPTIMER1A         IPC_V2_GPTIMER1A
#define Board_GPTIMER1B         IPC_V2_GPTIMER1B
#define Board_GPTIMER2A         IPC_V2_GPTIMER2A
#define Board_GPTIMER2B         IPC_V2_GPTIMER2B
#define Board_GPTIMER3A         IPC_V2_GPTIMER3A
#define Board_GPTIMER3B         IPC_V2_GPTIMER3B

#define Board_I2C0              IPC_V2_I2C0
#define Board_I2C_TMP           Board_I2C0

#define Board_I2S0              IPC_V2_I2S0
#define Board_I2S_ADO           IPC_V2_I2S_ADO
#define Board_I2S_ADI           IPC_V2_I2S_ADI
#define Board_I2S_BCLK          IPC_V2_I2S_BCLK
#define Board_I2S_MCLK          IPC_V2_I2S_MCLK
#define Board_I2S_WCLK          IPC_V2_I2S_WCLK

#define Board_NVSINTERNAL           IPC_V2_NVSCC26XX0
#define Board_NVS_IPC_CONFIG        IPC_V2_NVSCC26XX1
#define Board_NVS_IPC_CONFIG_BACKUP IPC_V2_NVSCC26XX2
#define Board_NVS_IPC_LOGBUFFER     IPC_V2_NVSCC26XX3
#define Board_NVS_IPC_ALARMBUFFER   IPC_V2_NVSCC26XX4
#define Board_NVSEXTERNAL           IPC_V2_NVSSPI25X0

#define Board_PIN_SW1_BLE       IPC_V2_PIN_SW1
#define Board_PIN_BUTTON1       PIN_UNASSIGNED

#define Board_PIN_WDC_LED       IPC_V2_PIN_WDC_LED

#define Board_PIN_JMP1          IPC_V2_PIN_JMP1

#define Board_PWM0              IPC_V2_PWM0
#define Board_PWM1              IPC_V2_PWM1
#define Board_PWM2              IPC_V2_PWM2
#define Board_PWM3              IPC_V2_PWM3
#define Board_PWM4              IPC_V2_PWM4
#define Board_PWM5              IPC_V2_PWM5
#define Board_PWM6              IPC_V2_PWM6
#define Board_PWM7              IPC_V2_PWM7

#define Board_SD0               IPC_V2_SDSPI0

#define Board_SPI0              IPC_V2_SPI0
#define Board_SPI1              IPC_V2_SPI1
#define Board_SPI_FLASH_CS      IPC_V2_SPI_FLASH_CS
#define Board_FLASH_CS_ON       0
#define Board_FLASH_CS_OFF      1

#define Board_SPI_MASTER        IPC_V2_SPI0
#define Board_SPI_SLAVE         IPC_V2_SPI0
#define Board_SPI_MASTER_READY  IPC_V2_SPI_MASTER_READY
#define Board_SPI_SLAVE_READY   IPC_V2_SPI_SLAVE_READY

#define Board_UART0             IPC_V2_UART0
#define Board_UART1             IPC_V2_UART1

#define Board_WATCHDOG0         IPC_V2_WATCHDOG0

#ifdef __cplusplus
}
#endif

#endif /* __BOARD_H */
