/*
 * Copyright (c) 2015-2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== empty.c ========
 */

 /* POSIX Header files */
  #include <pthread.h>

 /* RTOS header files */
  #include <FreeRTOS.h>
  #include <task.h>

  /* Stack size in bytes */
  #define THREADSTACKSIZE 1024

/* For usleep() */
#include <unistd.h>
#include <stdint.h>
#include <stddef.h>
/* Driver Header files */
#include <ti/drivers/GPIO.h>
// #include <ti/drivers/I2C.h>
// #include <ti/drivers/SPI.h>
// #include <ti/drivers/Watchdog.h>
#include <ti/drivers/timer/LGPTimerLPF3.h>

/* Driver configuration */
#include "ti_drivers_config.h"
#include <ti/bleapp/menu_module/menu_module.h>

//float IRData[1000];
//uint8_t l = 0, r = 0;
//uint16_t capture_counter;
//typedef enum nec_frame_state_t
//    {
//        NEC_STATE_IDLE,
//        NEC_STATE_START,
//        NEC_STATE_RESTART_GAP,
//        NEC_STATE_RESTART_COMMAND
//    }nec_frame_state_t;
//typedef enum timer_capture_command_t
//    {
//        NEC_BIT_0=0,
//        NEC_BIT_1=1,
//        NEC_START,
//        NEC_RESTART_GAP,
//        NEC_RESTART_COMMAND,
//        NEC_OVERFLOW
//    }timer_capture_command_t;
//
//static nec_frame_state_t nec_frame_state_e;
//static uint8_t nec_frame_receive_index;
//static uint32_t nec_received_command;
//
//timer_capture_command_t timerCallback(LGPTimerLPF3_Handle lgptHandle, LGPTimerLPF3_IntMask interruptMask) {
//    // interrupt callback code goes here. Minimize processing in interrupt.
//    capture_counter = LGPTimerLPF3_getNextChCaptureVal(lgptHandle, LGPTimerLPF3_CH_NO_0);
//
//        timer_capture_command_t cammand_capture;
//        cammand_capture = NEC_OVERFLOW;
//
//        if(capture_counter> 2*0x69 && capture_counter< 2*0xAF )       //133-147   //532.5 - 590 // 561.25us+/-5%
//        {
//            cammand_capture = NEC_BIT_0;
//        }
//        else if(capture_counter> 2*0xD2 && capture_counter< 2*0x15F )  //267-295  //1601.25-1770 //1687.5us +/-5%
//        {
//            cammand_capture = NEC_BIT_1;
//        }
//        else if(capture_counter> 2*0x5EE && capture_counter< 2*0x740 )  //1603-1772 //12825-14174  //13.5ms +/-5%
//        {
//            cammand_capture = NEC_START;
//        }
//        else if(capture_counter> 2*0x2A84  && capture_counter< 2*0x38B0 ) //5076-5610 //40610-44885 //  41ms +/- 5%
//        {
//            cammand_capture = NEC_RESTART_GAP;
//        }
//        else if(capture_counter> 2*0x15C0 && capture_counter< 2*0x1A96 )  //11489-13303 //91910-106425 //99167.5us
//        {
//            cammand_capture = NEC_RESTART_GAP;
//        }
//        else if(capture_counter> 2*0x4F1 && capture_counter< 2*0x60A )  //1335-1476 //10685-11810 //11.8ms +/-5%
//        {
//            cammand_capture = NEC_RESTART_COMMAND;
//        }
//
//        return cammand_capture ;
//}
//
//void pop(){
//
//    l += 1;
//}

void gpioFxn0(uint_least8_t index)
{
    // Toggle the LED
    GPIO_toggle(CONFIG_GPIO_LED_0);
}
/*
 *  ======== mainThread ========
 */
/*
 *  ======== mainThread ========
 */
void *mainThread(void *arg0)
{
    /* 1 second delay */
    uint32_t time = 1;

    /* Call driver init functions */
    GPIO_init();
    // I2C_init();
    // SPI_init();
    // Watchdog_init();

    /* Configure the LED pin */
    GPIO_setConfig(CONFIG_GPIO_LED_0, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_LOW);
    GPIO_setConfig(CONFIG_GPIO_0,GPIO_CFG_IN_PD | GPIO_CFG_IN_INT_BOTH_EDGES);
    GPIO_setCallback(CONFIG_GPIO_0,gpioFxn0);
    GPIO_enableInt(CONFIG_GPIO_0);

//    GPIO_setConfig(CONFIG_LGPTIMER_0_CONST,GPIO_CFG_IN_INT_BOTH_EDGES | GPIO_CFG_IN_PD);
//    /* Turn on user LED */
//    GPIO_write(CONFIG_GPIO_LED_0, CONFIG_GPIO_LED_ON);

//    LGPTimerLPF3_Handle lgptHandle;
//       LGPTimerLPF3_Params params;
//       uint32_t cntTargetVal = 96000000;
//       uint32_t chCompVal    = cntTargetVal/2;
//       // Configure channel 2 action
//       LGPTimerLPF3_Params_init(&params);
//       params.channelProperty[2].action = LGPTimerLPF3_CH_TOGGLE_ON_COMPARE_PERIODIC;
//       params.hwiCallbackFxn = timerCallback;
//       // Open driver
//       lgptHandle = LGPTimerLPF3_open(0, &params);
//       // Set channel output signal period
//       LGPTimerLPF3_setInitialCounterTarget(lgptHandle, cntTargetVal-1, true);
//       // Set channel output signal duty cycle
//       LGPTimerLPF3_setInitialChannelCompVal(lgptHandle, LGPTimerLPF3_CH_NO_2, chCompVal, true);
//       // Start the LGPTimer in up-down-periodic mode
//
//       // Enable counter target interrupt
//       LGPTimerLPF3_enableInterrupt(lgptHandle, LGPTimerLPF3_INT_TGT|LGPTimerLPF3_INT_CH2_CC);



    while (1)
    {
//        timer_capture_command_t received_bit_e = timerCallback(lgptHandle,LGPTimerLPF3_INT_CH0_CC);
//       switch(nec_frame_state_e)
//           {
//               case NEC_STATE_IDLE:
//                   if(received_bit_e == NEC_START){
//                       nec_frame_state_e = NEC_STATE_START;
//                       nec_frame_receive_index = 32;
//                       nec_received_command = 0;
//                       MenuModule_printf(1,0,"Start Pulse Recieved!");
//                   }
//                   break;
//
//               case NEC_STATE_START:
//                   if((received_bit_e == NEC_BIT_0)||(received_bit_e == NEC_BIT_1)){
//                       nec_received_command |= ((uint32_t)received_bit_e << ((nec_frame_receive_index--)-1));
//                       if(nec_frame_receive_index==0){
//                           nec_frame_state_e = NEC_STATE_RESTART_GAP;
//
//                           MenuModule_printf(0,0,"Recieved Command : 0x%x",nec_received_command);
//
//                           nec_frame_state_e = NEC_STATE_IDLE;
//                       }
//
//                   }
//                   nec_frame_state_e = NEC_STATE_IDLE;
//                   break;
//
//               case NEC_STATE_RESTART_GAP:
//                   nec_frame_state_e = NEC_STATE_IDLE;
//                   if(received_bit_e == NEC_RESTART_GAP){
//                       nec_frame_state_e = NEC_STATE_RESTART_COMMAND;
//                   }
//                   break;
//
//               case NEC_STATE_RESTART_COMMAND:
//                   if(received_bit_e==NEC_RESTART_COMMAND){
//                       nec_frame_state_e = NEC_STATE_RESTART_GAP;
//                       //return ((uint8_t)nec_received_command);
//               }// no break used for using the fallthrough
//               default:
//                   nec_frame_state_e = NEC_STATE_IDLE;
//                   break;
//           }
//
//        GPIO_toggle(CONFIG_GPIO_LED_0);
    }
}

void emptyMain(void)
{
    pthread_t thread;
    pthread_attr_t attrs;
    struct sched_param priParam;
    int retc;

    /* Initialize the attributes structure with default values */
    pthread_attr_init(&attrs);

    /* Set priority, detach state, and stack size attributes */
    priParam.sched_priority = 5; // Lower the priority of this task
    retc = pthread_attr_setschedparam(&attrs, &priParam);
    retc |= pthread_attr_setdetachstate(&attrs, PTHREAD_CREATE_DETACHED);
    retc |= pthread_attr_setstacksize(&attrs, THREADSTACKSIZE);
    if (retc != 0)
    {
        /* failed to set attributes */
        while (1) {}
    }

    retc = pthread_create(&thread, &attrs, mainThread, NULL);
    if (retc != 0)
    {
        /* pthread_create() failed */
        while (1) {}
    }
}
