# SSB Always Boot
This project shows how to setup a project in which the Secondary Secure
Bootloader (SSB) will always boot upon a reset or power-on. The default behavior
of Secure Boot *only* invokes the SSB if a valid image is not present on the
device or if the application invokes the SSB via HAPI APIs. 

In order to get around this, only the SSB is defined, and the other two
application images are not signed via Secure Boot. This has two implications:
1. From Secure Boot's perspective, there are *no* valid Secure Boot images on
   the device.
2. Any verification of the images must occur via an implementation in the SSB.

Three Projects are provided:
1. SSB
    * This project contains the SSB implementation that allows you to jump
      between the *Primary* and *Secondary* images. 
    * This SSB example does not implement verification of those images, since
      the verification method would be up to the developer to implement.
    * Taking a look at the .syscfg file contained in this project, the Security
      Configuration has been modified to *not* define the Primary and Secondary
      Slots. This was done intentionally, so that Secure Boot does not expect
      any Primary or Secondary slot Secure Boot images.
    * The function that is used to jump between images is the following:

``` C
static __attribute__((naked)) void start_app(uint32_t *vector_table)
{
    __asm volatile ("ldr r1, [r0, #0]\n"
    "msr msp, r1\n"
    "ldr r1, [r0, #4]\n"
    "mov pc, r1\n");
}
```

2. Primary
    * This project blinks the red LED on the CC2745 EVM.
    * This project's linker file has been modified to be linked to address
      `0x7000` with a Flash Size of `0x32000`.
    * The modifications can be seen in the *lpf3_freertos.cmd* file.
3. Secondary
    * This project blinks the green LED on the CC2745 EVM.
    * This project's linker file has been modified to be linked to address
      `0x39000` with a Flash Size of `0x32000`.
    * The modifications can be seen in the *lpf3_freertos.cmd* file.

# Prerequisites  
You must ensure that the HSM firmware has been loaded prior to loading any
Secure Boot enabled images.

You can ensure the HSM has been flashed on the device via Uniflash:
1. In Uniflash, open a session and connect to the CC2745 EVM.

![Uniflash](images/cc2745_select.png "CC2745 EVM")

2. In **Settings & Utilities** tab and click the **Read HSM System Information**
   button. 

![Uniflash](images/uniflash_hsm_check.png "Settings & Utilities :: HSM Firmware")

3. If the HSM firmware is loaded, then the HSM firmware information should
   populate. If it states ```HSM Failed to boot``` you must flash the HSM
   firmware before continuing.

   * Refer to the [HSM page](https://dev.ti.com/tirex/content/simplelink_lowpower_f3_sdk_9_10_00_83/docs/ble5stack/ble_user_guide/html/cc23xx/hsm-programming-guide-cc27xx.html?highlight=hsm#id3)
     for information on flashing the HSM firmware.

# Flashing the Projects

**NOTE**: *You may receive the following error message below when flashing. You can **ignore** this message.*

![Uniflash](images/error.png "Error Message")

1. First compile and build the projects.
   * Many images will be generated, however only three are needed:
     1. ```SSB_sb.hex```
     2. ```primary.bin```
     3. ```secondary.bin```

3. First flash the `SSB_sb.hex` file.

![Uniflash](images/ssb_hex.png "SSB_sb.hex")

4. Before flashing anymore images, in Uniflash, click on the 
   **Settings & Utilities** tab and click the **Do not erase before program load**:

![Uniflash](images/uniflash_erase.png "**Do not erase before program load")

6. Go back to the **Program** tab and select the `primary.bin` binary.
    * Make sure to click on the **Binary** checkbox, and put `0x7000` for the
      **Load Addr:** input box.

![Uniflash](images/primary_bin.png "Primary")

7. Flash the `primary.bin` file.
8. Repeat steps 6 for the `secondary.bin` file, ensuring that the **Load Addr:**
   has been updated to `0x39000`.

![Uniflash](images/secondary_bin.png "Secondary")

9. Flash the `secondary.bin` file.

10. Connect the device to a PuTTY terminal of your choice.
    * If successful you should see the following in the terminal:

![Uniflash](images/putty_terminal.png "PuTTY Terminal")

# Usage
When the **Right Button** on the CC2745 EVM is pressed, then you will see a red
LED blink on the device.

When the **Left Button** on the CC2745 EVM is pressed, then you will see a green 
LED blink on the device.