#ifndef _ASCII_H_
#define _ASCII_H_

/****** ASCII CHARACTER CONSTANTS ******/

/* line feed */
#define ASCII_LF  (0x0A)

/* carriage return */
#define ASCII_CR  (0x0D)

/* back space */
#define ASCII_BS (0x08)

/* Delete */
#define ASCII_DEL (0x7f)

/* control-Q for handshaking */
#define ASCII_XON (0x11)

/* control-S for handshaking */
#define ASCII_XOFF (0x13)

#define ASCII_SPACE (0x20)

/* Command Acknowledge */
#define ASCII_ACK (0x06)

/* Command Not Acknowledge */
#define ASCII_NAK (0x15)

#define ASCII_FF (0xFF)

/* Used to repeat the last command */
#define ASCII_ACCENT (0x60)

/* Negative sign or dash */
#define ASCII_MINUS (0x2D)

/* Tab character */
#define ASCII_TAB (0x09)

/* Escape character */
#define ASCII_ESCAPE (0x1B)

/* Exclamation Point */
#define ASCII_EXCLAMATION (0x21)

#endif
