/*
 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== Dac121C085.c ========
 */

#include <stddef.h>
#include <stdbool.h>
#include <stdint.h>

/* Driver Header files */
#include <ti/drivers/I2C.h>

/* Example/Board Header files */
#include "Board.h"
#include "DAC121C085.h"
#include "i2c.h"

bool DAC121C085_Set(uint16_t reg_value)
{
    bool i2c_return;

    i2c_txBuffer[0] = (reg_value & 0x0FFF)>>8;
    i2c_txBuffer[1] = reg_value & 0x00FF;

    i2cTransaction.slaveAddress = DAC121C085_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 2;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 0;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    return(i2c_return);
}


uint16_t DAC121C085_Get(void)
{
    uint16_t return_val;
    bool i2c_return;

    i2c_txBuffer[0] = 0;
    i2cTransaction.slaveAddress = DAC121C085_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 0;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 2;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false)
    {
      return(0);
    }
    return_val = i2c_rxBuffer[0];
    return_val = return_val << 8;
    return_val += i2c_rxBuffer[1];
    return (return_val);
}


void DAC121C085_Init(void)
{
    DAC121C085_Set(0x07FF);
}

/************************************ Done ***********************************************/
