/******************************************************************************
*
* Revision: A
* Author: BM
* Created:  22 DEC 17
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: EEPROM.c
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Header file to define EEPROM code.
*
*  EEPROM Union
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*   Copyright (c) 2010 - 2017 SRD
*   THE INFORMATION CONTAINED IN THIS file IS THE sole intellectual property OF
*   SNOWY RANGE INSTRUMENTS and protected under copyright law. ANY REPRODUCTION
*   or dissemination IN PART OR WHOLE WITHOUT THE express WRITTEN PERMISSION OF
*   SNOWY RANGE INSTRUMENTS IS PROHIBITED.
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#ifndef _EEPROM_H_
#define _EEPROM_H_

#include "stdbool.h"
#include "stddef.h"
#include "stdint.h"

#define SERIALNO_SIZE           (15)
#define SERIALNO_INIT   "900-3333\0"

/***** For Mini *****/
#define MAX_LASER_PWRS          (5)

#define LAST_PEAK_FLAG             (32767)
#define MAX_CAL_PEAKS              (19)


#define SNV_ID_APP 0x80

typedef struct {
          uint16_t        eeprom_check_sum;
          uint16_t        eeprom_initialized;  //This must ALWAYS be the first field in the structure immediately after the check sum
          uint16_t        eeprom_writes;
          uint16_t        fw_reload_flag;
          uint16_t        flash_checksum;
          char            SerialNumber[SERIALNO_SIZE];// = SERIALNO_INIT; // The serial number of this system
        //  char            SpectrographSerialNumber[SERIALNO_SIZE]; // The serial number of the optics
        //  char            CpuSerialNumber[SERIALNO_SIZE]; // The serial number of the main board
          uint16_t        shutdown_interval;
          float           LD_Temp;
          uint16_t        LD_Pwr;
          float           IntTime;
          uint16_t        Referencing;
          uint16_t        RasterDrive;
          uint16_t        RasterMonitor;
          uint16_t        ImageStart;
          uint16_t        ImageEnd;
          uint16_t        RangeStart;
          uint16_t        RangeEnd;
          double          CalP0;
          double          CalP1;
          double          CalP2;
          double          CalP3;
          double          CalP4;
          double          YCalP0;
          double          YCalP1;
          double          YCalP2;
          double          YCalP3;
          double          YCalP4;
          float           AutoIntTime;
          float           CalThreshold;
          bool            FactoryMode;
          uint16_t        Wavelength;
          float           MaxAutoIntTime;
          char            CalDate[21];
          char            YCalDate[21];
        //  uint16_t        CalPixels[MAX_CAL_PEAKS+1];
        //  float           CalPeaks[MAX_CAL_PEAKS+1];
        //  float           CalThresholds[MAX_CAL_PEAKS+1];
          float           CalIntTime;
          float           CalTolerance;
          char            LaserSN[SERIALNO_SIZE]; // The serial number of the laser
          uint16_t        laserpwrs;
          uint16_t        LaserPwrLevels[MAX_LASER_PWRS];  /* for ShutterPolarize ON, this stores the DAC values for the different laser powers. */
          uint16_t        LaserClass;
          uint16_t        ImagerCenterline;
          uint8_t         ImagerGain;
          uint8_t         ImagerGainSelect;
          uint8_t         ImagerOffset;
          uint8_t         ImagerBins;
          float           GaussSigma;
          float           GaussThreshold;
          uint8_t         LastField;  /* This must ALWAYS be the last field in the structure */
    } eeprom_t;

typedef union
{
    eeprom_t eeprom;
    uint8_t data[sizeof(eeprom_t)];
}eeprom_union;

eeprom_union eeprom_base;

#define EEPROM_LEN sizeof(eeprom_t)

extern void EEPROM_Init(void);
extern void EEPROM_Write(void);
extern void EEPROM_Reset(void);

#endif /* _EEPROM_H_ */
