/*************** SRI_GLOBAL.H    IRD   18 Feb 2002 ****************************
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *	Copyright (c) 2010 - 2013 SRD
 *   THE INFORMATION CONTAINED IN THIS file IS THE sole intellectual property OF
 *   SNOWY RANGE INSTRUMENTS and protected under copyright law. ANY REPRODUCTION
 *   or dissemination IN PART OR WHOLE WITHOUT THE express WRITTEN PERMISSION OF
 *   SNOWY RANGE INSTRUMENTS IS PROHIBITED.
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
#include <stdint.h>
#include <stdbool.h>
#include "C:/ti/simplelink_cc2640r2_sdk_1_40_00_45/kernel/tirtos/packages/ti/sysbios/posix/unistd.h"
#include <ti/sysbios/knl/Clock.h>

/******* Global constants and structure definitions *******/
#ifndef _SRI_GLOBAL_H_
#define _SRI_GLOBAL_H_
//#include "CCD.h"
//#include "eeprom.h"
#define delay_ms(i) (CPUdelay(12000*(i)))

#define SPECTRUM_SIZE   1935

/**************************** GLOBAL CONSTANTS ****************************/
#define PASS			1			/* for logical checks */
#define FAIL			0			/* for logical checks */
#define OK		        0			/* function return value for success */
#define SRI_ERROR		        -1		        /* function return value for failure */
#define SRI_DEBUG               8

#define CAL_TA          (0)
/*
 * Misc. Defines
 */
#ifdef	FALSE
#undef	FALSE
#endif
#define FALSE	(0)

#ifdef	TRUE
#undef	TRUE
#endif
#define	TRUE	(1)

#ifdef	NULL
#undef	NULL
#endif
#define NULL	(0)

#ifdef  ON
#undef  ON
#endif
#define ON      (1)

#ifdef  OFF
#undef  OFF
#endif
#define OFF     (0)

#ifdef TOGGLE
#undef TOGGLE
#endif
#define TOGGLE  (2)

#ifndef  EOF
#define EOF             (-1)
#endif

#define FREEFALL_POS    (0.15)
#define FREEFALL_NEG    (-0.15)

#define LED_POWER       (0)
#define LED_LASER       (1)


#define LASER_785               (2)
#define DISPLAY_NAME_LENGTH     (19)

/******* COMMAND PARSING AND EXECUTION *******/
#define MAX_COMMANDS 		1	/* size of the command execution queue */
#define MAX_PARM     		6	/* 10 maximum number of parameters per command */
#define MAX_SUBS 	        8	/* 18 Max number of subcommands for a command */
#define TOK_LEN			    32	/* Max length of a parsed token string */
#define MAX_LIMITS	        2	/* Number of limit pairs for param checking */

/******* COMMUNICATION BUFFER CONSTANTS *******/
#define REC_LEN			128		/* 160 length of rec strings for RS-232 */
#define MAX_REC_USB		1		/* number of strings in receive queue  USB */
#define REC_LEN_USB		128		/* 160 length of rec strings for USB */

#define TRIGGER_INTERVAL 300      /* Min time between acquisition triggers switch closures. */
#define HEARTBEAT_INTERVAL 300    /* Max Time between ACKs to prevent shutting down the laser */
#define INTERLOCK_INTERVAL 10

typedef union
{
    uint8_t c[4];
    uint16_t i;
    float f;
} value;

/**************** COMMAND PARSING AND EXECUTION STRUCTURES ******************/
/* The TOKENS enumeration is used in the SUBCOMMAND structure definition.
 The TOKENS are used for switch statements within command execution
 functions to determine the current subcommand being performed. */

typedef enum
{
    ACQUIRE,
    ALIGN,
    ALL,
    AUTO,
    AVERAGE,
    BINS,
    BPR,
    BUTTON,
    CAL,
    CHANGE,
    CLASS,
    COM,
    DATETIME,
    ERROR,
    EXTERNAL,
    FIRMWARE,
    GET,
    GAIN,
    HIGH,
    ID,
    INT,
    LASER,
    LASERPWR,
    LEVELS,
    LIMIT,
    LIST,
    LOW,
    MAX,
    MODEL,
    MSD,
    OFFSET,
    QUERY,
    RANGE,
    READ,
    REFERENCE,
    RELOAD,
    RESET,
    SAFE,
    SAMPLES,
    SAVE,
    SELECT,
    SERIAL,
    SET,
    SETUP,
    SIZE,
    STATUS,
    TEMP,
    TEST,
    THREE,
    THRESHOLD,
    TIME,
    TOK_DEBUG,
    TOK_OFF,
    TOK_ON,
    TOLERANCE,
    TWO,
    TYPE,
    UNSAFE,
    VERBOSE,
    VOLTAGE,
    WAVELENGTH
} tokens;

/* The SYNTYPE enumeration is used to determine the syntax of the command.
 It is used in the SUBCOMMAND structure definition.

 NONE	:  no parameters allowed.
 NUMBER:  first parameter must be a decimal number.
 HEX	:	first parameter must be a hexadecimal digit.
 STRING:  first parameter must be a string of printable chars.
 TOKEN	:  first parameter must be a string matching the subcommand.
 */

enum syntype
{
    NONE, NUMBER, HEX, STRING, TOKEN
};

/* The LIMITS structure holds upper and lower limits for each of the
 numeric input parameters. */

struct limits
{
    int lower; /* Minimum value allowed for this parameter. */
    int upper; /* Maximum value allowed for this parameter. */
};

/* The SUBCOMMAND structure holds parsing and execution information
 for each subcommand. One or more SUBCOMMAND structures are found
 in each COMMANDS structure. */

struct subcommand
{
    enum syntype syn_type; /* Syntax type for testing subcommands.*/
    char *string; /* ASCII string for this subcommand.Must be upper case.	*/
    tokens sub_tok; /* Token passed to execution function.	*/
    /* Token may be unused for execution.	*/
    void (*command_function)(void); /* Function executed for this command.	*/
};

/* The COMMANDS structure holds the information needed for command decoding
 and execution.  There is one COMMANDS structure for each command.
 Each COMMANDS structure contains one or more  SUBCOMMAND structures.
 An array of COMMANDS structures called COMMANDS[] is declared and
 initialized in PARSED.DEF. The total number of commands is defined by
 MAX_VALID which is declared above. */

struct commands
{
    const char *string; /* ASCII string for primary cmd.
     Must be upper case. 				*/
    const char *description; /* Description of command syntax
     and behavior. */
    const struct subcommand sub_cmd[MAX_SUBS]; /* Array of sub-commands
     for this command. 				*/
    const struct limits limits[MAX_LIMITS]; /* Limits for input parameters.
     One struct for each param.
     Currently set up for 2 params.*/
};

/* The PARSED[] command queue is made of DECODED structures. This structure
 carries all the information needed for execution of the command
 including tokens, token strings, and limits.										*/

struct decoded
{
    void (*command_function)(void); /* Function to execute */
    tokens token; /* Subcommand tokens */
    char string[MAX_PARM][TOK_LEN]; /* Input token strings. */
    struct limits limits[MAX_LIMITS]; /* Input param limits */
    char string_location; /* index to receive queue for this command */
};

union image_data
{
    uint8_t CharData[2];
    uint16_t IntData;
};

union image_referenced
{
    uint8_t CharData[2];
    uint16_t IntData;
};

/********************************** STATUS STATE ***********************************/
#define BOOT		    (0)
#define STANDBY		    (1)
#define ANALYZING	    (2)
#define INTEGRATING	    (3)
#define MATCHING        (4)
#define LOCKED		    (5)
#define ARMED		    (6)
#define REPORT		    (7)
#define CHARGING	    (8)
#define UNLOCKED        (9)
#define REFERENCING     (10)
#define ACQUIRING       (11)
#define ABORT           (12)
#define USER_LOGIN      (13)
#define THINKING        (14)
#define PWRD_OFF        (15)

/* The status structure contains operating parameters and status flags. */
struct status
{
    uint8_t     verbose; /* TRUE turns on debug statements */
    uint8_t     test_mode; /* TRUE to turn off fault handler */
    uint8_t     test_flag; /* Used by self-test to signal reception of interrupts */
    uint8_t     fault_code; /* Code for most recent fault */
    uint16_t    fault_present; /* indicate if fault is present */
    bool        faultsEnabled;
    bool        new_fault; /* True immediately after logging a fault. */
    uint32_t    off_time; /* Value of elapsed time seconds for auto-shutdown */
    uint16_t    Reload;
    uint16_t    state; /* Off/Standby/Integrating state */
    float       integration_time; /* integration time in seconds.hundredths */
    uint32_t    integration_ticks; /* integration time in 1 mS ticks */
    uint16_t    laser_pwr_state;
    uint16_t    laser_pwr_set;
    uint16_t    laser_pwr_select;
    uint32_t    laser_time;
    float       LD_Temp;
    float       laserTempSet;
    uint16_t    rasterSet;
    bool        rasterStall;
    float       rasterRPM;
    bool        rasterMonitor;
    bool        safe;
    float       ambientTemp;
    uint16_t    bins;
    uint8_t     Referencing;
    uint16_t    Power;
    uint16_t    StartPixel;
    uint16_t    EndPixel;
    uint16_t    MaxSignalPixel;
    float       maxSignalValue;
    float       PCB_ID;
    uint8_t     NoRaster;
    int16_t     acquisitionOK;
    bool        USBStatus;              // True means connected.
    int         CalibrateData;
    int         AutoInt;
    bool        overTemp;
    bool        lowBatteryShutdown;
    uint8_t     SpiCommand;
    uint8_t     Software;
    uint16_t    Interlock1;
    uint16_t    Interlock2;
    uint16_t    Interlock3;
};

extern uint16_t WAVENUMBER_START;
extern uint16_t WAVENUMBER_END;
extern struct decoded parsed[MAX_COMMANDS];
extern struct status status;

extern unsigned sleep(unsigned seconds);
extern int usleep(useconds_t useconds);

typedef union{
    uint8_t uint8_values[2];
    uint16_t uint16_values;
} spectrum_union;

extern uint16_t spectrum[];

#endif
