/*
 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *  ======== adcBufContinuousSampling.c ========
 */
#include <stdint.h>
#include <stdio.h>

/* Driver Header files */
#include <ti/drivers/ADCBuf.h>
#include <ti/drivers/UART.h>

/* Example/Board Header files */
#include "Board.h"
#include "CC2640R2_LAUNCHXL.h"
#include "ADC.h"
#include "SRI_Global.h"
#include "Laser.h"
#include "sdi_task.h"

/* ADC conversion result variables */
uint16_t adcValue6a[ADC_SAMPLE_COUNT];
uint32_t adcValue6aMicroVolt[ADC_SAMPLE_COUNT];
ADC_Handle   adc6;
uint32_t    adcAverage;

int32_t Laser_ADC_Init(void)
{
    ADC_Params   params;

    ADC_init();
    ADC_Params_init(&params);
    /* Channel 6 is the GPIO29, Pin 42, Laser Temperature. */
    adc6 = ADC_open(CC2640R2_LAUNCHXL_ADC6, &params);

    if (adc6 == NULL)
    {
        SDITask_Printf("Error initializing ADC channel 6\n");
        return (-1);
    }
    return (0);
}


float getLaserTemp(void)
{
    uint16_t     i;
    int_fast16_t res;
    uint32_t    adcAverage;
    float   LaserTemperature;

    adcAverage = 0;
    for (i = 0; i < ADC_SAMPLE_COUNT; i++)
    {
        res = ADC_convert(adc6, &adcValue6a[i]);

        if (res == ADC_STATUS_SUCCESS)
        {
            adcValue6aMicroVolt[i] = ADC_convertRawToMicroVolts(adc6, adcValue6a[i]);
            adcAverage += adcValue6aMicroVolt[i];
        }
        else
        {
            if(status.Software == OFF)
            {
                SDITask_Printf("ADC channel 6a convert failed (%d)\n", i);
            }
            break;
        }
    }
    adcAverage /= ADC_SAMPLE_COUNT;
    LaserTemperature = Laser_Temp_Calc(adcAverage);
 //   SDI_printf(display, 0, 0, "Laser Temerature: %4.2f C\n", status.LD_Temp);
    return (LaserTemperature);
}

/************************************ Done ***********************************************/
