/******************************************************************************
 * Filename:       Notification.h
 *
 * Description:    This file contains the Notification service definitions and
 *                 prototypes.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3139.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.9
 *                 Time:        Thu Jan 11 2018 13:32:51 GMT-07:00
 *

 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef _NOTIFICATION_H_
#define _NOTIFICATION_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************
 * INCLUDES
 */
#include <bcomdef.h>

/*********************************************************************
 * CONSTANTS
 */
// Service UUID
#define NOTIFICATION_SERV_UUID 0x258E

// Alert Level Characteristic defines
#define N_ALERT_LEVEL_ID                 0
#define N_ALERT_LEVEL_UUID               0x1F82
#define N_ALERT_LEVEL_LEN                20
#define N_ALERT_LEVEL_LEN_MIN            2

// Battery Level Characteristic defines
#define N_BATTERY_LEVEL_ID                 1
#define N_BATTERY_LEVEL_UUID               0x2A19
#define N_BATTERY_LEVEL_LEN                1
#define N_BATTERY_LEVEL_LEN_MIN            1

/*********************************************************************
 * TYPEDEFS
 */

// Fields in characteristic "Alert Level"
//   Field "Alert_Level" format: uint8, bits: 8
//     Enumerations for Alert_Level
//       No Alert -- 0
//       Mild Alert -- 1
//       High Alert -- 2

//   Field "Error_Code" format: uint8, bits: 8
//   Field "Alert_String" format: utf8s, bits: -1

// Fields in characteristic "Battery Level"
//   Field "Level" format: uint8, bits: 8

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * Profile Callbacks
 */

// Callback when a characteristic value has changed
typedef void (*NotificationChange_t)( uint16_t connHandle, uint16_t svcUuid, uint8_t paramID, uint8_t *pValue, uint16_t len );

typedef struct
{
  NotificationChange_t        pfnChangeCb;     // Called when characteristic value changes
  NotificationChange_t        pfnCfgChangeCb;  // Called when characteristic CCCD changes
} NotificationCBs_t;



/*********************************************************************
 * API FUNCTIONS
 */


/*
 * Notification_AddService- Initializes the Notification service by registering
 *          GATT attributes with the GATT server.
 *
 *    rspTaskId - The ICall Task Id that should receive responses for Indications.
 */
extern bStatus_t Notification_AddService( uint8_t rspTaskId );

/*
 * Notification_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
extern bStatus_t Notification_RegisterAppCBs( NotificationCBs_t *appCallbacks );

/*
 * Notification_SetParameter - Set a Notification parameter.
 *
 *    param - Profile parameter ID
 *    len   - length of data to write
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t Notification_SetParameter( uint8_t param, uint16_t len, void *value );

/*
 * Notification_GetParameter - Get a Notification parameter.
 *
 *    param - Profile parameter ID
 *    len   - pointer to a variable that contains the maximum length that can be written to *value.
              After the call, this value will contain the actual returned length.
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t Notification_GetParameter( uint8_t param, uint16_t *len, void *value );

/*********************************************************************
*********************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* _NOTIFICATION_H_ */

