/******************************************************************************
 * Filename:       Spectrum_Data.h
 *
 * Description:    This file contains the Spectrum_Data service definitions and
 *                 prototypes.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3139.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.9
 *                 Time:        Thu Jan 11 2018 13:32:51 GMT-07:00
 *

 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef _SPECTRUM_DATA_H_
#define _SPECTRUM_DATA_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************
 * INCLUDES
 */
#include <bcomdef.h>

/*********************************************************************
 * CONSTANTS
 */
// Service UUID
#define SPECTRUM_DATA_SERV_UUID 0xEEA9

// TX Data Characteristic defines
#define SD_TX_DATA_ID                 0
#define SD_TX_DATA_UUID               0xD5D9
#define SD_TX_DATA_LEN                20
#define SD_TX_DATA_LEN_MIN            1

// TX Format Characteristic defines
#define SD_TX_FORMAT_ID                 1
#define SD_TX_FORMAT_UUID               0xAB91
#define SD_TX_FORMAT_LEN                1
#define SD_TX_FORMAT_LEN_MIN            1

// TX Read Characteristic defines
#define SD_TX_READ_ID                 2
#define SD_TX_READ_UUID               0xF356
#define SD_TX_READ_LEN                1
#define SD_TX_READ_LEN_MIN            1

/*********************************************************************
 * TYPEDEFS
 */

// Fields in characteristic "TX Data"
//   Field "TX_Data" format: uint8[], bits: -1

// Fields in characteristic "TX Format"
//   Field "TX_Binary_or_ASCII" format: uint8, bits: 8

// Fields in characteristic "TX Read"
//   Field "TX_Read" format: uint8, bits: 8

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * Profile Callbacks
 */

// Callback when a characteristic value has changed
typedef void (*SpectrumDataChange_t)( uint16_t connHandle, uint16_t svcUuid, uint8_t paramID, uint8_t *pValue, uint16_t len );

typedef struct
{
  SpectrumDataChange_t        pfnChangeCb;     // Called when characteristic value changes
  SpectrumDataChange_t        pfnCfgChangeCb;  // Called when characteristic CCCD changes
} SpectrumDataCBs_t;



/*********************************************************************
 * API FUNCTIONS
 */


/*
 * SpectrumData_AddService- Initializes the SpectrumData service by registering
 *          GATT attributes with the GATT server.
 *
 *    rspTaskId - The ICall Task Id that should receive responses for Indications.
 */
extern bStatus_t SpectrumData_AddService( uint8_t rspTaskId );

/*
 * SpectrumData_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
extern bStatus_t SpectrumData_RegisterAppCBs( SpectrumDataCBs_t *appCallbacks );

/*
 * SpectrumData_SetParameter - Set a SpectrumData parameter.
 *
 *    param - Profile parameter ID
 *    len   - length of data to write
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t SpectrumData_SetParameter( uint8_t param, uint16_t len, void *value );

/*
 * SpectrumData_GetParameter - Get a SpectrumData parameter.
 *
 *    param - Profile parameter ID
 *    len   - pointer to a variable that contains the maximum length that can be written to *value.
              After the call, this value will contain the actual returned length.
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t SpectrumData_GetParameter( uint8_t param, uint16_t *len, void *value );

/*********************************************************************
*********************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* _SPECTRUM_DATA_H_ */

