% script for Jet's qualifying exam
clear all;
close all;


DoAs = [];
DoA_hats =[];


for i = 1:100

% ============= global setting ==================
% doaDeg = [20]

doaDeg = randi(90);


DoA       = doaDeg*pi/180; %DOAs of signals in rad.
P          = [1];
M          = 3;
d          = 0.2;  % attenna spacing
N          = 3000;  
noise_var  = 0.01;
RESOLUTION = 0.1;
isCorrelated = 0;
K = length(DoA);


% ============= signal ==================

X = ULASig( DoA,P ,N ,d , M , noise_var, isCorrelated  );




% ===== additional async operation, from 3*1000 to 3*(1000 out of 3000) =====
X_ant_1 = X(1,1:1000);
X_ant_2 = X(2,1001:2000);
X_ant_3 = X(3,3001:3000);
X = [X_ant_1; X_ant_2; X_ant_3];




% ============= MUSIC ==================

[DoA_hat,music_spectrum] = myMusic(X, K, RESOLUTION, d);
DoA_hat
music_spectrum = abs(music_spectrum);
% figure;
% plot(music_spectrum);


% ============= ESPRIT ==================
% Delta = 4;
% [DoA_hat] = myESPRIT(X, K, d, Delta);
% DoA_hat


DoAs = [DoAs, DoA];

if isempty(DoA_hat)  % too many nan, no peak detected
    DoA_hat = 0
end

DoA_hats = [DoA_hats, DoA_hat];

end



figure;
scatter(DoAs, DoA_hats);









