/******************************************************************************
 * Filename:       Device_Information.h
 *
 * Description:    This file contains the Device_Information service definitions and
 *                 prototypes.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3139.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.9
 *                 Time:        Thu Jan 11 2018 13:32:51 GMT-07:00
 *

 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef _DEVICE_INFORMATION_H_
#define _DEVICE_INFORMATION_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************
 * INCLUDES
 */
#include <bcomdef.h>

/*********************************************************************
 * CONSTANTS
 */
// Service UUID
#define DEVICE_INFORMATION_SERV_UUID 0x0B00

// Serial Number String Characteristic defines
#define DI_SERIAL_NUMBER_STRING_ID                 0
#define DI_SERIAL_NUMBER_STRING_UUID               0x408F
#define DI_SERIAL_NUMBER_STRING_LEN                20
#define DI_SERIAL_NUMBER_STRING_LEN_MIN            1

// Firmware Revision String Characteristic defines
#define DI_FIRMWARE_REVISION_STRING_ID                 1
#define DI_FIRMWARE_REVISION_STRING_UUID               0x433F
#define DI_FIRMWARE_REVISION_STRING_LEN                20
#define DI_FIRMWARE_REVISION_STRING_LEN_MIN            1

// RTC Characteristic defines
#define DI_RTC_ID                 2
#define DI_RTC_UUID               0xC384
#define DI_RTC_LEN                6
#define DI_RTC_LEN_MIN            6

// WaveLength Characteristic defines
#define DI_WAVELENGTH_ID                 3
#define DI_WAVELENGTH_UUID               0x423F
#define DI_WAVELENGTH_LEN                1
#define DI_WAVELENGTH_LEN_MIN            1

// Range Characteristic defines
#define DI_RANGE_ID                 4
#define DI_RANGE_UUID               0xD900
#define DI_RANGE_LEN                1
#define DI_RANGE_LEN_MIN            1

// Laser Power Levels Characteristic defines
#define DI_LASER_POWER_LEVELS_ID                 5
#define DI_LASER_POWER_LEVELS_UUID               0x30BB
#define DI_LASER_POWER_LEVELS_LEN                1
#define DI_LASER_POWER_LEVELS_LEN_MIN            1

// XCalCoefficients Characteristic defines
#define DI_XCALCOEFFICIENTS_ID                 6
#define DI_XCALCOEFFICIENTS_UUID               0xD13B
#define DI_XCALCOEFFICIENTS_LEN                20
#define DI_XCALCOEFFICIENTS_LEN_MIN            20

/*********************************************************************
 * TYPEDEFS
 */

// Fields in characteristic "Serial Number String"
//   Field "Serial_Number" format: utf8s, bits: -1

// Fields in characteristic "Firmware Revision String"
//   Field "Firmware_Revision" format: utf8s, bits: -1

// Fields in characteristic "RTC"
//   Field "YYYYMMDDHHmm" format: uint32, bits: 32
//     Bits in field "YYYYMMDDHHmm"
//       Minutes -- Offset: 0, Size = 6
//       Hours -- Offset: 6, Size = 5
//       Day -- Offset: 11, Size = 5
//         Enumerations for Day
//           INVALID -- 0

//       Month -- Offset: 16, Size = 4
//         Enumerations for Month
//           INVALID -- 0

//       Year -- Offset: 20, Size = 12
//   Field "ADDITIONAL_INFO" format: uint16, bits: 16
//     Bits in field "ADDITIONAL_INFO"
//       Day_Of_Week -- Offset: 0, Size = 3
//         Enumerations for Day_Of_Week
//           INVALID -- 0
//           Sunday -- 1
//           Monday -- 2
//           Tuesday -- 3
//           Wednesday -- 4
//           Thursday -- 5
//           Friday -- 6
//           Saturday -- 7

//       Seconds_since_start_of_minute -- Offset: 3, Size = 6

// Fields in characteristic "WaveLength"
//   Field "WaveLength" format: uint8, bits: 8

// Fields in characteristic "Range"
//   Field "Range" format: uint8, bits: 8

// Fields in characteristic "Laser Power Levels"
//   Field "Level" format: uint8, bits: 8

// Fields in characteristic "XCalCoefficients"
//   Field "P0" format: float32, bits: 32
//   Field "P1" format: float32, bits: 32
//   Field "P2" format: float32, bits: 32
//   Field "P3" format: float32, bits: 32
//   Field "P4" format: float32, bits: 32

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * Profile Callbacks
 */

// Callback when a characteristic value has changed
typedef void (*DeviceInformationChange_t)( uint16_t connHandle, uint16_t svcUuid, uint8_t paramID, uint8_t *pValue, uint16_t len );

typedef struct
{
  DeviceInformationChange_t        pfnChangeCb;     // Called when characteristic value changes
  DeviceInformationChange_t        pfnCfgChangeCb;  // Called when characteristic CCCD changes
} DeviceInformationCBs_t;



/*********************************************************************
 * API FUNCTIONS
 */


/*
 * DeviceInformation_AddService- Initializes the DeviceInformation service by registering
 *          GATT attributes with the GATT server.
 *
 *    rspTaskId - The ICall Task Id that should receive responses for Indications.
 */
extern bStatus_t DeviceInformation_AddService( uint8_t rspTaskId );

/*
 * DeviceInformation_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
extern bStatus_t DeviceInformation_RegisterAppCBs( DeviceInformationCBs_t *appCallbacks );

/*
 * DeviceInformation_SetParameter - Set a DeviceInformation parameter.
 *
 *    param - Profile parameter ID
 *    len   - length of data to write
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t DeviceInformation_SetParameter( uint8_t param, uint16_t len, void *value );

/*
 * DeviceInformation_GetParameter - Get a DeviceInformation parameter.
 *
 *    param - Profile parameter ID
 *    len   - pointer to a variable that contains the maximum length that can be written to *value.
              After the call, this value will contain the actual returned length.
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t DeviceInformation_GetParameter( uint8_t param, uint16_t *len, void *value );

/*********************************************************************
*********************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* _DEVICE_INFORMATION_H_ */

