/******************************************************************************
*
* Revision: A
* Author: BM
* Created:  22 DEC 17
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: EEPROM.c
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Source file to define EEPROM code.
*
*  EEPROM Union
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*   Copyright (c) 2010 - 2017 SRD
*   THE INFORMATION CONTAINED IN THIS file IS THE sole intellectual property OF
*   SNOWY RANGE INSTRUMENTS and protected under copyright law. ANY REPRODUCTION
*   or dissemination IN PART OR WHOLE WITHOUT THE express WRITTEN PERMISSION OF
*   SNOWY RANGE INSTRUMENTS IS PROHIBITED.
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#include "EEPROM.h"
#include "SRI_Global.h"
#include <string.h>
#include "osal.h"
#include "osal_tasks.h"
#include "osal_snv.h"
#include "sdi_task.h"
#include "IMX290.h"

/**************************************************************************
*                      SNRI EEPROM global access                          *
***************************************************************************/
uint8_t nvResult = SUCCESS;
//static uint8_t buffer[EEPROM_LEN];

/*********************************************************************
*
*  Function Name    : EEPROM_Init
*  Description      : Initializes EEPROM union, loads from NVM
*
*  Arguments        : void
*  Return Value     : none
*
**********************************************************************/

void EEPROM_Init(void)
{
      EEPROM_Reset();
      //memcpy(buffer, eeprom_base.data, EEPROM_LEN);
      nvResult = osal_snv_read(SNV_ID_APP, EEPROM_LEN, eeprom_base.data);
      if(nvResult != SUCCESS)
      {
          //Write first time to initialize SNV ID
          //EEPROM_Reset();
          osal_snv_write(SNV_ID_APP, EEPROM_LEN, eeprom_base.data);
          SDITask_Printf("\nNVS Initialized");
          //memcpy(eeprom_base.data, buffer, EEPROM_LEN);
      }
      status.integration_time = eeprom_base.eeprom.IntTime;
      status.verbose = OFF;
      status.Software = OFF;
}

/*********************************************************************
*
*  Function Name    : EEPROM_Write
*  Description      : Writes entire eeprom structure to NVM
*
*  Arguments        : void
*  Return Value     : none
*
**********************************************************************/
void EEPROM_Write(void)
{
    eeprom_base.eeprom.eeprom_writes++;
    //memcpy(buffer, eeprom_base.data, EEPROM_LEN);
    nvResult = osal_snv_write(SNV_ID_APP, EEPROM_LEN, eeprom_base.data);
    if(nvResult != SUCCESS)
    {
      if(status.verbose == ON)
      {
          SDITask_Printf("\nError writing NVS.");
      }

    //Display_print1(dispHandle, 0, 0, "SNV WRITE FAIL: %d", status);
    }
    else
    {
      if(status.verbose == ON)
      {
          SDITask_Printf("\nNVS successfully written.");
      }

    //Display_print1(dispHandle, 0, 0, "Num of Resets: %d", eeprom_base.data[0]);
    }
}

/*********************************************************************
*
*  Function Name    : EEPROM_Reset
*  Description      : Resets to defaults
*
*  Arguments        : void
*  Return Value     : none
*
**********************************************************************/
void EEPROM_Reset(void)
{
    eeprom_base.eeprom.eeprom_initialized = 0xFA50;
    eeprom_base.eeprom.eeprom_writes = 0;
    eeprom_base.eeprom.fw_reload_flag = 0;
    eeprom_base.eeprom.flash_checksum = 0;
//    eeprom_base.eeprom.SerialNumber[SERIALNO_SIZE] = "900-3333\0";
//  eeprom.SpectrographSerialNumber[SERIALNO_SIZE] = ;
//  eeprom.CpuSerialNumber[SERIALNO_SIZE] = ;
    eeprom_base.eeprom.shutdown_interval = 5;
    eeprom_base.eeprom.LD_Temp = 29.5;
    eeprom_base.eeprom.LD_Pwr = 77;
    eeprom_base.eeprom.IntTime = 0.2;
    eeprom_base.eeprom.Referencing = TRUE;
    eeprom_base.eeprom.RasterDrive = 52;
    eeprom_base.eeprom.RasterMonitor = OFF;
    eeprom_base.eeprom.ImageStart = 0;
    eeprom_base.eeprom.ImageEnd = 1935;
    eeprom_base.eeprom.RangeStart = 400;
    eeprom_base.eeprom.RangeEnd = 2300;
    eeprom_base.eeprom.CalP0 = 71.130537081505494;
    eeprom_base.eeprom.CalP1 = 1.902596799159339;
    eeprom_base.eeprom.CalP2 = -0.000442518134599;
    eeprom_base.eeprom.CalP3 = 0.000000104739702;
    eeprom_base.eeprom.CalP4 = -0.000000000022680;
    eeprom_base.eeprom.YCalP0 = 0.012345678901234;
    eeprom_base.eeprom.YCalP1 = 0.001234567890123;
    eeprom_base.eeprom.YCalP2 = 0.000123456789012;
    eeprom_base.eeprom.YCalP3 = 0.000012345678901;
    eeprom_base.eeprom.YCalP4 = 0.000001234567890;
    eeprom_base.eeprom.AutoIntTime = 0.1;
    eeprom_base.eeprom.CalThreshold = 0.1;
    eeprom_base.eeprom.FactoryMode = TRUE;
    eeprom_base.eeprom.Wavelength = 785;
//  eeprom.BPR[20] = ;
    eeprom_base.eeprom.MaxAutoIntTime = 10.0;
//  eeprom.CalDate[21] = ;
//  eeprom.CalPixels[MAX_CAL_PEAKS+1] = ;
//  eeprom.CalPeaks[MAX_CAL_PEAKS+1] = ;
//  eeprom.CalThresholds[MAX_CAL_PEAKS+1] = ;
    eeprom_base.eeprom.CalIntTime = 2.0;
    eeprom_base.eeprom.CalTolerance = 1.8;
//  eeprom.LaserSN[SERIALNO_SIZE] = ;
    eeprom_base.eeprom.laserpwrs = 5;
    eeprom_base.eeprom.LaserPwrLevels[0] = 150;
    eeprom_base.eeprom.LaserPwrLevels[1] = 300;
    eeprom_base.eeprom.LaserPwrLevels[2] = 450;
    eeprom_base.eeprom.LaserPwrLevels[3] = 600;
    eeprom_base.eeprom.LaserPwrLevels[4] = 750;
    eeprom_base.eeprom.LaserClass = 3;
    eeprom_base.eeprom.ImagerCenterline = 540;
    eeprom_base.eeprom.ImagerGain = IMX290_GAIN_INIT;
    eeprom_base.eeprom.ImagerGainSelect = 0;
    eeprom_base.eeprom.ImagerOffset = IMX290_BLK_LEVEL_INIT;
    eeprom_base.eeprom.sendSvcChngdOnNextBoot = FALSE;
}
