/******************************************************************************
*
* file       IMX290_spi.h
*
* API for SPI access of the Imager data via FPGA
*
* Target Device: MiniRaman
*
*******************************************************************************/

#ifndef IMX290_SPI_H
#define IMX290_SPI_H

#include <stdlib.h>
#include <stdbool.h>

#define IMX290_SPI_BASE         SSI1_BASE
#define CPU_FREQ                48000000ul
#define SPI_MAX_TRANSFER_SIZE   400
/**
 * Initialize SPI interface
 *
 * @return none
 */
extern bool IMX290SpiOpen(void);

/**
 * Close SPI interface
 *
 * @return True when successful.
 */
extern void IMX290SpiClose(void);

/**
 * Clear data from SPI interface
 *
 * @return none
 */
extern void IMX290SpiFlush(void);

/**
 * Read from an SPI device
 *
 * @return True when successful.
 */
extern bool IMX290SpiRead( uint16_t *buf, size_t length);

extern SPI_Handle      imx290_spi;
extern SPI_Transaction imx290_spiTransaction;

#endif /* IMX290_SPI_H */

/************************************** DONE *********************************************/
