/*
 * Copyright (c) 2015-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LASER_H_
#define _LASER_H_

#define LASER_PWM_PERIOD    (5000)
#define MAX_LASER_TEMP  (70.0)

/* Initialize Laser PWM to zero percent. */
int32_t Laser_Init(void);

/* Set laser drive level in 0.1% increments (0 - 1000) */
int32_t Laser_Control(uint16_t drive_level);

/* Takes the Thermistor voltage in microvolts and returns the temperature in Celcius. */
float Laser_Temp_Calc(uint32_t ThermistorMicrovolts);

/* Set or read the laser temperature. */
extern void ldtemp_cmd(void);

/* Uses the desired temperature to calculate the correct DAC setting
   and then sets the DAC for Laser temperature control. All based
   on the 1v5 reference from the TE driver IC (MaAX8521). */
void ldcooling_set(float);

/* Turn the laser on or off, set levels, set drive, query. */
extern void laserpwr_cmd(void);

/* Returns 1 if interlocks and raster stall are safe. */
extern int check_interlocks(void);

extern int32_t Laser_Control(uint16_t drive_level);

extern unsigned int LD_CoolingCalc(float new_temp);

#endif

/************************************ Done ***********************************************/

