/******************************************************************************
*
* Revision: A
* Author: MAW
* Created:  25 Mar 2014
* Updated: 5 Jan 2017 for MiniRaman
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: PCA9536.c
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Source file for the PCA9536 I2C 4 bit I/O
*
*       For the Sierra 2.0 the PCA9536 is used for LED control and 
*       external laser enables.
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*	Copyright (c) 2014, SnRI
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#include "SRI_Global.h"
#include "Parse.h"
#include <stdio.h>
#include <string.h>
#include "Board.h"
#include "math.h"
#include "PCA9536.h"
#include "i2c.h"

 /******************************************************************************
*
* Revision: A
* Author: Mark Watson
* Created: March 2011
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  TITLE: PCA9536_Set
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* PURPOSE:	Writes a register pattern to IIC to Parallel I/O
*
* INPUTS:	device address, register number and desired data.
*
* OUTPUTS:	None.
*
* CALLS:	none.
*
* CALLED BY:	.
* 	
* DETAILS:  
*           
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*	Copywrite (c) 2014 SnRI 
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
bool PCA9536_Set(unsigned char reg_address, unsigned char reg_value)
{
  bool i2c_return;

  i2c_txBuffer[0] = reg_address;
  i2c_txBuffer[1] = reg_value;

  i2cTransaction.slaveAddress = PCA9536_ADDR;
  i2cTransaction.writeBuf = i2c_txBuffer;
  i2cTransaction.writeCount = 2;
  i2cTransaction.readBuf = i2c_rxBuffer;
  i2cTransaction.readCount = 0;
  i2c_return = I2C_transfer(i2c, &i2cTransaction);
  return(i2c_return);
}


unsigned char PCA9536_Get(unsigned char reg_address)
{
    uint8_t return_val;
    bool i2c_return;

    i2c_txBuffer[0] = reg_address;

    i2cTransaction.slaveAddress = PCA9536_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 1;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 1;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false)
    {
      return(0);
    }
    return_val = i2c_rxBuffer[0];
    return (return_val);
}


void PCA9536_Init(void)
{
  /* Set all outputs to zero and enable all pins as outputs. */
  PCA9536_Set(PCA9536_OUTPUT, 0x00);
  PCA9536_Set(PCA9536_CONFIG, 0x00);
}

/*
#define EN_2V9              (1)
#define EN_1V2              (2)
#define EN_1V8              (4)
#define EN_LASER_COOLING    (8)
*/

void Control_2v9_En(unsigned char Control)
{
  unsigned char port_mirror;
  
  port_mirror = PCA9536_Get(PCA9536_OUTPUT);
  if (Control == ON)
  {
    port_mirror |= EN_2V9;
  }
  else
  {
    port_mirror &= ~EN_2V9;
  }
  PCA9536_Set(PCA9536_OUTPUT, port_mirror);
}   /* end Control_2v9_En() */


void Control_1v2_En(unsigned char Control)
{
  unsigned char port_mirror;
  
  port_mirror = PCA9536_Get(PCA9536_OUTPUT);
  if (Control == ON)
  {
    port_mirror |= EN_1V2;
  }
  else  
  {
    port_mirror &= ~EN_1V2;
  }
  PCA9536_Set(PCA9536_OUTPUT, port_mirror);
}   /* end Control_1v2_En() */


void Control_1v8_En(unsigned char Control)
{
  unsigned char port_mirror;
  
  port_mirror = PCA9536_Get(PCA9536_OUTPUT);
  if (Control == ON)
  {
    port_mirror |= EN_1V8;
  }
  else  
  {
    port_mirror &= ~EN_1V8;
  }
  PCA9536_Set(PCA9536_OUTPUT, port_mirror);
}   /* end Control_1v8_En() */


void Control_LaserCooling_En(unsigned char Control)
{
  unsigned char port_mirror;
  
  port_mirror = PCA9536_Get(PCA9536_OUTPUT);
  if (Control == ON)
  {
    port_mirror |= EN_LASER_COOLING;
  }
  else
  {
    port_mirror &= ~EN_LASER_COOLING;
  }
  PCA9536_Set(PCA9536_OUTPUT, port_mirror);
}   /* end Control_LaserCooling_En() */

/******************************************************************************
* Done.
*/
