/******************************************************************************
*
* Revision: A
* Author: MAW
* Created:  25 March 2014
* Updated: 5 Jan 2018 for MiniRaman
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: PCA9536.h
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Header file to define functions for the I2C 4 bit I/O.
*
*       For the Sierra 2.0, the PCA9536 is used to control the LEDs and the 
*       external laser enables.
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*	Copyright (c) 2014, SnRI
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#ifndef _PCA9636_H_
#define _PCA9536_H_

/* This is a 4 bit device, so only the lower nibble is used in any register. */
#define PCA9536_INPUT           (0x00)
#define PCA9536_OUTPUT          (0x01)
#define PCA9536_POLARITY        (0x02)          /* Set bits to one to invert the read value. */
#define PCA9536_CONFIG          (0x03)          /* Set bits to a zero to configure as an output. */

/* Note: Address pins not available on the package are pulled to a one */
#define PCA9536_ADDR  (0x41)  /* Fixed address for the part type. */

#define EN_2V9              (1)
#define EN_1V2              (2)
#define EN_1V8              (4)
#define EN_LASER_COOLING    (8)

extern bool PCA9536_Set(unsigned char reg_address, unsigned char reg_value);
extern unsigned char PCA9536_Get(unsigned char reg_address);
/* Init sets all I/O to outputs and sets the low. */
extern void PCA9536_Init(void);

/* For the following functions, the Control can take on two values: ON and OFF. */
extern void Control_2v9_En(unsigned char Control);
extern void Control_1v2_En(unsigned char Control);
extern void Control_1v8_En(unsigned char Control);
extern void Control_LaserCooling_En(unsigned char Control);

#endif

/******************************************************************************
* Done.
*/
