/************ PARSE.DEF   SOS		NOV 2009 *************/
#ifndef _PARSE_H_
#define _PARSE_H_

#include <stdint.h>
#include "SRI_Global.h"

#define NUMBER_OF_COMMANDS 29



/*************** LOCALLY DEFINED GLOBAL VARIABLES ************************/
/* This structure holds the decoded commands for subsequent execution. */
/* See GLOBAL.H for templates. */

extern struct decoded parsed[MAX_COMMANDS];

extern int parsed_head;
extern int parsed_tail;           /* Index to next command to execute */


/* The commands array is the look-up table for command parsing and checking. */
/* Refer to GLOBAL.H for structure templates.										*/

extern const struct commands commands[];



extern void process_incoming_character(uint8_t rec_byte_usb);

extern uint8_t check_command(void);		/* See if there is an input to parse. */

#endif

