/******************************************************************************
*
* Revision: A
* Author: MAW
* Created:  10 Jan 2018
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: Si7055.h
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Header file to define functions for the Si7055 I2C temperature sensor.
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*   Copyright (c) 2018, Metrohm Raman
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#include "SRI_Global.h"
#include "Parse.h"
#include <stdio.h>
#include <string.h>
#include "Board.h"
#include "math.h"
#include "Si7055.h"
#include "i2c.h"

 /******************************************************************************
*
* Revision: A
* Author: Mark Watson
* Created: March 2011
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  TITLE: Si7055_Set_User_Reg
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* PURPOSE:	Writes a register pattern to IIC to the User Register
*
* INPUTS:	desired data.
*
* OUTPUTS:	None.
*
* CALLS:	none.
*
* CALLED BY:	.
* 	
* DETAILS:  
*           
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*	Copywrite (c) 2018 Metrohm Raman
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
bool Si7055_Set_User_Reg(unsigned char reg_value)
{
  bool i2c_return;

  i2c_txBuffer[0] = SI7055_WRITE_USER_REG;
  i2c_txBuffer[1] = reg_value;

  i2cTransaction.slaveAddress = SI7055_ADDR;
  i2cTransaction.writeBuf = i2c_txBuffer;
  i2cTransaction.writeCount = 2;
  i2cTransaction.readBuf = i2c_rxBuffer;
  i2cTransaction.readCount = 0;
  i2c_return = I2C_transfer(i2c, &i2cTransaction);
  return(i2c_return);
}


unsigned char Si7055_Get_User_Reg(void)
{
    uint8_t return_val;
    bool i2c_return;

    i2c_txBuffer[0] = SI7055_READ_USER_REG;

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 1;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 0;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false)
    {
      return(0);
    }
    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 0;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 1;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false)
    {
      return(0);
    }
    return_val = i2c_rxBuffer[0];
    return (return_val);
}

bool Si7055_Reset(void)
{
    bool i2c_return;

    i2c_txBuffer[0] = SI7055_RESET;

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 1;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 0;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    return(i2c_return);
}

/* Here is the scheme: The temperature measurement will be started
 * during one cycle of the periodic user clock and then the result
 * will be read during the next cycle.
 */

bool Si7055_Start_Temperature_No_Hold(void)
{
    bool i2c_return;

    i2c_txBuffer[0] = SI7055_MEASURE_NO_HOLD;

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 1;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 0;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    return(i2c_return);
}


float Si7055_Read_Temperature(void)
{
    float cTemp;
    bool i2c_return;

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 0;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 2;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false) return (-99.0);
    // Convert the data using equation from datasheet.
    cTemp = (i2c_rxBuffer[0] * 256 + i2c_rxBuffer[1]);
    cTemp = (((cTemp * 175.72) / 65536) - 46.85);
    return (cTemp);
}


uint8_t Si7055_Get_FW_Rev(void)
{
    bool i2c_return;

    i2c_txBuffer[0] = SI7055_READ_FIRMWARE_REV >> 8;
    i2c_txBuffer[1] = SI7055_READ_FIRMWARE_REV & 0x00FF;

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 2;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 0;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false) return(0);

    i2cTransaction.slaveAddress = SI7055_ADDR;
    i2cTransaction.writeBuf = i2c_txBuffer;
    i2cTransaction.writeCount = 0;
    i2cTransaction.readBuf = i2c_rxBuffer;
    i2cTransaction.readCount = 1;
    i2c_return = I2C_transfer(i2c, &i2cTransaction);
    if (i2c_return == false) return(0);
    return (i2c_rxBuffer[0]);
}

/******************************************************************************
* Done.
*/
