/******************************************************************************
*
* Revision: A
* Author: MAW
* Created:  10 Jan 2018
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*  FILE: Si7055.h
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* DESCRIPTION: Header file to define functions for the Si7055 I2C temperature sensor.
*
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*	Copyright (c) 2018, Metrohm Raman
* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#ifndef _SI7055_H_
#define _SI7055_H_


/* Note: Address pins not available on the package are pulled to a one */
#define SI7055_ADDR  (0x40)  /* Fixed address for this part type. */

#define SI7055_MEASURE_W_HOLD      0xE3
#define SI7055_MEASURE_NO_HOLD     0xF3
#define SI7055_RESET               0xFE
#define SI7055_WRITE_USER_REG      0xE6
#define SI7055_READ_USER_REG       0xE7
#define SI7055_READ_ID_1ST_BYTE    0xFA0F
#define SI7055_READ_ID_2ND_BYTE    0xFCC9
#define SI7055_READ_FIRMWARE_REV   0x84B8

extern bool Si7055_Set_User_Reg(unsigned char reg_value);
extern unsigned char Si7055_Get_User_Reg(void);
extern bool Si7055_Reset(void);
extern bool Si7055_Start_Temperature_No_Hold(void);
extern float Si7055_Read_Temperature(void);
extern uint8_t Si7055_Get_FW_Rev(void);

#endif

/******************************************************************************
* Done.
*/
