/*
 * Copyright (C) 2008, 2009, 2010  Kaspar Schleiser <kaspar@schleiser.de>
 * Copyright (C) 2013 INRIA
 * Copyright (C) 2013 Ludwig Knüpfer <ludwig.knuepfer@fu-berlin.de>
 *
 * This file is subject to the terms and conditions of the GNU Lesser
 * General Public License v2.1. See the file LICENSE in the top level
 * directory for more details.
 */

/**
 * @ingroup     examples
 * @{
 *
 * @file
 * @brief       Default application that shows a lot of functionality of RIOT
 *
 * @author      Kaspar Schleiser <kaspar@schleiser.de>
 * @author      Oliver Hahm <oliver.hahm@inria.fr>
 * @author      Ludwig Knüpfer <ludwig.knuepfer@fu-berlin.de>
 *
 * @}
 */

#include <stdio.h>
#include <string.h>

#include "thread.h"
#include "shell.h"
#include "shell_commands.h"



#include "led.h"
// #include "posix_io.h"  // error
// #include "board_uart0.h" // error
// #include "tty_uart.h"
#include "board.h"
#include "xtimer.h"



#if FEATURE_PERIPH_RTC
#include "periph/rtc.h"
#endif

#ifdef MODULE_NETIF
#include "net/gnrc/pktdump.h"
#include "net/gnrc.h"
#endif


int hello_world(int argc, char **argv) {
    /* Suppress compiler errors */
    (void)argc;  // number of parameters. 
    (void)argv;  // value of each parameters . Ex: argv[0] argv[1]
    // printf("hello world!\n");
    puts("hello world!\n");
    return 0;
}

int text(int argc, char **argv) {
    /* Suppress compiler errors */
    (void)argc;
    (void)argv;
    // printf("hello world!\n");
    puts("text_here\n");
    return 0;
}

// void led_0(int argc, char **argv) {
//     int status;

//     if(argc == 2){
//         // status = argv[1];
//         status = ustrtoul(argv[1], 0, 10);

//         if (status)
//             LED0_ON;
//         else LED0_OFF;
//     }
// }

// void led_1(int argc, char **argv) {

//     if(argc == 2){
//         // int status = argv[1];
//         status = ustrtoul(argv[1], 0, 10); 
//         if (status)
//             LED1_ON;
//         else LED1_OFF;
//     }
// }

int led_0_on(int argc, char **argv) { //red

    (void)argc;
    (void)argv;

    LED0_ON;
    printf("LED_RED_ON\n");

    return 0;
}

int led_0_off(int argc, char **argv) { //red

    (void)argc;
    (void)argv;
    
    LED0_OFF;
    printf("LED_RED_OFF\n");

    return 0;
}

int led_1_on(int argc, char **argv) { //green

    (void)argc;
    (void)argv;

    LED1_ON;
    printf("LED_GREEN_ON\n");

    return 0;
}

int led_1_off(int argc, char **argv) { //green

    (void)argc;
    (void)argv;
    
    LED1_OFF;
    printf("LED_GREEN_OFF\n");

    return 0;
}

const shell_command_t shell_commands[] = {
    {"hello", "prints hello world", hello_world},
    {"cnn", "prints text here", text},
    // {"L1", "control led 1 on/off", led_1},
    // {"L0", "control led 0 on/off", led_0},
    {"L0_on", "turn led 0 on", led_0_on},
    {"L0_off", "turn led 0 off", led_0_off},
    {"L1_on", "turn led 1 on", led_1_on},
    {"L1_off", "turn led 1 off", led_1_off},
    { NULL, NULL, NULL }
};

#define MSEC (1000)
#define SEC (1000 * MSEC)

int main(void)
{
    printf("test uart 1\n");

#ifdef FEATURE_PERIPH_RTC
    rtc_init();
#endif

#ifdef MODULE_NETIF
    gnrc_netreg_entry_t dump = GNRC_NETREG_ENTRY_INIT_PID(GNRC_NETREG_DEMUX_CTX_ALL,
                                                          gnrc_pktdump_pid);
    gnrc_netreg_register(GNRC_NETTYPE_UNDEF, &dump);
#endif

    LED_RED_ON;
    LED_GREEN_ON;

    (void) puts("Welcome to RIOT!");

    printf("test uart 2\n");


    char line_buf[SHELL_DEFAULT_BUFSIZE];
    // shell_run(NULL, line_buf, SHELL_DEFAULT_BUFSIZE);
    

    shell_run(shell_commands, line_buf, SHELL_DEFAULT_BUFSIZE);
    
    // shell_init(&shell, shell_commands, UART0_BUFSIZE, uart0_readc, uart0_putc);
    // shell_run(&shell);
    return 0;
}
