/*
 *  ======== ti_ble_config.h ========
 *  Configured BLE module definitions
 *
 *  DO NOT EDIT - This file is generated by the SysConfig tool.
 */

#ifndef TI_BLE_CONFIG_H
#define TI_BLE_CONFIG_H

#include <bcomdef.h>
#include <gapgattserver.h>
#include <gap_advertiser.h>
#include <gapbondmgr.h>

// The GAP profile role
extern uint8_t profileRole;
// GAP GATT Service (GGS) parameters
extern uint8_t attDeviceName[GAP_DEVICE_NAME_LEN];
extern void init_profiles(void);

// Default Tx Power value in dBm
#define DEFAULT_TX_POWER               0

// User configurable extra PPM for peripheral RX window widening
// This only applies if SRC_CLK_IS_LFOSC is set to 1
#define USER_CFG_LFOSC_EXTRA_PPM        1500

// Specifies whether LFOSC (RCOSC) was configured in CCFG module by the user
#define SRC_CLK_IS_LFOSC        		0

//Random Address
extern uint8_t pRandomAddress[B_ADDR_LEN];

// Address mode of the local device
// Note: When using the DEFAULT_ADDRESS_MODE as ADDRMODE_RANDOM or 
// ADDRMODE_RP_WITH_RANDOM_ID, GAP_DeviceInit() should be called with 
// it's last parameter set to a static random address
#define DEFAULT_ADDRESS_MODE                  ADDRMODE_PUBLIC

// How often to read current RPA (in ms)
#define READ_RPA_PERIOD                       3000

// Maximum number of BLE HCI PDUs. If the maximum number connections (above)
// is set to 0 then this number should also be set to 0.
#define MAX_NUM_PDU                   		    5

// Maximum size in bytes of the BLE HCI PDU. Valid range: 27 to 255
// The maximum ATT_MTU is MAX_PDU_SIZE - 4.
#define MAX_PDU_SIZE                  		    255

/*********************************************************************
 * Bond Manager Configuration
 */

#define GAP_CHAR_CFG_MAX                      4

extern gapBondParams_t gapBondParams;

extern uint8_t pairMode;
extern uint8_t mitm;
extern uint8_t ioCap;
extern uint8_t bonding;
extern uint8_t secureConnection;
extern uint8_t authenPairingOnly;
extern uint8_t autoSyncAL;
extern uint8_t eccReGenPolicy;
extern uint8_t KeySize;
extern uint8_t removeLRUBond;
extern uint8_t bondFailAction;
extern uint8_t KeyDistList;
extern uint8_t eccDebugKeys;
extern uint8_t allowDebugKeys;
extern uint8_t eraseBondWhileInConn;
extern uint8_t sameIrkAction;

extern void setBondManagerParameters();



// Initiator PHY Parameters

// Default PHY for initiating
#define DEFAULT_INIT_PHY                      INIT_PHY_1M

// Default scan interval (in 0.625ms)
#define INIT_PHYPARAM_SCAN_INT    		      16

// Default scan window (in 0.625ms)
#define INIT_PHYPARAM_SCAN_WIN    		      16

// Default minimum connection interval (in 1.25ms)
#define INIT_PHYPARAM_MIN_CONN_INT    		  80

// Default maximum connection interval (in 1.25ms)
#define INIT_PHYPARAM_MAX_CONN_INT    		  80

// Default connection latency
#define INIT_PHYPARAM_CONN_LAT    		      0

// Default Supervision Timeout (in 10ms)
#define INIT_PHYPARAM_SUP_TO   		          2000

// Default RSSI polling period in ms
#define DEFAULT_RSSI_PERIOD                   3000

// Minimum connection interval (units of 1.25ms) if automatic parameter update
// request is enabled
#define DEFAULT_UPDATE_MIN_CONN_INTERVAL      400

// Maximum connection interval (units of 1.25ms) if automatic parameter update
// request is enabled
#define DEFAULT_UPDATE_MAX_CONN_INTERVAL      800

// Peripheral latency to use if automatic parameter update request is enabled
#define DEFAULT_UPDATE_PERIPHERAL_LATENCY     0

// Supervision timeout value (units of 10ms) if automatic parameter update
// request is enabled
#define DEFAULT_UPDATE_CONN_TIMEOUT           600



//Primary PHY Parameters

// Default PHY for scanning
#define DEFAULT_SCAN_PHY                        SCAN_PRIM_PHY_1M

//Default Scan type (Active/Passive)
#define DEFAULT_SCAN_TYPE                       SCAN_TYPE_ACTIVE

// Scan period
#define DEFAULT_SCAN_PERIOD                     0

// Default scan interval (in 625 us ticks)
#define DEFAULT_SCAN_INTERVAL                   800

// Default scan window   (in 625 us ticks)
#define DEFAULT_SCAN_WINDOW                     800

// Default scan duration in 10 ms
#define DEFAULT_SCAN_DURATION                   100

// Advertising report fields to keep in the list
#define ADV_RPT_FIELDS                          (SCAN_ADVRPT_FLD_ADDRESS | SCAN_ADVRPT_FLD_ADDRTYPE | SCAN_ADVRPT_FLD_DATALEN | SCAN_ADVRPT_FLD_EVENTTYPE | SCAN_ADVRPT_FLD_PRIMPHY | SCAN_ADVRPT_FLD_RSSI | SCAN_ADVRPT_FLD_TXPOWER)

// Scanner Filter Policy
#define SCANNER_FILTER_POLICY                   SCAN_FLT_POLICY_ALL

// Scanner Filter PDU Type
#define SCANNER_FILTER_PDU_TYPE                  (SCAN_FLT_PDU_COMPLETE_ONLY | SCAN_FLT_PDU_CONNECTABLE_ONLY)

// Scanner Filter Minimum RSSI
#define SCANNER_FILTER_MIN_RSSI                  SCAN_FLT_RSSI_ALL

// Scanner Discoverable Mode Filter
#define SCANNER_FILTER_DISC_MODE                 SCAN_FLT_DISC_DISABLE

// Scanner Duplicate Filter
#define SCANNER_DUPLICATE_FILTER                 SCAN_FLT_DUP_DISABLE

// TRUE to filter discovery results on desired service UUID
#define DEFAULT_DEV_DISC_BY_SVC_UUID            true

// Maximum number of advertising reports
#define APP_MAX_NUM_OF_ADV_REPORTS              20



// Pass parameter updates to the app for it to decide.
#define DEFAULT_PARAM_UPDATE_REQ_DECISION       GAP_UPDATE_REQ_PASS_TO_APP

// Pass parameter updates to the app for it to decide.
#define DEFAULT_SEND_PARAM_UPDATE_REQ

// Delay (in ms) after connection establishment before sending a parameter update requst
#define SEND_PARAM_UPDATE_DELAY                 6000

// Minimum connection interval (units of 1.25ms) if automatic parameter update
// request is enabled
#define DEFAULT_DESIRED_MIN_CONN_INTERVAL      400

// Maximum connection interval (units of 1.25ms) if automatic parameter update
// request is enabled
#define DEFAULT_DESIRED_MAX_CONN_INTERVAL      800

// Peripheral latency to use if automatic parameter update request is enabled
#define DEFAULT_DESIRED_PERIPHERAL_LATENCY     0

// Supervision timeout value (units of 10ms) if automatic parameter update
// request is enabled
#define DEFAULT_DESIRED_CONN_TIMEOUT           600



// Advertisement Set Number 1
extern GapAdv_params_t advParams1;
extern uint8_t advData1[3];
extern uint8_t scanResData1[22];


// SDAA parameters

#endif /* TI_BLE_CONFIG_H */
