/**************************************************************************************************
*  Filename:       Calibration_AFE4404.h
*  Revised:        $Date: 2015-08-10 15:59:23 -0700 (Mon, 10 Aug 2015) $
*  Revision:       $Revision: 38222 $
*
*  Description:    This file contains the definitions for calibrating the \
*                  TI AFE4404.
*
*  Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/
#ifndef _CALIBRATION_AFE4404_H_
#define _CALIBRATION_AFE4404_H_

typedef enum 
{
	s10K=1, 
	s25K=2, 
	s50K=3, 
	s100K=4, 
	s250K=5, 
	s500K=6, 
	s1M=7, 
	s2M=8
} RF_VALUES;		//enumeration type for RF

typedef struct SystemParams //structure for storing the current system parameters
{
  RF_VALUES RF;												// current Rf
  int ILED;													// current ILED
  int ILED2;
  int AMB_DAC_LED;							// current Ambient cancellation value in LED phase
  int AMB_DAC_AMB;		// current Ambient cancellation value in AMB phase
  int AMB_DAC_SIGN_LED;// sign of Ambient cancellation in LED phase (1 means subtract, -1 means add)
  int AMB_DAC_SIGN_AMB;// sign of Ambient cancellation in AMB phase (1 means subtract, -1 means add)
  int Cf;
} SYSTEM_PARAMS;

typedef struct SignalParams //structure for storing the current signal parameters
{
  long DC;								// current DC value in LED/AMB phase
} SIGNAL_PARAMS;

typedef struct flags    			// structure for storing the flag conditions
{
  int GainCalib;						// =0 if Gain Calibration is successful
  int AmbCancel;					// =0 if Ambient cancellation is successful
  int DISABLE_HIGH_CHECK;	// internal flag for disabling high check for gain calibration
  int DISABLE_LOW_CHECK;// internal flag for disabling low check for gain calibration
} FLAGS;

typedef struct calib_enable			// structure for storing calibration mode
{
  int AMB;												// 1 means enabled
  int GAIN;
  int PERIODIC;
} CALIB_ENABLE;

typedef struct amb_function_ret  							// stucture for storing multiple returns for correctamb() function
{
  int AMB_DAC_VAL_LED;						
  int AMB_DAC_VAL_AMB;
  long Meas_DC_Est;
} AMB_FUNCTION_RET;

typedef enum 
{
  sInit,
  sWaitTime1,
  sWaitforData1,
  sGainadjust,
  sCalibrate,
  sWaitTime2a,
  sWaitforData2a,
  sWaitTime2b,
  sWaitforData2b,
  sWaitTime2,
  sWaitforData2,
  sWaitforData3,
  sWaitTime3,
  sWaitforData4,
  sCheck1,
  sCheck2,
  sCheck,
  sOver
} CALIBRATION_STATES; //enumeration type for calibration states

typedef enum 
{
  sAmbientDAC,
  sGain,
  sPeriodic,
  sFinish,
  sInitialize,
  sWaitforfinger,
  sIdle
} CALIBRATION_MODES; //enumeration type for calibration modes

typedef enum 
{
  sFreeze_periodic, 
  sAmbient_periodic, 
  sGain_periodic
} PERIODIC_MODES; //enumeration type for periodic calibration modes

typedef enum 
{ 
  sOffsetDACInit, 
  sOffsetDACWaitTime, 
  sOffsetDACWaitforData, 
  sOffsetDACCodeEst, 
  sOffsetDACOver
} OFFSETDAC_CALIB_STATES; //enumeration type for calibration states


static long Meas_DC_OFFSET_DAC_code[16];
static long Meas_DC_OFFSET_DAC_code_step[16];

/*******************************************************************************/
/*	        Function Declarations									       	   */
/*******************************************************************************/
void initCalibrationRoutine(void);
void AmbientCancellation(long,long);
void CalibrateAFE4404(long,long,long);
void GainCalibration(long,long);
void PeriodicCalibration(long,long,long);
void gaincalibrate(long, unsigned int, long, unsigned int);
AMB_FUNCTION_RET correctamb(long Meas_DC,RF_VALUES Rf_current, char ambient);
void setRfValue(RF_VALUES rfvalue);
void setCfValue(int);
unsigned char OFFSET_DAC_Code_Est(long AMBVALUE);

#endif
