/**************************************************************************************************
*  Filename:       hrm.h
*  Revised:        $Date: 2015-08-10 17:22:05 -0800 (Mon, 10 Aug 2015) $
*  Revision:       $Revision: 42106 $
*
*  Description:    This file contains the Activity Monitor sample application
*                  for use with the CC2650 Bluetooth Low Energy Protocol Stack.
*
*  Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*********************************************************************
 * INCLUDES
 */
#ifndef _HRM_H_
#define _HRM_H_

void initStatHRM (void);
void statHRMAlgo (unsigned long ppgData);

void updateWindow(unsigned long *peakWindow, unsigned long Y, unsigned char n);
unsigned char chooseRate(unsigned char *rate);
void updateHeartRate(unsigned char *rate, unsigned int freq, unsigned int last);
unsigned long findMax(unsigned long *X);
unsigned long findMin(unsigned long *X);

#endif /*_HRM_H_*/
