/*
 * Copyright (c) 2015-2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/** ============================================================================
 *  @file       CC2640R2_TOY.h
 *
 *  @brief      CC2640R2 LaunchPad Board Specific header file.
 *
 *  The CC2640R2_TOY header file should be included in an application as
 *  follows:
 *  @code
 *  #include "CC2640R2_TOY.h"
 *  @endcode
 *
 *  ============================================================================
 */
#ifndef __CC2640R2_TOY_BOARD_H__
#define __CC2640R2_TOY_BOARD_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes */
#include <ti/drivers/PIN.h>
#include <ti/devices/cc26x0r2/driverlib/ioc.h>

/* Externs */
extern const PIN_Config BoardGpioInitTable[];

/* Defines */
#ifndef CC2640R2_TOY
  #define CC2640R2_TOY
#endif /* CC2640R2_TOY */

/** ============================================================================
 *  Symbol by generic Board.c to include the correct kit specific Board.c
 *  ==========================================================================*/
#define CC2650EM_7ID

/* Mapping of pins to board signals using general board aliases
 *      <board signal alias>                  <pin mapping>
 */

/* SPI Board */
#define CC2640R2_TOY_SPI0_MISO             IOID_0
#define CC2640R2_TOY_SPI0_MOSI             IOID_1
#define CC2640R2_TOY_SPI0_CLK              IOID_2
#define CC2640R2_TOY_SPI0_CSN              IOID_3

#define CC2640R2_TOY_BLE_SPI_READY           IOID_24

/*!
 *  @brief  Initialize the general board specific settings
 *
 *  This function initializes the general board specific settings.
 */
void CC2640R2_TOY_initGeneral(void);

/*!
 *  @def    CC2640R2_TOY_CryptoName
 *  @brief  Enum of Crypto names
 */
typedef enum CC2640R2_TOY_CryptoName {
    CC2640R2_TOY_CRYPTO0 = 0,

    CC2640R2_TOY_CRYPTOCOUNT
} CC2640R2_TOY_CryptoName;

/*!
 *  @def    CC2640R2_TOY_GPIOName
 *  @brief  Enum of GPIO names
 */
typedef enum CC2640R2_TOY_GPIOName {
    CC2640R2_TOY_GPIOCOUNT
} CC2640R2_TOY_GPIOName;

/*!
 *  @def    CC2640R2_TOY_GPTimerName
 *  @brief  Enum of GPTimer parts
 */
typedef enum CC2640R2_TOY_GPTimerName {
    CC2640R2_TOY_GPTIMERPARTSCOUNT
} CC2640R2_TOY_GPTimerName;

/*!
 *  @def    CC2640R2_TOY_GPTimers
 *  @brief  Enum of GPTimers
 */
typedef enum CC2640R2_TOY_GPTimers {
    CC2640R2_TOY_GPTIMERCOUNT
} CC2640R2_TOY_GPTimers;

/*!
 *  @def    CC2640R2_TOY_SPIName
 *  @brief  Enum of SPI names
 */
typedef enum CC2640R2_TOY_SPIName {
    CC2640R2_TOY_SPI0 = 0,

    CC2640R2_TOY_SPICOUNT
} CC2640R2_TOY_SPIName;

/*!
 *  @def    CC2640R2_TOY_UDMAName
 *  @brief  Enum of DMA buffers
 */
typedef enum CC2640R2_TOY_UDMAName {
    CC2640R2_TOY_UDMA0 = 0,

    CC2640R2_TOY_UDMACOUNT
} CC2640R2_TOY_UDMAName;

/*!
 *  @def    CC2640R2_TOY_WatchdogName
 *  @brief  Enum of Watchdogs
 */
typedef enum CC2640R2_TOY_WatchdogName {
    CC2640R2_TOY_WATCHDOG0 = 0,

    CC2640R2_TOY_WATCHDOGCOUNT
} CC2640R2_TOY_WatchdogName;

/*!
 *  @def    CC2640R2_TOY_TRNGName
 *  @brief  Enum of TRNG names on the board
 */
typedef enum CC2640R2_TOY_TRNGName {
    CC2640R2_TOY_TRNG0 = 0,
    CC2640R2_TOY_TRNGCOUNT
} CC2640R2_TOY_TRNGName;

#ifdef __cplusplus
}
#endif

#endif /* __CC2640R2_TOY_BOARD_H__ */
