/* 
 *  Copyright 2009
 *  Texas Instruments Incorporated
 *
 *  All rights reserved.  Property of Texas Instruments Incorporated
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 * 
 */
/*
 *  File        : ti_load_app.h
 *  Date        : 13th May 2009
 *  Author      : Sandeep S Prabhu
 */

#ifndef __TI_LOAD_APP_
#define __TI_LOAD_APP_

#include <linux/ioctl.h>

#define MINIDSP_DEVICE_NODE     "/dev/minidsp"
#define MINIDSP_PAGE_SIZE       128
#define CODEC_REG_IGNORE        0
#define CODEC_REG_ALLOW         1

#define TILOAD_DATA_SIZE_16		1
#define TILOAD_DATA_SIZE_24		2
#define TILOAD_DATA_SIZE_32		3

#define ADC3101_IOC_MAGIC	0xE0
#define ADC3101_IOMAGICNUM_GET	_IOR(ADC3101_IOC_MAGIC, 1, int)
#define ADC3101_IOMAGICNUM_SET	_IOW(ADC3101_IOC_MAGIC, 2, int)

#endif	/*__TI_LOAD_APP_*/
