//CONTROL LOCATIONS
typedef struct {
            u8 control_page;           //coefficient page location
            u8 control_base;           //coefficient base address within page
            u8 control_mute_flag;      //non-zero means muting required
            u8 control_string_index;   //string table index
} control; 


static control MUX_controls[] = {
};

static string MUX_control_names[] = {
};

static control VOLUME_controls[] = {
{4,12,0,0}
};

static string VOLUME_control_names[] = {
"Volume_1"
};

//INSTRUCTIONS & COEFFICIENTS
typedef struct {
    u8 reg_off;
    u8 reg_val;
} reg_value;

static string REG_Section_names[] = {
    "miniDSP_A_reg_values",
    "miniDSP_D_reg_values",
};

reg_value REG_Section_program[] = {
    {  0,0x00},
    {  1,0x01},
    { 61,0x00},
    {  4,0x03},
    {  5,0x91},
    {  6,0x08},
    { 18,0x84},
    { 19,0x84},
    { 27,0x00},
    { 20,0x80},
    { 83,0x00},
    { 84,0x00},
    { 22,0x04},
    { 21,0xBC},
    {255,0x00},
    {  0,0x01},
    { 52,0xFC},
    { 55,0xFC},
    { 59,0x00},
    { 60,0x00},
    {  0,0x00},
    { 81,0xC2},
    { 82,0x00},
    {  0,0x01},
    {  1,0x08},
    {  2,0x00},
    {  0,0x00},
    { 82,0x00},
    { 83,0x00},
    { 86,0x00},
    { 87,0xDF},
    { 88,0x00},
    { 89,0x68},
    { 90,0xA8},
    { 91,0x06},
    { 92,0x00},
    { 84,0x00},
    { 94,0x00},
    { 95,0xDF},
    { 96,0x00},
    { 97,0x68},
    { 98,0xA8},
    { 99,0x06},
    {100,0x00},
};

reg_value miniDSP_A_reg_values[] = {
    {  0,0x04},
    {  2,0x00},
    {  3,0xB7},
    {  4,0x7E},
    {  5,0x90},
    {  6,0x7F},
    {  7,0xFF},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x02},
    { 13,0x8C},
    { 14,0xFF},
    { 15,0x9E},
    { 16,0xF7},
    { 17,0x10},
    { 18,0x26},
    { 19,0xF0},
    { 20,0x02},
    { 21,0x61},
    { 22,0x40},
    { 23,0x02},
    { 24,0xFF},
    { 25,0xFC},
    { 26,0xFF},
    { 27,0xFD},
    { 28,0xFF},
    { 29,0xE5},
    { 30,0xFF},
    { 31,0xA7},
    { 32,0xFF},
    { 33,0xC7},
    { 34,0xFF},
    { 35,0xCE},
    { 36,0xFF},
    { 37,0xFE},
    { 38,0xFE},
    { 39,0xF7},
    { 40,0xFF},
    { 41,0x46},
    { 42,0xFF},
    { 43,0x22},
    { 44,0xFF},
    { 45,0x0F},
    { 46,0xFA},
    { 47,0x8C},
    { 48,0xF5},
    { 49,0x08},
    { 50,0xFD},
    { 51,0x92},
    { 52,0xF3},
    { 53,0xA3},
    { 54,0x03},
    { 55,0xB3},
    { 56,0x00},
    { 57,0x33},
    { 58,0x00},
    { 59,0x71},
    { 60,0x40},
    { 61,0x60},
    { 62,0x00},
    { 63,0xE2},
    { 64,0x00},
    { 65,0xC6},
    { 66,0x00},
    { 67,0x87},
    { 68,0x00},
    { 69,0x0F},
    { 70,0x00},
    { 71,0x0A},
    { 72,0x00},
    { 73,0x02},
    { 74,0x01},
    { 75,0x81},
    { 76,0x18},
    { 77,0x89},
    { 78,0x07},
    { 79,0xFB},
    { 80,0x03},
    { 81,0xBE},
    { 82,0x00},
    { 83,0x49},
    { 84,0xFF},
    { 85,0xF2},
    { 86,0xF9},
    { 87,0xBA},
    { 88,0xF9},
    { 89,0x00},
    { 90,0xFF},
    { 91,0x68},
    { 92,0xFE},
    { 93,0x2C},
    { 94,0xEB},
    { 95,0x8D},
    { 96,0x03},
    { 97,0x83},
    { 98,0x01},
    { 99,0xC3},
    {100,0x00},
    {101,0xD3},
    {102,0x00},
    {103,0x33},
    {104,0x00},
    {105,0x02},
    {106,0x32},
    {107,0x08},
    {108,0x0A},
    {109,0xFA},
    {110,0x54},
    {111,0x7B},
    {112,0xFF},
    {113,0x6B},
    {114,0xFF},
    {115,0x03},
    {116,0xFC},
    {117,0xC6},
    {118,0xF5},
    {119,0x54},
    {120,0xF9},
    {121,0x64},
    {122,0x39},
    {123,0x80},
    {124,0x03},
    {125,0x1C},
    {126,0x03},
    {127,0x2F},
    {  0,0x05},
    {  2,0x00},
    {  3,0x67},
    {  4,0x0F},
    {  5,0x73},
    {  6,0x2C},
    {  7,0x2B},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x40},
    { 15,0x00},
    { 16,0xC0},
    { 17,0x00},
    { 18,0xFF},
    { 19,0xFF},
    { 20,0x80},
    { 21,0x00},
    { 22,0x40},
    { 23,0x00},
    { 24,0x7F},
    { 25,0xFF},
    { 26,0x00},
    { 27,0x00},
    {  0,0x20},
    {  2,0x03},
    {  3,0x4B},
    {  4,0xFF},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x02},
    { 12,0x00},
    { 13,0xA6},
    { 14,0x03},
    { 15,0x06},
    { 16,0xA6},
    { 17,0x08},
    { 18,0x48},
    { 19,0xA5},
    { 20,0x03},
    { 21,0xC8},
    { 22,0xA3},
    { 23,0x02},
    { 24,0x01},
    { 25,0xA4},
    { 26,0x08},
    { 27,0x84},
    { 28,0x05},
    { 29,0x02},
    { 30,0x37},
    { 31,0xA1},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x08},
    { 42,0x80},
    { 43,0x1E},
    { 44,0x03},
    { 45,0x47},
    { 46,0xA1},
    { 47,0x08},
    { 48,0x46},
    { 49,0xA6},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x08},
    { 54,0x8C},
    { 55,0x0D},
    { 56,0x08},
    { 57,0x84},
    { 58,0x19},
    { 59,0x03},
    { 60,0xC7},
    { 61,0xA3},
    { 62,0x08},
    { 63,0x48},
    { 64,0xA4},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x02},
    { 69,0x01},
    { 70,0xA2},
    { 71,0x08},
    { 72,0x88},
    { 73,0x19},
    { 74,0x03},
    { 75,0x46},
    { 76,0xA6},
    { 77,0x03},
    { 78,0x47},
    { 79,0xA4},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x02},
    { 84,0x00},
    { 85,0xA0},
    { 86,0x02},
    { 87,0x01},
    { 88,0xA2},
    { 89,0x04},
    { 90,0x44},
    { 91,0x02},
    { 92,0x08},
    { 93,0x80},
    { 94,0x19},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x21},
    {  2,0x03},
    {  3,0xC7},
    {  4,0xA3},
    {  5,0x08},
    {  6,0x48},
    {  7,0xA4},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x02},
    { 12,0x01},
    { 13,0xA2},
    { 14,0x08},
    { 15,0x86},
    { 16,0x0C},
    { 17,0x03},
    { 18,0x46},
    { 19,0xA6},
    { 20,0x03},
    { 21,0x47},
    { 22,0xA4},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x02},
    { 27,0x00},
    { 28,0xA0},
    { 29,0x02},
    { 30,0x01},
    { 31,0xA2},
    { 32,0x04},
    { 33,0x44},
    { 34,0x02},
    { 35,0x08},
    { 36,0x80},
    { 37,0x0C},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x03},
    { 42,0x47},
    { 43,0xA3},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x02},
    { 51,0x01},
    { 52,0xA2},
    { 53,0x04},
    { 54,0x44},
    { 55,0x02},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x03},
    { 63,0x47},
    { 64,0xA1},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x02},
    { 72,0x01},
    { 73,0xA0},
    { 74,0x03},
    { 75,0x44},
    { 76,0x4E},
    { 77,0x03},
    { 78,0x44},
    { 79,0x9D},
    { 80,0x03},
    { 81,0x44},
    { 82,0xA6},
    { 83,0x02},
    { 84,0x01},
    { 85,0x9E},
    { 86,0x02},
    { 87,0x01},
    { 88,0x9F},
    { 89,0x04},
    { 90,0x45},
    { 91,0x3F},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x22},
    {  2,0x00},
    {  3,0x00},
    {  4,0x00},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x03},
    {  9,0x0B},
    { 10,0x0C},
    { 11,0x03},
    { 12,0x8A},
    { 13,0x07},
    { 14,0x03},
    { 15,0x8A},
    { 16,0x03},
    { 17,0x03},
    { 18,0x89},
    { 19,0x08},
    { 20,0x03},
    { 21,0x89},
    { 22,0x02},
    { 23,0x03},
    { 24,0x88},
    { 25,0x01},
    { 26,0x03},
    { 27,0x88},
    { 28,0x09},
    { 29,0x03},
    { 30,0x87},
    { 31,0x0A},
    { 32,0x0F},
    { 33,0x07},
    { 34,0x00},
    { 35,0x03},
    { 36,0x07},
    { 37,0x59},
    { 38,0x0F},
    { 39,0x87},
    { 40,0x4F},
    { 41,0x02},
    { 42,0x00},
    { 43,0x2A},
    { 44,0x03},
    { 45,0x88},
    { 46,0x50},
    { 47,0x03},
    { 48,0x88},
    { 49,0x58},
    { 50,0x03},
    { 51,0x89},
    { 52,0x57},
    { 53,0x03},
    { 54,0x89},
    { 55,0x51},
    { 56,0x03},
    { 57,0x8A},
    { 58,0x56},
    { 59,0x03},
    { 60,0x8A},
    { 61,0x52},
    { 62,0x03},
    { 63,0x8B},
    { 64,0x5B},
    { 65,0x03},
    { 66,0x0C},
    { 67,0x29},
    { 68,0x03},
    { 69,0x8C},
    { 70,0x2A},
    { 71,0x02},
    { 72,0x00},
    { 73,0x79},
    { 74,0x03},
    { 75,0x8D},
    { 76,0x0E},
    { 77,0x03},
    { 78,0x8D},
    { 79,0x45},
    { 80,0x03},
    { 81,0x8E},
    { 82,0x2C},
    { 83,0x03},
    { 84,0x8E},
    { 85,0x27},
    { 86,0x03},
    { 87,0x8F},
    { 88,0x2E},
    { 89,0x03},
    { 90,0x8F},
    { 91,0x25},
    { 92,0x03},
    { 93,0x90},
    { 94,0x34},
    { 95,0x03},
    { 96,0x90},
    { 97,0x1F},
    {  0,0x23},
    {  2,0x03},
    {  3,0x91},
    {  4,0x11},
    {  5,0x03},
    {  6,0x91},
    {  7,0x42},
    {  8,0x03},
    {  9,0x92},
    { 10,0x0F},
    { 11,0x03},
    { 12,0x92},
    { 13,0x44},
    { 14,0x03},
    { 15,0x93},
    { 16,0x35},
    { 17,0x03},
    { 18,0x93},
    { 19,0x1E},
    { 20,0x03},
    { 21,0x94},
    { 22,0x30},
    { 23,0x03},
    { 24,0x94},
    { 25,0x23},
    { 26,0x03},
    { 27,0x95},
    { 28,0x13},
    { 29,0x03},
    { 30,0x95},
    { 31,0x40},
    { 32,0x03},
    { 33,0x96},
    { 34,0x32},
    { 35,0x03},
    { 36,0x96},
    { 37,0x21},
    { 38,0x03},
    { 39,0x97},
    { 40,0x17},
    { 41,0x03},
    { 42,0x97},
    { 43,0x3C},
    { 44,0x03},
    { 45,0x98},
    { 46,0x37},
    { 47,0x03},
    { 48,0x98},
    { 49,0x1C},
    { 50,0x03},
    { 51,0x99},
    { 52,0x15},
    { 53,0x03},
    { 54,0x99},
    { 55,0x3E},
    { 56,0x03},
    { 57,0x9A},
    { 58,0x19},
    { 59,0x03},
    { 60,0x9A},
    { 61,0x3A},
    { 62,0x03},
    { 63,0x9B},
    { 64,0x16},
    { 65,0x03},
    { 66,0x9B},
    { 67,0x3D},
    { 68,0x03},
    { 69,0x9C},
    { 70,0x2D},
    { 71,0x03},
    { 72,0x9C},
    { 73,0x26},
    { 74,0x03},
    { 75,0x9D},
    { 76,0x12},
    { 77,0x03},
    { 78,0x9D},
    { 79,0x41},
    { 80,0x03},
    { 81,0x9E},
    { 82,0x38},
    { 83,0x03},
    { 84,0x9E},
    { 85,0x1B},
    { 86,0x03},
    { 87,0x9F},
    { 88,0x31},
    { 89,0x03},
    { 90,0x9F},
    { 91,0x22},
    { 92,0x03},
    { 93,0xA0},
    { 94,0x33},
    { 95,0x03},
    { 96,0xA0},
    { 97,0x20},
    {  0,0x24},
    {  2,0x03},
    {  3,0xA1},
    {  4,0x2F},
    {  5,0x03},
    {  6,0xA1},
    {  7,0x24},
    {  8,0x03},
    {  9,0xA2},
    { 10,0x10},
    { 11,0x03},
    { 12,0xA2},
    { 13,0x43},
    { 14,0x03},
    { 15,0xA3},
    { 16,0x2B},
    { 17,0x03},
    { 18,0xA3},
    { 19,0x28},
    { 20,0x03},
    { 21,0xA4},
    { 22,0x0D},
    { 23,0x03},
    { 24,0xA4},
    { 25,0x46},
    { 26,0x03},
    { 27,0xA5},
    { 28,0x14},
    { 29,0x03},
    { 30,0xA5},
    { 31,0x3F},
    { 32,0x03},
    { 33,0xA6},
    { 34,0x1A},
    { 35,0x03},
    { 36,0xA6},
    { 37,0x39},
    { 38,0x03},
    { 39,0xA7},
    { 40,0x18},
    { 41,0x03},
    { 42,0xA7},
    { 43,0x3B},
    { 44,0x03},
    { 45,0xA8},
    { 46,0x36},
    { 47,0x03},
    { 48,0xA8},
    { 49,0x1D},
    { 50,0x00},
    { 51,0x80},
    { 52,0x0A},
    { 53,0x05},
    { 54,0x01},
    { 55,0x00},
    { 56,0x00},
    { 57,0x81},
    { 58,0x59},
    { 59,0x05},
    { 60,0x00},
    { 61,0x00},
    { 62,0x03},
    { 63,0x04},
    { 64,0x47},
    { 65,0x03},
    { 66,0x85},
    { 67,0x49},
    { 68,0x09},
    { 69,0x83},
    { 70,0x46},
    { 71,0x06},
    { 72,0x01},
    { 73,0x49},
    { 74,0x03},
    { 75,0x82},
    { 76,0x4B},
    { 77,0x02},
    { 78,0x80},
    { 79,0x48},
    { 80,0x06},
    { 81,0x81},
    { 82,0x48},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x01},
    { 87,0x82},
    { 88,0x00},
    { 89,0x02},
    { 90,0x80},
    { 91,0x4A},
    { 92,0x03},
    { 93,0x4C},
    { 94,0x9E},
    { 95,0x03},
    { 96,0x4C},
    { 97,0x9F},
    {  0,0x25},
    {  2,0x01},
    {  3,0x80},
    {  4,0x02},
    {  5,0x01},
    {  6,0x81},
    {  7,0x02},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x26},
    {  2,0x00},
    {  3,0x00},
    {  4,0x00},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x27},
    {  2,0x00},
    {  3,0x00},
    {  4,0x00},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x03},
    { 72,0x0B},
    { 73,0x54},
    { 74,0x03},
    { 75,0x8A},
    { 76,0x4F},
    { 77,0x03},
    { 78,0x8A},
    { 79,0x58},
    { 80,0x03},
    { 81,0x89},
    { 82,0x50},
    { 83,0x03},
    { 84,0x89},
    { 85,0x57},
    { 86,0x03},
    { 87,0x88},
    { 88,0x56},
    { 89,0x03},
    { 90,0x88},
    { 91,0x51},
    { 92,0x03},
    { 93,0x87},
    { 94,0x52},
    { 95,0x0F},
    { 96,0x87},
    { 97,0x55},
    {  0,0x28},
    {  2,0x03},
    {  3,0x07},
    {  4,0x03},
    {  5,0x0F},
    {  6,0x07},
    {  7,0x06},
    {  8,0x02},
    {  9,0x00},
    { 10,0x5B},
    { 11,0x03},
    { 12,0x88},
    { 13,0x07},
    { 14,0x03},
    { 15,0x88},
    { 16,0x02},
    { 17,0x03},
    { 18,0x89},
    { 19,0x01},
    { 20,0x03},
    { 21,0x89},
    { 22,0x08},
    { 23,0x03},
    { 24,0x8A},
    { 25,0x00},
    { 26,0x03},
    { 27,0x8A},
    { 28,0x09},
    { 29,0x03},
    { 30,0x8B},
    { 31,0x05},
    { 32,0x03},
    { 33,0x0C},
    { 34,0x78},
    { 35,0x03},
    { 36,0x8C},
    { 37,0x79},
    { 38,0x02},
    { 39,0x00},
    { 40,0x0C},
    { 41,0x03},
    { 42,0x8D},
    { 43,0x5D},
    { 44,0x03},
    { 45,0x8D},
    { 46,0x94},
    { 47,0x03},
    { 48,0x8E},
    { 49,0x7B},
    { 50,0x03},
    { 51,0x8E},
    { 52,0x76},
    { 53,0x03},
    { 54,0x8F},
    { 55,0x7D},
    { 56,0x03},
    { 57,0x8F},
    { 58,0x74},
    { 59,0x03},
    { 60,0x90},
    { 61,0x83},
    { 62,0x03},
    { 63,0x90},
    { 64,0x6E},
    { 65,0x03},
    { 66,0x91},
    { 67,0x60},
    { 68,0x03},
    { 69,0x91},
    { 70,0x91},
    { 71,0x03},
    { 72,0x92},
    { 73,0x5E},
    { 74,0x03},
    { 75,0x92},
    { 76,0x93},
    { 77,0x03},
    { 78,0x93},
    { 79,0x84},
    { 80,0x03},
    { 81,0x93},
    { 82,0x6D},
    { 83,0x03},
    { 84,0x94},
    { 85,0x7F},
    { 86,0x03},
    { 87,0x94},
    { 88,0x72},
    { 89,0x03},
    { 90,0x95},
    { 91,0x62},
    { 92,0x03},
    { 93,0x95},
    { 94,0x8F},
    { 95,0x03},
    { 96,0x96},
    { 97,0x81},
    {  0,0x29},
    {  2,0x03},
    {  3,0x96},
    {  4,0x70},
    {  5,0x03},
    {  6,0x97},
    {  7,0x66},
    {  8,0x03},
    {  9,0x97},
    { 10,0x8B},
    { 11,0x03},
    { 12,0x98},
    { 13,0x86},
    { 14,0x03},
    { 15,0x98},
    { 16,0x6B},
    { 17,0x03},
    { 18,0x99},
    { 19,0x64},
    { 20,0x03},
    { 21,0x99},
    { 22,0x8D},
    { 23,0x03},
    { 24,0x9A},
    { 25,0x68},
    { 26,0x03},
    { 27,0x9A},
    { 28,0x89},
    { 29,0x03},
    { 30,0x9B},
    { 31,0x65},
    { 32,0x03},
    { 33,0x9B},
    { 34,0x8C},
    { 35,0x03},
    { 36,0x9C},
    { 37,0x7C},
    { 38,0x03},
    { 39,0x9C},
    { 40,0x75},
    { 41,0x03},
    { 42,0x9D},
    { 43,0x61},
    { 44,0x03},
    { 45,0x9D},
    { 46,0x90},
    { 47,0x03},
    { 48,0x9E},
    { 49,0x87},
    { 50,0x03},
    { 51,0x9E},
    { 52,0x6A},
    { 53,0x03},
    { 54,0x9F},
    { 55,0x80},
    { 56,0x03},
    { 57,0x9F},
    { 58,0x71},
    { 59,0x03},
    { 60,0xA0},
    { 61,0x82},
    { 62,0x03},
    { 63,0xA0},
    { 64,0x6F},
    { 65,0x03},
    { 66,0xA1},
    { 67,0x7E},
    { 68,0x03},
    { 69,0xA1},
    { 70,0x73},
    { 71,0x03},
    { 72,0xA2},
    { 73,0x5F},
    { 74,0x03},
    { 75,0xA2},
    { 76,0x92},
    { 77,0x03},
    { 78,0xA3},
    { 79,0x7A},
    { 80,0x03},
    { 81,0xA3},
    { 82,0x77},
    { 83,0x03},
    { 84,0xA4},
    { 85,0x5C},
    { 86,0x03},
    { 87,0xA4},
    { 88,0x95},
    { 89,0x03},
    { 90,0xA5},
    { 91,0x63},
    { 92,0x03},
    { 93,0xA5},
    { 94,0x8E},
    { 95,0x03},
    { 96,0xA6},
    { 97,0x69},
    {  0,0x2A},
    {  2,0x03},
    {  3,0xA6},
    {  4,0x88},
    {  5,0x03},
    {  6,0xA7},
    {  7,0x67},
    {  8,0x03},
    {  9,0xA7},
    { 10,0x8A},
    { 11,0x03},
    { 12,0xA8},
    { 13,0x85},
    { 14,0x03},
    { 15,0xA8},
    { 16,0x6C},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x05},
    { 21,0x03},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x05},
    { 27,0x02},
    { 28,0x00},
    { 29,0x03},
    { 30,0x04},
    { 31,0x96},
    { 32,0x03},
    { 33,0x85},
    { 34,0x98},
    { 35,0x09},
    { 36,0x83},
    { 37,0x95},
    { 38,0x06},
    { 39,0x01},
    { 40,0x98},
    { 41,0x03},
    { 42,0x82},
    { 43,0x9A},
    { 44,0x02},
    { 45,0x80},
    { 46,0x97},
    { 47,0x06},
    { 48,0x81},
    { 49,0x97},
    { 50,0x05},
    { 51,0x85},
    { 52,0x97},
    { 53,0x01},
    { 54,0x83},
    { 55,0x00},
    { 56,0x02},
    { 57,0x80},
    { 58,0x99},
    { 59,0x05},
    { 60,0x84},
    { 61,0x48},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x02},
    { 66,0x3F},
    { 67,0x9C},
    { 68,0x02},
    { 69,0x3F},
    { 70,0x4D},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x2B},
    {  2,0x00},
    {  3,0x00},
    {  4,0x00},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x00},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    {  0,0x2C},
    {  2,0x00},
    {  3,0x00},
    {  4,0x00},
    {  5,0x00},
    {  6,0x00},
    {  7,0x00},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x80},
    { 55,0x03},
    { 56,0x00},
    { 57,0x81},
    { 58,0x52},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x08},
    { 63,0x81},
    { 64,0xFF},
};

reg_value miniDSP_D_reg_values[] = {
};
