#!/bin/bash
#sw reset # To remove nousound problem
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00 # Initialize to Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x7f 0x00 # Initialize to Book 0
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x01 # Initialize the device through software reset
usleep 1000   # 1 millisecond delay

#power config # To remove nousound problem 
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01 #Select Page 1
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x00 # Power configuration register
/usr/sbin/i2cset -f -y 3 0x18 0x7a 0x01 # Reference Powerup Delay Register - 0x00

#clock initialize 
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00 # Select Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x04 0x33 # To remove nousound problem # Clock input multiplexer; set DAC_CLKIN = PLL_CLK
/usr/sbin/i2cset -f -y 3 0x18 0x05 0x00 # To remove nousound problem # Multiplexer; set PLL_CLKIN=MCLK1
/usr/sbin/i2cset -f -y 3 0x18 0x06 0x91 # To remove nousound problem # P and R value (PLL clock parameters)
/usr/sbin/i2cset -f -y 3 0x18 0x07 0x06 # To remove nousound problem # J value (PLL clock parameter)
/usr/sbin/i2cset -f -y 3 0x18 0x08 0x14 # To remove nousound problem # PLL D Values (MSB)
/usr/sbin/i2cset -f -y 3 0x18 0x09 0xbb # To remove nousound problem # PLL D Values (LSB)
/usr/sbin/i2cset -f -y 3 0x18 0x0a 0x02 # To remove nousound problem # PLL_CLKIN Divider
/usr/sbin/i2cset -f -y 3 0x18 0x0b 0x86 # To remove nousound problem # NDAC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x0c 0x86 # To remove nousound problem # MDAC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x0d 0x00 # To remove nousound problem # DOSR MSB
/usr/sbin/i2cset -f -y 3 0x18 0x0e 0x80 # To remove nousound problem # DOSR LSB
/usr/sbin/i2cset -f -y 3 0x18 0x12 0x86 # To remove nousound problem # NADC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x13 0x86 # To remove nousound problem # MADC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x14 0x80 # To remove nousound problem # ADC AOSR Values
/usr/sbin/i2cset -f -y 3 0x18 0x15 0x00 # To remove nousound problem # CLKOUT MUX 

#ASI config
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04 # Select Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x18 # To remove nousound problem # WORD LENGTH is 32 
#usr/sbin/i2cset -f -y 3 0x18 0x01 0x10 # To remove nousound problem # WORD LENGTH is 24 
/usr/sbin/i2cset -f -y 3 0x18 0x02 0x00 # To remove nousound problem # Left Ch_Offset_1
/usr/sbin/i2cset -f -y 3 0x18 0x03 0x00 # To remove nousound problem # Right Ch_Offset_2
/usr/sbin/i2cset -f -y 3 0x18 0x0a 0x25 # To remove nousound problem # WCLK and BCLK Control Register 
/usr/sbin/i2cset -f -y 3 0x18 0x0b 0x02 # To remove nousound problem # Bit Clock N Divider Input Control 
/usr/sbin/i2cset -f -y 3 0x18 0x0c 0x8c # To remove nousound problem # Bit Clock N Divider value 24 To remove nousound problem 
/usr/sbin/i2cset -f -y 3 0x18 0x43 0x22 # To remove nousound problem # DOUT1 for ASI1 data output

#signal processing
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00  #CHANGE : UNCOMMENTED AUDIO IMPROVEMENT
/usr/sbin/i2cset -f -y 3 0x18 0x3c 0x01  #CHANGE : UNCOMMENTED AUDIO IMPROVEMENT
/usr/sbin/i2cset -f -y 3 0x18 0x3d 0x01  #CHANGE : UNCOMMENTED AUDIO IMPROVEMENT

#op channel
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x3f 0xc0 #Left and right DAC channel is powered-up
/usr/sbin/i2cset -f -y 3 0x18 0x40 0x00 #Primary DAC Master Volume Configuration ??
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01 
/usr/sbin/i2cset -f -y 3 0x18 0x03 0x00 #Left DAC in mode PTM_P3, PTM_P4
/usr/sbin/i2cset -f -y 3 0x18 0x04 0x00 #Right DAC in mode PTM_P3, PTM_P4

#SPEAKER-OFF
/usr/sbin/i2cset -f -y 3 0x18 0x2e 0x7f #Not-Route LOL to SPK-Left @ 0dB  
/usr/sbin/i2cset -f -y 3 0x18 0x2f 0x7f #Not-Route LOR to SPK-Right @ 0dB 
/usr/sbin/i2cset -f -y 3 0x18 0x30 0x00 #Mute Left & Right Speaker
/usr/sbin/i2cset -f -y 3 0x18 0x2d 0x00 #Power-Down Stereo Speaker

#HEADSET-OFF
/usr/sbin/i2cset -f -y 3 0x18 0x1f 0xb9 #HPL Driver Volume Control : Muted
/usr/sbin/i2cset -f -y 3 0x18 0x20 0xb9 #HPR Driver Volume Control : Muted
#/usr/sbin/i2cset -f -y 3 0x18 0x1b 0x33 #Headphone Amplifier Control : power UP HPL and HPR
/usr/sbin/i2cset -f -y 3 0x18 0x1b 0x30 #CHANGE : Headphone Amplifier Control : power DOWN HPL and HPR

#HANDSET-ON
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01
/usr/sbin/i2cset -f -y 3 0x18 0x16 0xa2 #Lineout Amplifier Control: Left DAC M-terminal is routed to LOL driver,Right DAC P-terminal is routed to LOL driver,LOL output driver power-up
/usr/sbin/i2cset -f -y 3 0x18 0x24 0x00 #LOL Output Routed to RECP at 0db 
/usr/sbin/i2cset -f -y 3 0x18 0x25 0x80 #LOL to RECP and LOR to RECM at 0db
#/usr/sbin/i2cset -f -y 3 0x18 0x26 0x00 #IN1L Input Routed to RECP at 0db #CHANGE : Commented For handset noise
/usr/sbin/i2cset -f -y 3 0x18 0x26 0x7f #IN1L Input not Routed to RECP     #CHANGE : AUDIO IMPROVEMENT : Handset noise
/usr/sbin/i2cset -f -y 3 0x18 0x27 0x7f #IN1R Input Not Routed to RECM     #CHANGE : AUDIO IMPROVEMENT : Handset noise
#/usr/sbin/i2cset -f -y 3 0x18 0x28 0xc6 #Power-UP RECM & RECP @ 6dB
/usr/sbin/i2cset -f -y 3 0x18 0x28 0xfd #Power-UP RECM & RECP @ -3dB : For Reducing NOISE
/usr/sbin/i2cset -f -y 3 0x18 0x29 0x86 #RECM & RECP Volume Control
/usr/sbin/i2cset -f -y 3 0x18 0x2a 0x04 #Receiver Amplifier Control 

#adc config                  
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01
/usr/sbin/i2cset -f -y 3 0x18 0x08 0x00 #Common Mode Register : 0.9V
/usr/sbin/i2cset -f -y 3 0x18 0x33 0x05 #CHANGE: MIC BIAS 2.4V
/usr/sbin/i2cset -f -y 3 0x18 0x34 0x10 #CHANGE: IN2L TO LPGA-P, RIN = 10K
/usr/sbin/i2cset -f -y 3 0x18 0x36 0x40 #CHANGE: CM1 TO LPGA-M, RIN = 10K, Internal to Left MIC PGA
/usr/sbin/i2cset -f -y 3 0x18 0x37 0x01 #CHANGE: IN2L TO RPGA-P, RIN = 10K
/usr/sbin/i2cset -f -y 3 0x18 0x39 0x40 #CHANGE: CM1 Selected, RIN = 10K, Internal to Right MIC PGA                            
/usr/sbin/i2cset -f -y 3 0x18 0x3b 0x2e #CHANGE : Left  MIC PGA is enabled, at 23dB 
/usr/sbin/i2cset -f -y 3 0x18 0x3c 0x2e #CHANGE : Right MIC PGA is enabled, at 23dB 
/usr/sbin/i2cset -f -y 3 0x18 0x3d 0x00 #ADC PowerTune Configuration Register : PTM_R4
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x51 0xc0 #Left & Right ADC power UP, not configured for Digital Microphone, Volume changes by 1 step
/usr/sbin/i2cset -f -y 3 0x18 0x52 0x00 #Left & Right ADC Un-Mute , at 0dB

#enable headphone detection
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -a -y 3 0x18 0x43 0x80
/usr/sbin/i2cset -f -a -y 3 0x18 0x30 0x80
/usr/sbin/i2cset -f -a -y 3 0x18 0x33 0xc0
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x04
/usr/sbin/i2cset -f -a -y 3 0x18 0x56 0x16
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00

#CHANGE:Enable AGC                                                                                                                                                                              
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00                                                                                                                                             
/usr/sbin/i2cset -f -a -y 3 0x18 0x56 0x82 #Left AGC control registr Gain -5.5db and hysteresis 1db                                                                       
/usr/sbin/i2cset -f -a -y 3 0x18 0x5e 0x82  #Right AGC control registr Gain -5.5db and hysteresis 1db                                                                                          
/usr/sbin/i2cset -f -a -y 3 0x18 0x57 0xa0  #Left noise control hysteresis 4db -62db 
/usr/sbin/i2cset -f -a -y 3 0x18 0x5f 0xa0  #Right noise control hysteresis 4db -62db
/usr/sbin/i2cset -f -a -y 3 0x18 0x58 0x28  #Left AGC gain max 9dB 
/usr/sbin/i2cset -f -a -y 3 0x18 0x60 0x28 #Right AGC gain max 9dB 
/usr/sbin/i2cset -f -a -y 3 0x18 0x59 0x00 #attack time
/usr/sbin/i2cset -f -a -y 3 0x18 0x61 0x00 #attack time             
/usr/sbin/i2cset -f -a -y 3 0x18 0x5a 0x32 #decay time                
/usr/sbin/i2cset -f -a -y 3 0x18 0x62 0x32 #decay time

SCRIPT_NAME="/home/root/scripts/test_echo.sh"

# Get the PID of the script
PID=$(pgrep -f "$SCRIPT_NAME")
#echo "PID is $PID" >> /home/root/logs/echo.log 
# Check if PID is not empty
if [ -n "$PID" ]; then
	#echo "$SCRIPT_NAME is already running. Killing it..." >> /home/root/logs/echo.log 
	kill -9 "$PID"
	#echo "$SCRIPT_NAME killed" >> /home/root/logs/echo.log
fi


# FIX FOR NO SOUND PROBLEM
# Read Value of register 0x41
exp_val=0x04
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
curr_val=$(/usr/sbin/i2cget -y -f 3 0x18 0x41)
if [ "$curr_val" != "$exp_val" ]; then
        echo " " 
        echo "########################################## " 
        echo " No Sound problem detected!! " 
        echo " Register Dump for Page 4" 
        /usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
        /usr/sbin/i2cdump -y -f 3 0x18 
        echo " Rewriting the register value "
        echo "########################################## " 
        echo " "
	/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
        /usr/sbin/i2cset -y -f 3 0x18 0x41 0x04
fi

#To get last Gain values of the current AudioDevice from Database
if output_vol=$(/home/root/bin/sqlite3 /home/root/cfg/PhoneConfig.db "select field_value from Volume_Control_Table where field_name='handset_vol'")
then 
	if [ -z "$output_vol" ];then	
   	 echo " output_vol is not valid "
	fi
	output_vol=$(echo "$output_vol * 1.75 " | bc)                       
	amixer -c BeagleBoardX15 sset 'PCM' "$output_vol"
else 
	echo "$(date +"%m_%d_%Y")" "${BASH_SOURCE[@]}" "$LINENO" "Error: SQLite query failed" >> /home/root/logs/scripts.log
fi

