#!/bin/bash
#sw reset # To remove nousound problem
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00 # Initialize to Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x7f 0x00 # Initialize to Book 0
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x01 # Initialize the device through software reset
usleep 1000   # 1 millisecond delay

#power config # To remove nousound problem 
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01 #Select Page 1
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x00 # Power configuration register
/usr/sbin/i2cset -f -y 3 0x18 0x7a 0x01 # Reference Powerup Delay Register - 0x00

#clock initialize 
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00 # Select Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x04 0x33 # To remove nousound problem # Clock input multiplexer; set DAC_CLKIN = PLL_CLK
/usr/sbin/i2cset -f -y 3 0x18 0x05 0x00 # To remove nousound problem # Multiplexer; set PLL_CLKIN=MCLK1
/usr/sbin/i2cset -f -y 3 0x18 0x06 0x91 # To remove nousound problem # P and R value (PLL clock parameters)
/usr/sbin/i2cset -f -y 3 0x18 0x07 0x06 # To remove nousound problem # J value (PLL clock parameter)
/usr/sbin/i2cset -f -y 3 0x18 0x08 0x14 # To remove nousound problem # PLL D Values (MSB)
/usr/sbin/i2cset -f -y 3 0x18 0x09 0xbb # To remove nousound problem # PLL D Values (LSB)
/usr/sbin/i2cset -f -y 3 0x18 0x0a 0x02 # To remove nousound problem # PLL_CLKIN Divider
/usr/sbin/i2cset -f -y 3 0x18 0x0b 0x86 # To remove nousound problem # NDAC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x0c 0x86 # To remove nousound problem # MDAC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x0d 0x00 # To remove nousound problem # DOSR MSB
/usr/sbin/i2cset -f -y 3 0x18 0x0e 0x80 # To remove nousound problem # DOSR LSB
/usr/sbin/i2cset -f -y 3 0x18 0x12 0x86 # To remove nousound problem # NADC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x13 0x86 # To remove nousound problem # MADC Divider Values
/usr/sbin/i2cset -f -y 3 0x18 0x14 0x80 # To remove nousound problem # ADC AOSR Values
/usr/sbin/i2cset -f -y 3 0x18 0x15 0x00 # To remove nousound problem # CLKOUT MUX 

#ASI config
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04 # Select Page 0
/usr/sbin/i2cset -f -y 3 0x18 0x01 0x18 # To remove nousound problem # WORD LENGTH is 32 
#usr/sbin/i2cset -f -y 3 0x18 0x01 0x10 # To remove nousound problem # WORD LENGTH is 24 
/usr/sbin/i2cset -f -y 3 0x18 0x02 0x00 # To remove nousound problem # Left Ch_Offset_1
/usr/sbin/i2cset -f -y 3 0x18 0x03 0x00 # To remove nousound problem # Right Ch_Offset_2
/usr/sbin/i2cset -f -y 3 0x18 0x0a 0x25 # To remove nousound problem # WCLK and BCLK Control Register 
/usr/sbin/i2cset -f -y 3 0x18 0x0b 0x02 # To remove nousound problem # Bit Clock N Divider Input Control 
/usr/sbin/i2cset -f -y 3 0x18 0x0c 0x8c # To remove nousound problem # Bit Clock N Divider value 24 To remove nousound problem 
/usr/sbin/i2cset -f -y 3 0x18 0x43 0x22 # To remove nousound problem # DOUT1 for ASI1 data output

#signal processing
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00  #CHANGE 280624 : UNCOMMENTED
/usr/sbin/i2cset -f -y 3 0x18 0x3c 0x01
/usr/sbin/i2cset -f -y 3 0x18 0x3d 0x01

#op channel
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x3f 0xc0
#/usr/sbin/i2cset -f -y 3 0x18 0x40 0x00 
/usr/sbin/i2cset -f -y 3 0x18 0x40 0x02  # CHANGE : Primary DAC Master Volume Configuration : Right channel controlled by left channel 
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01
/usr/sbin/i2cset -f -y 3 0x18 0x03 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x04 0x00

#HANDSET-OFF
/usr/sbin/i2cset -f -y 3 0x18 0x08 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x24 0x7f
/usr/sbin/i2cset -f -y 3 0x18 0x25 0x7f
/usr/sbin/i2cset -f -y 3 0x18 0x26 0x7f
/usr/sbin/i2cset -f -y 3 0x18 0x28 0x39 #Power-Down RECM & RECP
/usr/sbin/i2cset -f -y 3 0x18 0x29 0xb9 #RECM & RECP Volume Control
/usr/sbin/i2cset -f -y 3 0x18 0x2a 0x08 

#HEADSET-OFF                            
/usr/sbin/i2cset -f -y 3 0x18 0x1f 0xb9 
/usr/sbin/i2cset -f -y 3 0x18 0x20 0xb9 
#/usr/sbin/i2cset -f -y 3 0x18 0x1b 0x33 #Headphone Amplifier Control : power UP HPL and HPR
/usr/sbin/i2cset -f -y 3 0x18 0x1b 0x30 #CHANGE : Headphone Amplifier Control : power DOWN HPL and HPR

#SPEAKER-ON
/usr/sbin/i2cset -f -y 3 0x18 0x16 0xc3
/usr/sbin/i2cset -f -y 3 0x18 0x2e 0x12 #CHANGE : Route LOL to SPK-Left @ -9dB
/usr/sbin/i2cset -f -y 3 0x18 0x2f 0x80 #CHANGE : Control by LOL gain
#/usr/sbin/i2cset -f -y 3 0x18 0x30 0x20 #CHANGE : Set Speaker Gain @12DB
/usr/sbin/i2cset -f -y 3 0x18 0x30 0x30 #CHANGE : Set Speaker Gain @18DB
/usr/sbin/i2cset -f -y 3 0x18 0x2d 0x06 # CHANGE : Power-UP mono Speaker

#adc config                  
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x01
/usr/sbin/i2cset -f -y 3 0x18 0x08 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x33 0x05  # CHANGE : MIC BIAS TO 2.4V
/usr/sbin/i2cset -f -y 3 0x18 0x34 0x04  # CHANGE: IN3L TO LPGA-P 10K
/usr/sbin/i2cset -f -y 3 0x18 0x36 0x04  # CHANGE: IN3R TO LPGA-M 10K
/usr/sbin/i2cset -f -y 3 0x18 0x37 0x04  # CHANGE: IN3R TO RPGA-P 10K
/usr/sbin/i2cset -f -y 3 0x18 0x39 0x04  # CHANGE: IN3L TO RPGA-M 10K
#/usr/sbin/i2cset -f -y 3 0x18 0x3b 0x50 # CHANGE : MIC GAIN SET TO 40 db
#/usr/sbin/i2cset -f -y 3 0x18 0x3c 0x50 # CHANGE : MIC GAIN SET TO 40 db
/usr/sbin/i2cset -f -y 3 0x18 0x3b 0x46 # CHANGE : MIC GAIN SET TO 35 db
/usr/sbin/i2cset -f -y 3 0x18 0x3c 0x46 # CHANGE : MIC GAIN SET TO 35 db
/usr/sbin/i2cset -f -y 3 0x18 0x3d 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -y 3 0x18 0x51 0xc0
/usr/sbin/i2cset -f -y 3 0x18 0x52 0x00

#enable headphone detection
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00
/usr/sbin/i2cset -f -a -y 3 0x18 0x43 0x80
/usr/sbin/i2cset -f -a -y 3 0x18 0x30 0x80
/usr/sbin/i2cset -f -a -y 3 0x18 0x33 0xc0
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x04
/usr/sbin/i2cset -f -a -y 3 0x18 0x56 0x16
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00

#CHANGE : Enable AGC                                                                                                                                                                            
/usr/sbin/i2cset -f -a -y 3 0x18 0x00 0x00                                                                                                                                                    
/usr/sbin/i2cset -f -a -y 3 0x18 0x56 0x82  #Left AGC control registr Gain -5.5db and hysteresis 1db                                                                                             
/usr/sbin/i2cset -f -a -y 3 0x18 0x5e 0x82  #Right AGC control registr Gain -5.5db and hysteresis 1db                                                                                          
/usr/sbin/i2cset -f -a -y 3 0x18 0x57 0xAE  #Left noise control hysteresis 4db threshold is -70db
/usr/sbin/i2cset -f -a -y 3 0x18 0x5f 0xAE  # Right noise control hysteresis 4db threshold is -70db
#/usr/sbin/i2cset -f -a -y 3 0x18 0x57 0xa8  #Left noise control hysteresis 4db threshold is -50db
#/usr/sbin/i2cset -f -a -y 3 0x18 0x5f 0xa8  # Right noise control hysteresis 4db threshold is -50db
#/usr/sbin/i2cset -f -a -y 3 0x18 0x58 0x44 #Left AGC gain max 36db :: 2023-08-02
#/usr/sbin/i2cset -f -a -y 3 0x18 0x60 0x44  #Right AGC gain max 36db
/usr/sbin/i2cset -f -a -y 3 0x18 0x58 0x3c #Left AGC gain max 30db :: 2023-08-02
/usr/sbin/i2cset -f -a -y 3 0x18 0x60 0x3c  #Right AGC gain max 30db
/usr/sbin/i2cset -f -a -y 3 0x18 0x59 0x04 #attack time 1*32 WClk scaling factor 8
/usr/sbin/i2cset -f -a -y 3 0x18 0x61 0x04 #attack time 1*32 WClk scaling factor 8
/usr/sbin/i2cset -f -a -y 3 0x18 0x5a 0x32 #decay time 7*512 WClk scaling factor 4
/usr/sbin/i2cset -f -a -y 3 0x18 0x62 0x32 #decay time 7*512 WClk scaling factor 4


# FIX FOR NO SOUND PROBLEM
# Read Value of register 0x41
exp_val=0x04
/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
curr_val=$(/usr/sbin/i2cget -y -f 3 0x18 0x41)
if [ "$curr_val" != "$exp_val" ]; then
	echo " "                                                       
	echo "########################################## "
	echo " No Sound problem detected!! "   
	echo " Register Dump for Page 4"  
	/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
	/usr/sbin/i2cdump -y -f 3 0x18                               
	echo " Rewriting the register value "                                                                                                     
	echo "########################################## "                                                                                        
	echo " "           
	/usr/sbin/i2cset -f -y 3 0x18 0x00 0x04
	/usr/sbin/i2cset -y -f 3 0x18 0x41 0x04
fi
SCRIPT_NAME="/home/root/scripts/test_echo.sh"

if [ "$1" -eq 1 ]; then
	# Get the PID of the script
	PID=$(pgrep -f "$SCRIPT_NAME")
	#echo "PID is $PID" >> /home/root/logs/echo.log 
	# Check if PID is not empty
	if [ -n "$PID" ]; then
		#echo "$SCRIPT_NAME is already running. Killing it..." >> /home/root/logs/echo.log 
		kill -9 "$PID"
		#echo "$SCRIPT_NAME killed" >> /home/root/logs/echo.log
	fi
	$SCRIPT_NAME >> /home/root/logs/echo.log 2>&1 & 
fi


#To get last Gain value of the current AudioDevice from Database
#if output_vol=$(/home/root/bin/sqlite3 /home/root/cfg/PhoneConfig.db "select field_value from Volume_Control_Table where field_name='speaker_vol'")
#then
#	if [ -z "$output_vol" ];then	
#           echo "return check output_vol  not valid "
#	fi
#	output_vol=$(echo "$output_vol * 1.75" | bc)
#	amixer -c BeagleBoardX15 sset 'PCM' "$output_vol"
#else
#	echo "$(date +"%m_%d_%Y")" "${BASH_SOURCE[@]}" "$LINENO" "Error: SQLite query failed" >> /home/root/logs/scripts.log
#fi
