//CONTROL LOCATIONS
typedef struct {
            u8 control_page;           //coefficient page location
            u8 control_base;           //coefficient base address within page
            u8 control_mute_flag;      //non-zero means muting required
            u8 control_string_index;   //string table index
} control; 


static control MUX_controls[] = {
};

static string MUX_control_names[] = {
};

static control VOLUME_controls[] = {
};

static string VOLUME_control_names[] = {
};

//INSTRUCTIONS & COEFFICIENTS
typedef struct {
    u8 reg_off;
    u8 reg_val;
} reg_value;

static string REG_Section_names[] = {
    "miniDSP_A_reg_values",
    "miniDSP_D_reg_values",
};

reg_value REG_Section_program[] = {
    {  0,0x0},
    {  0x7F,0x00},
//			# Set AutoINC
    {121,0x01},
//			# reg[  0][  0][  1] = 0x01        	; S/W Reset
    {  1,0x01},
//			# reg[  0][  0][254] = 0x0a	      	; Delay 10ms
    {254,0x0A},
//			# reg[  0][  0][  4] = 0x00		; ADC_CLKIN = MCLK1, DAC_CLKIN = MCLK1
    {  4,0x00},
//			# reg[  0][  0][ 13] = 0x01		; DOSR = 256 (MSB)
    { 13,0x01},
//			# reg[  0][  0][ 14] = 0x00		; DOSR = 256 (LSB)
    { 14,0x00},
//			# reg[  0][  0][ 11] = 0x81		; NDAC = 1, divider powered on
    { 11,0x81},
//			# reg[  0][  0][ 12] = 0x81		; MDAC = 1, divider powered on
    { 12,0x81},
//			# reg[  0][  0][ 18] = 0x01		; NADC Powerdown, ADC_CLK same as DAC CLK
    { 18,0x01},
//			# reg[  0][  0][ 19] = 0x82		; MADC Powerup MADC = 2
    { 19,0x82},
//			# reg[  0][  0] [20] = 0x80		; AOSR = 128
    { 20,0x80},
    {  0x7F,0x78},
//			# reg[120][  0][ 50] = 0x88         	; Interpolation Ratio is 8, FIFO = Enabled
    { 50,0x88},
    {  0x7F,0x64},
//			# reg[100][  0][ 50] = 0xa4         	; Decimation Ratio is 4, CIC AutoNorm = Enabled, FIFO = Enabled
    { 50,0xA4},
    {  0x7F,0x00},
//			# reg[  0][  0][ 60] = 0x80       	; DAC prog Mode, DAC & ADC filter engines powered up together
    { 60,0x80},
    {  0,0x01},
//			# reg[  0][  1][  1] = 0x00		; Crude avdd disabled
    {  1,0x00},
//			# reg[  0][  1][  3] = 0x00		; LDAC PowerTune config
    {  3,0x00},
//			# reg[  0][  1][  4] = 0x00		; RDAC PowerTune config
    {  4,0x00},
//			# reg[  0][  1][ 31] = 0xBA		; HP in ground Centered mode; HPL gain -6 dB
    { 31,0xBA},
//			# reg[  0][  1][ 32] = 0xBA		; HPR gain same as HPL
    { 32,0xBA},
//			# reg[  0][  1][ 33] = 0x28		; Charge pump runs on Osc./4
    { 33,0x28},
//			# reg[  0][  1][ 34] = 0x33		; Set CP mode
    { 34,0x33},
//			# reg[  0][  1][ 35] = 0x10		; Power up CP with HP
    { 35,0x10},
//			# reg[  0][  1][122] = 0x01		; Vref charge time - 40 ms.
    {122,0x01},
    {  0,0x0},
    {  0x7F,0x78},
//			# reg[120][0][24]=0x80
    { 24,0x80},
    {255,0x00},
    {255,0x01},
    {  0,0x0},
    {  0x7F,0x28},
//			# reg[ 40][  0][  1] = 0x04		; adaptive mode for ADC
    {  1,0x04},
    {  0x7F,0x50},
//			# reg[ 80][  0][  1] = 0x04		; adaptive mode for DAC
    {  1,0x04},
    {  0x7F,0x64},
//			
    { 48,0x04},
//			
    { 49,0x00},
    {  0x7F,0x78},
//			
    { 48,0x04},
//			
    { 49,0x00},
    {  0x7F,0x64},
//			# reg[100][  0][ 48] = 12
    { 48,0x0C},
//			# reg[100][  0][ 49] = 0
    { 49,0x00},
    {  0x7F,0x78},
//			# reg[120][  0][ 48] = 12
    { 48,0x0C},
//			# reg[120][  0][ 49] = 0
    { 49,0x00},
    {  0x7F,0x00},
//			# reg[  0][  0][ 63] = 0xc2		; DAC L&R DAC powerup Ldata-LDAC Rdata-RDAC (soft-stepping disable)
    { 63,0xC2},
//			# reg[  0][  0][ 64] = 0x00		; DAC Left and Right DAC unmuted with indep.  vol. ctrl
    { 64,0x00},
    {  0,0x01},
//			# reg[  0][  1][ 22] = 0xc3         ; LDAC -> LOL, RDAC -> LOR; Power on LOL + LOR
    { 22,0xC3},
//			# reg[  0][  1][ 27] = 0x33		; LDAC -> HPL, RDAC -> HPR; Power on HPL + HPR
    { 27,0x33},
    {  0,0x04},
//			# reg[  0][  4][ 17] = 0            ; ASI2 Audio Interface = I2S, 16 bits
    { 17,0x00},
//			# reg[  0][  4][ 26] = 0x24         ; ASI2 Audio Interface WCLK and BCLK are outputs
    { 26,0x24},
//			# reg[  0][  4][ 23] = 0x00         ; ASI2 Data Output disabled
    { 23,0x00},
//			# reg[  0][  4][ 24] = 0x00		; ASI2 Left DAC Datapath = Off, ASI2 Right DAC Datapath = Off
    { 24,0x00},
//			# reg[  0][  4][ 28] = 0x88		; ASI2 BCLK divider powered up, N=8
    { 28,0x88},
//			# reg[  0][  4][ 30] = 0x20         ; ASI2 BCLK and WCLK muxing
    { 30,0x20},
//			# reg[  0][  4][ 69] = 0x04         ; Select WCLK2 pin for ASI2 WCLK signal
    { 69,0x04},
//			# reg[  0][  4][ 70] = 0x04         ; Select BCLK2 pin for ASI2 BCLK signal
    { 70,0x04},
//			# reg[  0][  4][ 72] = 0x20         ; Select DIN2 pin for ASI2 DIN signal
    { 72,0x20},
//			# reg[  0][  4][  1] = 0            ; ASI1 Audio Interface = I2S, 16 bits
    {  1,0x00},
//			# reg[  0][  4][ 10] = 0x24         ; ASI1 Audio Interface WCLK and BCLK are outputs
    { 10,0x24},
//			# reg[  0][  4][  7] = 0x00         ; ASI1 Data Output disabled
    {  7,0x00},
//			# reg[  0][  4][  8] = 0x50		; ASI1 Left DAC Datapath = Left Data, ASI1 Right DAC Datapath = Right Data
    {  8,0x50},
//			# reg[  0][  4][ 12] = 0x88		; ASI1 BCLK divider powered up, N=8
    { 12,0x88},
//			# reg[  0][  4][ 14] = 0x00         ; ASI1 BCLK and WCLK muxing
    { 14,0x00},
//			# reg[  0][  4][ 65] = 0x04         ; Select WCLK1 pin for ASI1 WCLK signal
    { 65,0x04},
//			# reg[  0][  4][ 68] = 0x20         ; Select DIN1 pin for ASI1 DIN signal
    { 68,0x20},
    {  0,0x0},
    {  0x7F,0x64},
//			# reg[100][  0][ 20] = 0x00 		; Disable ADC double buffer mode
    { 20,0x00},
    {  0x7F,0x78},
//			# reg[120][  0][ 20] = 0x00 		; Disable DAC double buffer mode
    { 20,0x00},
    {  0x7F,0x00},
//			# reg[0][0][11] = 0x82	              ; NDAC = 1, divider powered off
    { 11,0x82},
};

reg_value miniDSP_A_reg_values[] = {
    {  0,0x0},
    {  0x7F,0x28},
    {  0,0x01},
    {  8,0xFF},
    {  9,0xFF},
    { 10,0xFF},
    { 11,0x00},
    { 12,0x80},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xFF},
    { 18,0xFF},
    { 19,0x00},
    { 20,0x40},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x01},
    { 30,0x00},
    { 31,0x00},
    { 32,0x79},
    { 33,0xBC},
    { 34,0x38},
    { 35,0x00},
    { 36,0xD8},
    { 37,0x72},
    { 38,0x22},
    { 39,0x00},
    { 40,0x40},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0xFF},
    { 45,0x9D},
    { 46,0x00},
    { 47,0x00},
    {  0,0x09},
    { 72,0xFF},
    { 73,0xFF},
    { 74,0xFF},
    { 75,0x00},
    { 76,0x80},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x7F},
    { 81,0xFF},
    { 82,0xFF},
    { 83,0x00},
    { 84,0x40},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x01},
    { 94,0x00},
    { 95,0x00},
    { 96,0x79},
    { 97,0xBC},
    { 98,0x38},
    { 99,0x00},
    {100,0xD8},
    {101,0x72},
    {102,0x22},
    {103,0x00},
    {104,0x40},
    {105,0x00},
    {106,0x00},
    {107,0x00},
    {108,0xFF},
    {109,0x9D},
    {110,0x00},
    {111,0x00},
    {  0,0x0},
    {  0x7F,0x14},
    {  0,0x01},
    {  8,0xC0},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    {  0,0x0},
    {  0x7F,0x64},
    {  0,0x01},
    {  8,0x58},
    {  9,0x60},
    { 10,0x00},
    { 11,0x05},
    { 12,0x59},
    { 13,0x00},
    { 14,0x00},
    { 15,0x09},
    { 16,0x40},
    { 17,0x00},
    { 18,0x20},
    { 19,0x05},
    { 20,0x58},
    { 21,0x60},
    { 22,0x00},
    { 23,0x07},
    { 24,0x10},
    { 25,0x00},
    { 26,0x00},
    { 27,0x04},
    { 28,0x44},
    { 29,0x00},
    { 30,0x40},
    { 31,0x0B},
    { 32,0x58},
    { 33,0x60},
    { 34,0x00},
    { 35,0x04},
    { 36,0x44},
    { 37,0x00},
    { 38,0x40},
    { 39,0x04},
    { 40,0x10},
    { 41,0x00},
    { 42,0x00},
    { 43,0x03},
    { 44,0x18},
    { 45,0x00},
    { 46,0x20},
    { 47,0x03},
    { 48,0x10},
    { 49,0x00},
    { 50,0x00},
    { 51,0x02},
    { 52,0x44},
    { 53,0x00},
    { 54,0x00},
    { 55,0x04},
    { 56,0x18},
    { 57,0x00},
    { 58,0x20},
    { 59,0x03},
    { 60,0x6C},
    { 61,0x00},
    { 62,0xC0},
    { 63,0x02},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x44},
    { 73,0x00},
    { 74,0x00},
    { 75,0x07},
    { 76,0x58},
    { 77,0x60},
    { 78,0x00},
    { 79,0x04},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x10},
    {105,0x00},
    {106,0x00},
    {107,0x01},
    {108,0x10},
    {109,0x00},
    {110,0x00},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x00},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x00},
    {121,0x00},
    {122,0x00},
    {123,0x00},
    {124,0x01},
    {125,0x04},
    {126,0x80},
    {127,0xD8},
    {  0,0x02},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x01},
    { 13,0x00},
    { 14,0x20},
    { 15,0x08},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x09},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x02},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
};
#define miniDSP_A_reg_values_COEFF_START   0
#define miniDSP_A_reg_values_COEFF_SIZE    91
#define miniDSP_A_reg_values_INST_START    91
#define miniDSP_A_reg_values_INST_SIZE     172

reg_value miniDSP_D_reg_values[] = {
    {  0,0x0},
    {  0x7F,0x50},
    {  0,0x01},
    {  8,0xFF},
    {  9,0xFF},
    { 10,0xFF},
    { 11,0x00},
    { 12,0x80},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x7F},
    { 17,0xF7},
    { 18,0x00},
    { 19,0x00},
    { 20,0x80},
    { 21,0x09},
    { 22,0x00},
    { 23,0x00},
    { 24,0x7F},
    { 25,0xEF},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x01},
    { 30,0x00},
    { 31,0x00},
    { 32,0x79},
    { 33,0xBC},
    { 34,0x38},
    { 35,0x00},
    { 36,0xD8},
    { 37,0x72},
    { 38,0x22},
    { 39,0x00},
    { 40,0x40},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x40},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x7F},
    { 49,0xFF},
    { 50,0xFF},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0xFF},
    { 57,0x9D},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x0D},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x1C},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x3E},
    { 70,0x00},
    { 71,0x00},
    { 72,0x00},
    { 73,0x78},
    { 74,0x00},
    { 75,0x00},
    { 76,0x02},
    { 77,0x4C},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0xD5},
    { 82,0x00},
    { 83,0x00},
    { 84,0x01},
    { 85,0x65},
    { 86,0x00},
    { 87,0x00},
    { 88,0x03},
    { 89,0xE9},
    { 90,0x00},
    { 91,0x00},
    { 92,0x07},
    { 93,0xCA},
    { 94,0x00},
    { 95,0x00},
    { 96,0xFF},
    { 97,0xEF},
    { 98,0x00},
    { 99,0x00},
    {100,0xFE},
    {101,0xEB},
    {102,0x00},
    {103,0x00},
    {104,0xFF},
    {105,0xA8},
    {106,0x00},
    {107,0x00},
    {108,0xFD},
    {109,0x08},
    {110,0x00},
    {111,0x00},
    {112,0xFF},
    {113,0x5E},
    {114,0x00},
    {115,0x00},
    {116,0xFF},
    {117,0xD5},
    {118,0x00},
    {119,0x00},
    {120,0xFE},
    {121,0x36},
    {122,0x00},
    {123,0x00},
    {124,0xFA},
    {125,0xAC},
    {126,0x00},
    {127,0x00},
    {  0,0x02},
    {  8,0xF2},
    {  9,0xA3},
    { 10,0x00},
    { 11,0x00},
    { 12,0x28},
    { 13,0xAB},
    { 14,0x00},
    { 15,0x00},
    { 16,0x3F},
    { 17,0xFF},
    { 18,0x00},
    { 19,0x00},
    { 20,0xFF},
    { 21,0x98},
    { 22,0x00},
    { 23,0x00},
    { 24,0xF6},
    { 25,0xF9},
    { 26,0x00},
    { 27,0x00},
    { 28,0x26},
    { 29,0xFB},
    { 30,0x00},
    { 31,0x00},
    { 32,0x02},
    { 33,0x72},
    { 34,0x00},
    { 35,0x00},
    { 36,0x40},
    { 37,0x02},
    { 38,0x00},
    { 39,0x00},
    { 40,0xFB},
    { 41,0xCB},
    { 42,0x00},
    { 43,0x00},
    { 44,0x20},
    { 45,0xA7},
    { 46,0x00},
    { 47,0x00},
    { 48,0xFF},
    { 49,0x6A},
    { 50,0x00},
    { 51,0x00},
    { 52,0x3A},
    { 53,0x0F},
    { 54,0x00},
    { 55,0x00},
    {  0,0x09},
    { 72,0xFF},
    { 73,0xFF},
    { 74,0xFF},
    { 75,0x00},
    { 76,0x80},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x7F},
    { 81,0xF7},
    { 82,0x00},
    { 83,0x00},
    { 84,0x80},
    { 85,0x09},
    { 86,0x00},
    { 87,0x00},
    { 88,0x7F},
    { 89,0xEF},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x01},
    { 94,0x00},
    { 95,0x00},
    { 96,0x79},
    { 97,0xBC},
    { 98,0x38},
    { 99,0x00},
    {100,0xD8},
    {101,0x72},
    {102,0x22},
    {103,0x00},
    {104,0x40},
    {105,0x00},
    {106,0x00},
    {107,0x00},
    {108,0x40},
    {109,0x00},
    {110,0x00},
    {111,0x00},
    {112,0x7F},
    {113,0xFF},
    {114,0xFF},
    {115,0x00},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0xFF},
    {121,0x9D},
    {122,0x00},
    {123,0x00},
    {124,0x00},
    {125,0x0D},
    {126,0x00},
    {127,0x00},
    {  0,0x0A},
    {  8,0x00},
    {  9,0x1C},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x3E},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x78},
    { 18,0x00},
    { 19,0x00},
    { 20,0x02},
    { 21,0x4C},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0xD5},
    { 26,0x00},
    { 27,0x00},
    { 28,0x01},
    { 29,0x65},
    { 30,0x00},
    { 31,0x00},
    { 32,0x03},
    { 33,0xE9},
    { 34,0x00},
    { 35,0x00},
    { 36,0x07},
    { 37,0xCA},
    { 38,0x00},
    { 39,0x00},
    { 40,0xFF},
    { 41,0xEF},
    { 42,0x00},
    { 43,0x00},
    { 44,0xFE},
    { 45,0xEB},
    { 46,0x00},
    { 47,0x00},
    { 48,0xFF},
    { 49,0xA8},
    { 50,0x00},
    { 51,0x00},
    { 52,0xFD},
    { 53,0x08},
    { 54,0x00},
    { 55,0x00},
    { 56,0xFF},
    { 57,0x5E},
    { 58,0x00},
    { 59,0x00},
    { 60,0xFF},
    { 61,0xD5},
    { 62,0x00},
    { 63,0x00},
    { 64,0xFE},
    { 65,0x36},
    { 66,0x00},
    { 67,0x00},
    { 68,0xFA},
    { 69,0xAC},
    { 70,0x00},
    { 71,0x00},
    { 72,0xF2},
    { 73,0xA3},
    { 74,0x00},
    { 75,0x00},
    { 76,0x28},
    { 77,0xAB},
    { 78,0x00},
    { 79,0x00},
    { 80,0x3F},
    { 81,0xFF},
    { 82,0x00},
    { 83,0x00},
    { 84,0xFF},
    { 85,0x98},
    { 86,0x00},
    { 87,0x00},
    { 88,0xF6},
    { 89,0xF9},
    { 90,0x00},
    { 91,0x00},
    { 92,0x26},
    { 93,0xFB},
    { 94,0x00},
    { 95,0x00},
    { 96,0x02},
    { 97,0x72},
    { 98,0x00},
    { 99,0x00},
    {100,0x40},
    {101,0x02},
    {102,0x00},
    {103,0x00},
    {104,0xFB},
    {105,0xCB},
    {106,0x00},
    {107,0x00},
    {108,0x20},
    {109,0xA7},
    {110,0x00},
    {111,0x00},
    {112,0xFF},
    {113,0x6A},
    {114,0x00},
    {115,0x00},
    {116,0x3A},
    {117,0x0F},
    {118,0x00},
    {119,0x00},
    {  0,0x0},
    {  0x7F,0x3C},
    {  0,0x01},
    {  8,0xC0},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0xC0},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    {  0,0x0},
    {  0x7F,0x78},
    {  0,0x01},
    {  8,0x58},
    {  9,0x60},
    { 10,0x00},
    { 11,0x05},
    { 12,0x59},
    { 13,0x00},
    { 14,0x00},
    { 15,0x0C},
    { 16,0x40},
    { 17,0x00},
    { 18,0x20},
    { 19,0x07},
    { 20,0x58},
    { 21,0x60},
    { 22,0x00},
    { 23,0x07},
    { 24,0x10},
    { 25,0x00},
    { 26,0x00},
    { 27,0x06},
    { 28,0x44},
    { 29,0x00},
    { 30,0x40},
    { 31,0x0B},
    { 32,0x58},
    { 33,0x60},
    { 34,0x00},
    { 35,0x0B},
    { 36,0x44},
    { 37,0x00},
    { 38,0x40},
    { 39,0x04},
    { 40,0x10},
    { 41,0x00},
    { 42,0x00},
    { 43,0x05},
    { 44,0x18},
    { 45,0x00},
    { 46,0x20},
    { 47,0x05},
    { 48,0x10},
    { 49,0x00},
    { 50,0x00},
    { 51,0x04},
    { 52,0x44},
    { 53,0x00},
    { 54,0x00},
    { 55,0x04},
    { 56,0x18},
    { 57,0x00},
    { 58,0x20},
    { 59,0x05},
    { 60,0x6C},
    { 61,0x00},
    { 62,0xC0},
    { 63,0x04},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x44},
    { 73,0x00},
    { 74,0x00},
    { 75,0x07},
    { 76,0x58},
    { 77,0x60},
    { 78,0x00},
    { 79,0x0B},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x10},
    {105,0x00},
    {106,0x00},
    {107,0x03},
    {108,0x10},
    {109,0x00},
    {110,0x00},
    {111,0x02},
    {112,0x58},
    {113,0x60},
    {114,0x08},
    {115,0x01},
    {116,0x60},
    {117,0x60},
    {118,0x00},
    {119,0x00},
    {120,0x58},
    {121,0x60},
    {122,0x00},
    {123,0x0B},
    {124,0x00},
    {125,0x00},
    {126,0x00},
    {127,0x00},
    {  0,0x02},
    {  8,0x44},
    {  9,0x00},
    { 10,0xC0},
    { 11,0x16},
    { 12,0x08},
    { 13,0x00},
    { 14,0x00},
    { 15,0x47},
    { 16,0x08},
    { 17,0x00},
    { 18,0x20},
    { 19,0x87},
    { 20,0x08},
    { 21,0x00},
    { 22,0x00},
    { 23,0x46},
    { 24,0x08},
    { 25,0x00},
    { 26,0x20},
    { 27,0x86},
    { 28,0x08},
    { 29,0x00},
    { 30,0x00},
    { 31,0x45},
    { 32,0x08},
    { 33,0x00},
    { 34,0x20},
    { 35,0x85},
    { 36,0x08},
    { 37,0x00},
    { 38,0x00},
    { 39,0x44},
    { 40,0x08},
    { 41,0x00},
    { 42,0x20},
    { 43,0x84},
    { 44,0x08},
    { 45,0x00},
    { 46,0x00},
    { 47,0x43},
    { 48,0x08},
    { 49,0x00},
    { 50,0x20},
    { 51,0x83},
    { 52,0x08},
    { 53,0x00},
    { 54,0x00},
    { 55,0x42},
    { 56,0x08},
    { 57,0x00},
    { 58,0x20},
    { 59,0x82},
    { 60,0x08},
    { 61,0x00},
    { 62,0x00},
    { 63,0x41},
    { 64,0x08},
    { 65,0x00},
    { 66,0x20},
    { 67,0x81},
    { 68,0x08},
    { 69,0x00},
    { 70,0x00},
    { 71,0x40},
    { 72,0x08},
    { 73,0x00},
    { 74,0x20},
    { 75,0x80},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x00},
    { 81,0x00},
    { 82,0x00},
    { 83,0x00},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x44},
    { 97,0x00},
    { 98,0x00},
    { 99,0x06},
    {100,0x21},
    {101,0x00},
    {102,0x20},
    {103,0x00},
    {104,0x4B},
    {105,0x00},
    {106,0xC0},
    {107,0x00},
    {108,0x4B},
    {109,0x00},
    {110,0xE0},
    {111,0x00},
    {112,0x00},
    {113,0x00},
    {114,0x40},
    {115,0x48},
    {116,0x0C},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x0C},
    {121,0x00},
    {122,0x20},
    {123,0x00},
    {124,0x18},
    {125,0x01},
    {126,0x20},
    {127,0x01},
    {  0,0x03},
    {  8,0x18},
    {  9,0x01},
    { 10,0x20},
    { 11,0x02},
    { 12,0x18},
    { 13,0x00},
    { 14,0x60},
    { 15,0x0B},
    { 16,0x1C},
    { 17,0x00},
    { 18,0x80},
    { 19,0x0D},
    { 20,0x10},
    { 21,0x00},
    { 22,0x20},
    { 23,0x0A},
    { 24,0x10},
    { 25,0x00},
    { 26,0x20},
    { 27,0x48},
    { 28,0x1C},
    { 29,0x00},
    { 30,0x40},
    { 31,0x0A},
    { 32,0x18},
    { 33,0x00},
    { 34,0x60},
    { 35,0x49},
    { 36,0x1C},
    { 37,0x00},
    { 38,0x80},
    { 39,0x4D},
    { 40,0x1C},
    { 41,0x00},
    { 42,0x40},
    { 43,0x48},
    { 44,0x10},
    { 45,0x30},
    { 46,0x00},
    { 47,0x0C},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x10},
    { 57,0x30},
    { 58,0x00},
    { 59,0x4C},
    { 60,0x18},
    { 61,0x01},
    { 62,0xA0},
    { 63,0x31},
    { 64,0x1C},
    { 65,0x01},
    { 66,0xC0},
    { 67,0x0E},
    { 68,0x1C},
    { 69,0x01},
    { 70,0xA0},
    { 71,0x0C},
    { 72,0x1C},
    { 73,0x01},
    { 74,0xC0},
    { 75,0x2F},
    { 76,0x1C},
    { 77,0x01},
    { 78,0xE0},
    { 79,0x10},
    { 80,0x1C},
    { 81,0x01},
    { 82,0xE0},
    { 83,0x2D},
    { 84,0x1C},
    { 85,0x02},
    { 86,0x00},
    { 87,0x12},
    { 88,0x1C},
    { 89,0x02},
    { 90,0x00},
    { 91,0x2B},
    { 92,0x1C},
    { 93,0x02},
    { 94,0x20},
    { 95,0x18},
    { 96,0x1C},
    { 97,0x02},
    { 98,0x20},
    { 99,0x25},
    {100,0x1C},
    {101,0x02},
    {102,0x40},
    {103,0x14},
    {104,0x1C},
    {105,0x02},
    {106,0x40},
    {107,0x29},
    {108,0x1C},
    {109,0x02},
    {110,0x60},
    {111,0x16},
    {112,0x1C},
    {113,0x02},
    {114,0x60},
    {115,0x27},
    {116,0x1C},
    {117,0x02},
    {118,0x80},
    {119,0x1A},
    {120,0x1C},
    {121,0x02},
    {122,0x80},
    {123,0x23},
    {124,0x1C},
    {125,0x02},
    {126,0xA0},
    {127,0x1C},
    {  0,0x04},
    {  8,0x1C},
    {  9,0x02},
    { 10,0xA0},
    { 11,0x21},
    { 12,0x1C},
    { 13,0x02},
    { 14,0xC0},
    { 15,0x0D},
    { 16,0x1C},
    { 17,0x02},
    { 18,0xC0},
    { 19,0x30},
    { 20,0x1C},
    { 21,0x02},
    { 22,0xE0},
    { 23,0x15},
    { 24,0x1C},
    { 25,0x02},
    { 26,0xE0},
    { 27,0x28},
    { 28,0x1C},
    { 29,0x03},
    { 30,0x00},
    { 31,0x11},
    { 32,0x1C},
    { 33,0x03},
    { 34,0x00},
    { 35,0x2C},
    { 36,0x1C},
    { 37,0x03},
    { 38,0x20},
    { 39,0x19},
    { 40,0x1C},
    { 41,0x03},
    { 42,0x20},
    { 43,0x24},
    { 44,0x1C},
    { 45,0x03},
    { 46,0x40},
    { 47,0x13},
    { 48,0x1C},
    { 49,0x03},
    { 50,0x40},
    { 51,0x2A},
    { 52,0x1C},
    { 53,0x03},
    { 54,0x60},
    { 55,0x0F},
    { 56,0x1C},
    { 57,0x03},
    { 58,0x60},
    { 59,0x2E},
    { 60,0x1C},
    { 61,0x03},
    { 62,0x80},
    { 63,0x17},
    { 64,0x1C},
    { 65,0x03},
    { 66,0x80},
    { 67,0x26},
    { 68,0x1C},
    { 69,0x03},
    { 70,0xA0},
    { 71,0x1B},
    { 72,0x1C},
    { 73,0x03},
    { 74,0xA0},
    { 75,0x22},
    { 76,0x1C},
    { 77,0x03},
    { 78,0xC0},
    { 79,0x1D},
    { 80,0x1C},
    { 81,0x03},
    { 82,0xC0},
    { 83,0x20},
    { 84,0x1C},
    { 85,0x03},
    { 86,0xE0},
    { 87,0x1E},
    { 88,0x1C},
    { 89,0x03},
    { 90,0xE0},
    { 91,0x1F},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x00},
    { 97,0x00},
    { 98,0x00},
    { 99,0x00},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x10},
    {105,0x00},
    {106,0x00},
    {107,0x36},
    {108,0x18},
    {109,0x01},
    {110,0xA0},
    {111,0x71},
    {112,0x1C},
    {113,0x01},
    {114,0xC0},
    {115,0x4E},
    {116,0x1C},
    {117,0x01},
    {118,0xA0},
    {119,0x4C},
    {120,0x1C},
    {121,0x01},
    {122,0xC0},
    {123,0x6F},
    {124,0x1C},
    {125,0x01},
    {126,0xE0},
    {127,0x50},
    {  0,0x05},
    {  8,0x1C},
    {  9,0x01},
    { 10,0xE0},
    { 11,0x6D},
    { 12,0x1C},
    { 13,0x02},
    { 14,0x00},
    { 15,0x52},
    { 16,0x1C},
    { 17,0x02},
    { 18,0x00},
    { 19,0x6B},
    { 20,0x1C},
    { 21,0x02},
    { 22,0x20},
    { 23,0x58},
    { 24,0x1C},
    { 25,0x02},
    { 26,0x20},
    { 27,0x65},
    { 28,0x1C},
    { 29,0x02},
    { 30,0x40},
    { 31,0x54},
    { 32,0x1C},
    { 33,0x02},
    { 34,0x40},
    { 35,0x69},
    { 36,0x1C},
    { 37,0x02},
    { 38,0x60},
    { 39,0x56},
    { 40,0x1C},
    { 41,0x02},
    { 42,0x60},
    { 43,0x67},
    { 44,0x1C},
    { 45,0x02},
    { 46,0x80},
    { 47,0x5A},
    { 48,0x1C},
    { 49,0x02},
    { 50,0x80},
    { 51,0x63},
    { 52,0x1C},
    { 53,0x02},
    { 54,0xA0},
    { 55,0x5C},
    { 56,0x1C},
    { 57,0x02},
    { 58,0xA0},
    { 59,0x61},
    { 60,0x1C},
    { 61,0x02},
    { 62,0xC0},
    { 63,0x4D},
    { 64,0x1C},
    { 65,0x02},
    { 66,0xC0},
    { 67,0x70},
    { 68,0x1C},
    { 69,0x02},
    { 70,0xE0},
    { 71,0x55},
    { 72,0x1C},
    { 73,0x02},
    { 74,0xE0},
    { 75,0x68},
    { 76,0x1C},
    { 77,0x03},
    { 78,0x00},
    { 79,0x51},
    { 80,0x1C},
    { 81,0x03},
    { 82,0x00},
    { 83,0x6C},
    { 84,0x1C},
    { 85,0x03},
    { 86,0x20},
    { 87,0x59},
    { 88,0x1C},
    { 89,0x03},
    { 90,0x20},
    { 91,0x64},
    { 92,0x1C},
    { 93,0x03},
    { 94,0x40},
    { 95,0x53},
    { 96,0x1C},
    { 97,0x03},
    { 98,0x40},
    { 99,0x6A},
    {100,0x1C},
    {101,0x03},
    {102,0x60},
    {103,0x4F},
    {104,0x1C},
    {105,0x03},
    {106,0x60},
    {107,0x6E},
    {108,0x1C},
    {109,0x03},
    {110,0x80},
    {111,0x57},
    {112,0x1C},
    {113,0x03},
    {114,0x80},
    {115,0x66},
    {116,0x1C},
    {117,0x03},
    {118,0xA0},
    {119,0x5B},
    {120,0x1C},
    {121,0x03},
    {122,0xA0},
    {123,0x62},
    {124,0x1C},
    {125,0x03},
    {126,0xC0},
    {127,0x5D},
    {  0,0x06},
    {  8,0x1C},
    {  9,0x03},
    { 10,0xC0},
    { 11,0x60},
    { 12,0x1C},
    { 13,0x03},
    { 14,0xE0},
    { 15,0x5E},
    { 16,0x1C},
    { 17,0x03},
    { 18,0xE0},
    { 19,0x5F},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x10},
    { 33,0x00},
    { 34,0x00},
    { 35,0x76},
    { 36,0x18},
    { 37,0x04},
    { 38,0x20},
    { 39,0x75},
    { 40,0x1C},
    { 41,0x04},
    { 42,0x40},
    { 43,0x77},
    { 44,0x1C},
    { 45,0x04},
    { 46,0x40},
    { 47,0x74},
    { 48,0x1C},
    { 49,0x04},
    { 50,0x20},
    { 51,0x76},
    { 52,0x1C},
    { 53,0x04},
    { 54,0x60},
    { 55,0x73},
    { 56,0x1C},
    { 57,0x04},
    { 58,0x60},
    { 59,0x78},
    { 60,0x1C},
    { 61,0x04},
    { 62,0x80},
    { 63,0x72},
    { 64,0x1C},
    { 65,0x04},
    { 66,0x80},
    { 67,0x79},
    { 68,0x18},
    { 69,0x04},
    { 70,0xE0},
    { 71,0x7A},
    { 72,0x1C},
    { 73,0x04},
    { 74,0xE0},
    { 75,0x7C},
    { 76,0x1C},
    { 77,0x04},
    { 78,0xC0},
    { 79,0x7F},
    { 80,0x4C},
    { 81,0x04},
    { 82,0xC0},
    { 83,0x7D},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x5C},
    { 89,0x90},
    { 90,0x60},
    { 91,0x03},
    { 92,0x18},
    { 93,0x04},
    { 94,0x20},
    { 95,0x35},
    { 96,0x1C},
    { 97,0x04},
    { 98,0x20},
    { 99,0x36},
    {100,0x1C},
    {101,0x04},
    {102,0x40},
    {103,0x37},
    {104,0x10},
    {105,0x00},
    {106,0x40},
    {107,0x86},
    {108,0x1C},
    {109,0x04},
    {110,0x40},
    {111,0x34},
    {112,0x1C},
    {113,0x04},
    {114,0x60},
    {115,0x33},
    {116,0x1C},
    {117,0x04},
    {118,0x60},
    {119,0x38},
    {120,0x1C},
    {121,0x04},
    {122,0x80},
    {123,0x32},
    {124,0x1C},
    {125,0x04},
    {126,0x80},
    {127,0x39},
    {  0,0x07},
    {  8,0x18},
    {  9,0x04},
    { 10,0xE0},
    { 11,0x3A},
    { 12,0x1C},
    { 13,0x04},
    { 14,0xE0},
    { 15,0x3C},
    { 16,0x1C},
    { 17,0x04},
    { 18,0xC0},
    { 19,0x3F},
    { 20,0x4C},
    { 21,0x04},
    { 22,0xC0},
    { 23,0x3D},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x5C},
    { 29,0x90},
    { 30,0x40},
    { 31,0x03},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x00},
    { 37,0x00},
    { 38,0x00},
    { 39,0x00},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x10},
    { 45,0x00},
    { 46,0x40},
    { 47,0x46},
    { 48,0x18},
    { 49,0x05},
    { 50,0x00},
    { 51,0x7D},
    { 52,0x1C},
    { 53,0x05},
    { 54,0x00},
    { 55,0x7C},
    { 56,0x1C},
    { 57,0x05},
    { 58,0x20},
    { 59,0x7A},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x5C},
    { 65,0x90},
    { 66,0x60},
    { 67,0x03},
    { 68,0x18},
    { 69,0x05},
    { 70,0x00},
    { 71,0x3D},
    { 72,0x1C},
    { 73,0x05},
    { 74,0x00},
    { 75,0x3C},
    { 76,0x1C},
    { 77,0x05},
    { 78,0x20},
    { 79,0x3A},
    { 80,0x10},
    { 81,0x00},
    { 82,0x40},
    { 83,0x85},
    { 84,0x18},
    { 85,0x04},
    { 86,0xA0},
    { 87,0x73},
    { 88,0x5C},
    { 89,0x90},
    { 90,0x40},
    { 91,0x03},
    { 92,0x18},
    { 93,0x04},
    { 94,0xC0},
    { 95,0x7C},
    { 96,0x1C},
    { 97,0x04},
    { 98,0xE0},
    { 99,0x7D},
    {100,0x4C},
    {101,0x04},
    {102,0xC0},
    {103,0x7E},
    {104,0x10},
    {105,0x00},
    {106,0x40},
    {107,0x45},
    {108,0x1C},
    {109,0x04},
    {110,0xE0},
    {111,0x7A},
    {112,0x18},
    {113,0x04},
    {114,0xA0},
    {115,0x33},
    {116,0x5C},
    {117,0x90},
    {118,0x60},
    {119,0x03},
    {120,0x18},
    {121,0x04},
    {122,0xC0},
    {123,0x3C},
    {124,0x1C},
    {125,0x04},
    {126,0xE0},
    {127,0x3D},
    {  0,0x08},
    {  8,0x4C},
    {  9,0x04},
    { 10,0xC0},
    { 11,0x3E},
    { 12,0x10},
    { 13,0x00},
    { 14,0x40},
    { 15,0x84},
    { 16,0x1C},
    { 17,0x04},
    { 18,0xE0},
    { 19,0x3A},
    { 20,0x00},
    { 21,0x00},
    { 22,0x00},
    { 23,0x00},
    { 24,0x5C},
    { 25,0x90},
    { 26,0x40},
    { 27,0x03},
    { 28,0x18},
    { 29,0x05},
    { 30,0x00},
    { 31,0x7E},
    { 32,0x1C},
    { 33,0x05},
    { 34,0x00},
    { 35,0x7A},
    { 36,0x1C},
    { 37,0x05},
    { 38,0x20},
    { 39,0x7D},
    { 40,0x10},
    { 41,0x00},
    { 42,0x40},
    { 43,0x44},
    { 44,0x5C},
    { 45,0x90},
    { 46,0x60},
    { 47,0x03},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x00},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x10},
    { 61,0x00},
    { 62,0x40},
    { 63,0x83},
    { 64,0x18},
    { 65,0x05},
    { 66,0x00},
    { 67,0x3E},
    { 68,0x1C},
    { 69,0x05},
    { 70,0x00},
    { 71,0x3A},
    { 72,0x1C},
    { 73,0x05},
    { 74,0x20},
    { 75,0x3D},
    { 76,0x18},
    { 77,0x04},
    { 78,0x00},
    { 79,0x5E},
    { 80,0x5C},
    { 81,0x90},
    { 82,0x40},
    { 83,0x03},
    { 84,0x18},
    { 85,0x04},
    { 86,0x20},
    { 87,0x79},
    { 88,0x1C},
    { 89,0x04},
    { 90,0x40},
    { 91,0x72},
    { 92,0x4C},
    { 93,0x04},
    { 94,0x20},
    { 95,0x71},
    { 96,0x10},
    { 97,0x00},
    { 98,0x40},
    { 99,0x43},
    {100,0x1C},
    {101,0x04},
    {102,0x40},
    {103,0x78},
    {104,0x1C},
    {105,0x04},
    {106,0x60},
    {107,0x77},
    {108,0x1C},
    {109,0x04},
    {110,0x60},
    {111,0x73},
    {112,0x1C},
    {113,0x04},
    {114,0x80},
    {115,0x76},
    {116,0x1C},
    {117,0x04},
    {118,0x80},
    {119,0x74},
    {120,0x18},
    {121,0x04},
    {122,0xE0},
    {123,0x7E},
    {124,0x1C},
    {125,0x04},
    {126,0xE0},
    {127,0x7D},
    {  0,0x09},
    {  8,0x1C},
    {  9,0x04},
    { 10,0xC0},
    { 11,0x7A},
    { 12,0x4C},
    { 13,0x04},
    { 14,0xC0},
    { 15,0x7B},
    { 16,0x18},
    { 17,0x04},
    { 18,0x00},
    { 19,0x1E},
    { 20,0x5C},
    { 21,0x90},
    { 22,0x60},
    { 23,0x03},
    { 24,0x18},
    { 25,0x04},
    { 26,0x20},
    { 27,0x39},
    { 28,0x1C},
    { 29,0x04},
    { 30,0x40},
    { 31,0x32},
    { 32,0x4C},
    { 33,0x04},
    { 34,0x20},
    { 35,0x31},
    { 36,0x10},
    { 37,0x00},
    { 38,0x40},
    { 39,0x82},
    { 40,0x1C},
    { 41,0x04},
    { 42,0x40},
    { 43,0x38},
    { 44,0x1C},
    { 45,0x04},
    { 46,0x60},
    { 47,0x37},
    { 48,0x1C},
    { 49,0x04},
    { 50,0x60},
    { 51,0x33},
    { 52,0x1C},
    { 53,0x04},
    { 54,0x80},
    { 55,0x36},
    { 56,0x1C},
    { 57,0x04},
    { 58,0x80},
    { 59,0x34},
    { 60,0x18},
    { 61,0x04},
    { 62,0xE0},
    { 63,0x3E},
    { 64,0x1C},
    { 65,0x04},
    { 66,0xE0},
    { 67,0x3D},
    { 68,0x1C},
    { 69,0x04},
    { 70,0xC0},
    { 71,0x3A},
    { 72,0x4C},
    { 73,0x04},
    { 74,0xC0},
    { 75,0x3B},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x5C},
    { 81,0x90},
    { 82,0x40},
    { 83,0x03},
    { 84,0x00},
    { 85,0x00},
    { 86,0x00},
    { 87,0x00},
    { 88,0x00},
    { 89,0x00},
    { 90,0x00},
    { 91,0x00},
    { 92,0x00},
    { 93,0x00},
    { 94,0x00},
    { 95,0x00},
    { 96,0x10},
    { 97,0x00},
    { 98,0x40},
    { 99,0x41},
    {100,0x18},
    {101,0x05},
    {102,0x00},
    {103,0x7B},
    {104,0x1C},
    {105,0x05},
    {106,0x00},
    {107,0x7D},
    {108,0x1C},
    {109,0x05},
    {110,0x20},
    {111,0x7E},
    {112,0x10},
    {113,0x00},
    {114,0x40},
    {115,0x42},
    {116,0x00},
    {117,0x00},
    {118,0x00},
    {119,0x00},
    {120,0x5C},
    {121,0x90},
    {122,0x60},
    {123,0x03},
    {124,0x18},
    {125,0x05},
    {126,0x00},
    {127,0x3B},
    {  0,0x0A},
    {  8,0x1C},
    {  9,0x05},
    { 10,0x00},
    { 11,0x3D},
    { 12,0x1C},
    { 13,0x05},
    { 14,0x20},
    { 15,0x3E},
    { 16,0x10},
    { 17,0x00},
    { 18,0x40},
    { 19,0x81},
    { 20,0x18},
    { 21,0x04},
    { 22,0xA0},
    { 23,0x77},
    { 24,0x5C},
    { 25,0x90},
    { 26,0x40},
    { 27,0x03},
    { 28,0x18},
    { 29,0x04},
    { 30,0xC0},
    { 31,0x7D},
    { 32,0x1C},
    { 33,0x04},
    { 34,0xE0},
    { 35,0x7B},
    { 36,0x4C},
    { 37,0x04},
    { 38,0xC0},
    { 39,0x79},
    { 40,0x10},
    { 41,0x00},
    { 42,0x40},
    { 43,0x41},
    { 44,0x1C},
    { 45,0x04},
    { 46,0xE0},
    { 47,0x7E},
    { 48,0x18},
    { 49,0x04},
    { 50,0xA0},
    { 51,0x37},
    { 52,0x5C},
    { 53,0x90},
    { 54,0x60},
    { 55,0x03},
    { 56,0x18},
    { 57,0x04},
    { 58,0xC0},
    { 59,0x3D},
    { 60,0x1C},
    { 61,0x04},
    { 62,0xE0},
    { 63,0x3B},
    { 64,0x4C},
    { 65,0x04},
    { 66,0xC0},
    { 67,0x39},
    { 68,0x10},
    { 69,0x00},
    { 70,0x40},
    { 71,0x80},
    { 72,0x1C},
    { 73,0x04},
    { 74,0xE0},
    { 75,0x3E},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
    { 80,0x5C},
    { 81,0x90},
    { 82,0x40},
    { 83,0x03},
    { 84,0x18},
    { 85,0x05},
    { 86,0x00},
    { 87,0x79},
    { 88,0x1C},
    { 89,0x05},
    { 90,0x00},
    { 91,0x7E},
    { 92,0x1C},
    { 93,0x05},
    { 94,0x20},
    { 95,0x7B},
    { 96,0x10},
    { 97,0x00},
    { 98,0x40},
    { 99,0x40},
    {100,0x00},
    {101,0x00},
    {102,0x00},
    {103,0x00},
    {104,0x5C},
    {105,0x90},
    {106,0x60},
    {107,0x03},
    {108,0x18},
    {109,0x05},
    {110,0x00},
    {111,0x39},
    {112,0x1C},
    {113,0x05},
    {114,0x00},
    {115,0x3E},
    {116,0x1C},
    {117,0x05},
    {118,0x20},
    {119,0x3B},
    {120,0x10},
    {121,0x00},
    {122,0x40},
    {123,0x7F},
    {124,0x5C},
    {125,0x90},
    {126,0x40},
    {127,0x03},
    {  0,0x0B},
    {  8,0x00},
    {  9,0x00},
    { 10,0x00},
    { 11,0x00},
    { 12,0x00},
    { 13,0x00},
    { 14,0x00},
    { 15,0x00},
    { 16,0x00},
    { 17,0x00},
    { 18,0x00},
    { 19,0x00},
    { 20,0x10},
    { 21,0x00},
    { 22,0x40},
    { 23,0x3F},
    { 24,0x00},
    { 25,0x00},
    { 26,0x00},
    { 27,0x00},
    { 28,0x00},
    { 29,0x00},
    { 30,0x00},
    { 31,0x00},
    { 32,0x00},
    { 33,0x00},
    { 34,0x00},
    { 35,0x00},
    { 36,0x01},
    { 37,0x03},
    { 38,0x40},
    { 39,0xD8},
    { 40,0x00},
    { 41,0x00},
    { 42,0x00},
    { 43,0x00},
    { 44,0x00},
    { 45,0x00},
    { 46,0x00},
    { 47,0x00},
    { 48,0x00},
    { 49,0x00},
    { 50,0x00},
    { 51,0x00},
    { 52,0x00},
    { 53,0x00},
    { 54,0x00},
    { 55,0x00},
    { 56,0x05},
    { 57,0x00},
    { 58,0x00},
    { 59,0x00},
    { 60,0x00},
    { 61,0x00},
    { 62,0x00},
    { 63,0x00},
    { 64,0x00},
    { 65,0x00},
    { 66,0x00},
    { 67,0x00},
    { 68,0x00},
    { 69,0x00},
    { 70,0x00},
    { 71,0x00},
    { 72,0x02},
    { 73,0x00},
    { 74,0x00},
    { 75,0x00},
    { 76,0x00},
    { 77,0x00},
    { 78,0x00},
    { 79,0x00},
};
#define miniDSP_D_reg_values_COEFF_START   0
#define miniDSP_D_reg_values_COEFF_SIZE    353
#define miniDSP_D_reg_values_INST_START    353
#define miniDSP_D_reg_values_INST_SIZE     1285
