typedef unsigned char cfg_u8;
typedef union {
    struct {
        cfg_u8 offset;
        cfg_u8 value;
    };
    struct {
        cfg_u8 command;
        cfg_u8 param;
    };
} cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

/* Example C code */
/*
    // Externally implemented function that can write n-bytes to the device
    // PCM51xx and TAS5766 targets require the high bit (0x80) of the I2C register to be set on multiple writes.
    // Refer to the device data sheet for more information.
    extern int i2c_write(unsigned char *data, int n);
    // Externally implemented function that delays execution by n milliseconds
    extern int delay(int n);
    // Example implementation.  Call like:
    //     transmit_registers(registers, sizeof(registers)/sizeof(registers[0]));
    void transmit_registers(cfg_reg *r, int n)
    {
        int i = 0;
        while (i < n) {
            switch (r[i].command) {
            case CFG_META_SWITCH:
                // Used in legacy applications.  Ignored here.
                break;
            case CFG_META_DELAY:
                delay(r[i].param);
                break;
            case CFG_META_BURST:
                i2c_write((unsigned char *)&r[i+1], r[i].param);
                i +=  (r[i].param / 2) + 1;
                break;
            default:
                i2c_write((unsigned char *)&r[i], 1);
                break;
            }
            i++;
        }
    }
*/

cfg_reg registers[] = {
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x00, 0x05 },
    { CFG_META_BURST, 4 },
    { 0x54, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x08, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x1c, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x58, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x06 },
    { CFG_META_BURST, 20 },
    { 0x3c, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x50, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 8 },
    { 0x78, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x08 },
    { CFG_META_BURST, 12 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x14, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x28, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x3c, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x50, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 4 },
    { 0x0c, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x08 },
    { CFG_META_BURST, 28 },
    { 0x64, 0x80 },
    { 0x89, 0xee },
    { 0x10, 0x7f },
    { 0x72, 0x82 },
    { 0xd7, 0x81 },
    { 0x0c, 0xbd },
    { 0xed, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x83 },
    { 0x34, 0x5e },
    { 0x0e, 0x7c },
    { 0xc2, 0xba },
    { 0xfd, 0x00 },
    { 0x00, 0x09 },
    { CFG_META_BURST, 12 },
    { 0x08, 0x86 },
    { 0x56, 0xee },
    { 0x31, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x00 },
    { 0x00, 0x0a },
    { CFG_META_BURST, 80 },
    { 0x30, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0xaf },
    { 0xc3, 0x88 },
    { 0xbd, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0xaf },
    { 0xc3, 0x88 },
    { 0xbd, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x6e },
    { 0x61, 0x70 },
    { 0x95, 0x89 },
    { 0x76, 0x6e },
    { 0x96, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x00 },
    { 0x00, 0x0b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x89 },
    { 0x22, 0xdb },
    { 0x26, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x89 },
    { 0x22, 0xdb },
    { 0x26, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x00 },
    { 0x00, 0x0c },
    { CFG_META_BURST, 96 },
    { 0x08, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0xb5, 0x04 },
    { 0xf3, 0x01 },
    { 0x6a, 0x09 },
    { 0xe6, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x16, 0xc1 },
    { 0x6c, 0x00 },
    { 0x06, 0xd3 },
    { 0xa0, 0x00 },
    { 0x36, 0x9d },
    { 0x03, 0x00 },
    { 0xc0, 0xe8 },
    { 0x57, 0x02 },
    { 0x42, 0xb9 },
    { 0x05, 0x02 },
    { 0xa3, 0x2d },
    { 0x31, 0x03 },
    { 0xc4, 0x89 },
    { 0xb4, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x7f },
    { 0xf9, 0x2c },
    { 0x60, 0x7f },
    { 0xf9, 0x2c },
    { 0x60, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x42 },
    { 0x2d, 0x38 },
    { 0x00, 0x42 },
    { 0x2d, 0x38 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 8 },
    { 0x78, 0x2f },
    { 0x16, 0xac },
    { 0x6c, 0x2f },
    { 0x16, 0xac },
    { 0x6c, 0x00 },
    { 0x00, 0x0d },
    { CFG_META_BURST, 8 },
    { 0x0c, 0x02 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 8 },
    { 0x18, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 92 },
    { 0x24, 0x40 },
    { 0x00, 0x57 },
    { 0x62, 0x40 },
    { 0x00, 0x57 },
    { 0x62, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x16, 0xc1 },
    { 0x6c, 0x00 },
    { 0xfb, 0x4f },
    { 0xf8, 0x0a },
    { 0xbc, 0x26 },
    { 0x7b, 0xf8 },
    { 0xaa, 0xa7 },
    { 0x4f, 0x05 },
    { 0x9e, 0x80 },
    { 0xdd, 0x7b },
    { 0xa9, 0x65 },
    { 0x70, 0x86 },
    { 0xfd, 0x3f },
    { 0x2b, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x5a },
    { 0x9d, 0xf7 },
    { 0xac, 0x40 },
    { 0x26, 0xe7 },
    { 0x3d, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x13 },
    { 0xa6, 0x7c },
    { 0xa1, 0x02 },
    { 0xae, 0xb7 },
    { 0x0b, 0x00 },
    { 0x00, 0x0e },
    { CFG_META_BURST, 120 },
    { 0x08, 0x7f },
    { 0xfe, 0xfd },
    { 0x47, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xfe },
    { 0xfe, 0xa4 },
    { 0xb4, 0x00 },
    { 0x00, 0x03 },
    { 0x20, 0x10 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x7d },
    { 0x51, 0x48 },
    { 0xf5, 0x12 },
    { 0x49, 0x24 },
    { 0x92, 0x00 },
    { 0x10, 0x9d },
    { 0x7f, 0xf9 },
    { 0xa9, 0x83 },
    { 0x86, 0x00 },
    { 0x00, 0x0f },
    { CFG_META_BURST, 120 },
    { 0x08, 0x05 },
    { 0x05, 0x61 },
    { 0xb2, 0x02 },
    { 0xfa, 0x9e },
    { 0x4e, 0x06 },
    { 0x82, 0xb0 },
    { 0xd9, 0x00 },
    { 0xaa, 0xbb },
    { 0x48, 0x00 },
    { 0x00, 0x38 },
    { 0x45, 0x00 },
    { 0x04, 0xc5 },
    { 0xe7, 0x00 },
    { 0x06, 0xf6 },
    { 0xf7, 0x03 },
    { 0xcf, 0xc1 },
    { 0x81, 0x03 },
    { 0x51, 0x7b },
    { 0x36, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x35 },
    { 0xa2, 0x68 },
    { 0x0a, 0x00 },
    { 0x1c, 0xee },
    { 0xa1, 0x00 },
    { 0x0a, 0x5c },
    { 0xb6, 0x13 },
    { 0x17, 0x9c },
    { 0x05, 0x4b },
    { 0xc1, 0xf0 },
    { 0x7c, 0x2b },
    { 0x03, 0xc9 },
    { 0x33, 0x00 },
    { 0x19, 0xbb },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xff },
    { 0xe6, 0x44 },
    { 0xff, 0x7f },
    { 0xf8, 0x8e },
    { 0x94, 0x80 },
    { 0x0c, 0xdd },
    { 0x80, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x17 },
    { 0x4d, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x00 },
    { 0x0d, 0xa6 },
    { 0x86, 0x01 },
    { 0x6f, 0xa9 },
    { 0xbb, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0x00 },
    { 0x00, 0x10 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x05, 0x75 },
    { 0xfc, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x2e },
    { 0xe0, 0x00 },
    { 0x00, 0x02 },
    { 0x49, 0xfe },
    { 0xde, 0x23 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x3e, 0x81 },
    { 0x96, 0x00 },
    { 0x09, 0x4a },
    { 0x0f, 0x7f },
    { 0xf6, 0xb5 },
    { 0xf1, 0x00 },
    { 0x02, 0x11 },
    { 0x49, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x7d },
    { 0xe2, 0x64 },
    { 0x81, 0x07 },
    { 0x2c, 0x22 },
    { 0xeb, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x44 },
    { 0xe1, 0xdd },
    { 0x40, 0x48 },
    { 0x48, 0x7c },
    { 0xc1, 0x1d },
    { 0x74, 0xd2 },
    { 0x38, 0xc4 },
    { 0xa2, 0xd8 },
    { 0xae, 0x08 },
    { 0x8d, 0x85 },
    { 0xc9, 0x01 },
    { 0x4c, 0xf6 },
    { 0x3a, 0xff },
    { 0x40, 0xaf },
    { 0x3c, 0x01 },
    { 0x4c, 0xf6 },
    { 0x3a, 0x68 },
    { 0x36, 0x21 },
    { 0xbc, 0xaa },
    { 0x5b, 0x9d },
    { 0xf3, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x8b },
    { 0x57, 0x50 },
    { 0x3c, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x75 },
    { 0x83, 0x0e },
    { 0x39, 0x90 },
    { 0x2a, 0xba },
    { 0xff, 0x00 },
    { 0x00, 0x11 },
    { CFG_META_BURST, 88 },
    { 0x08, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x46 },
    { 0xdc, 0x08 },
    { 0xc2, 0xf1 },
    { 0x47, 0xf9 },
    { 0x49, 0x72 },
    { 0xed, 0x05 },
    { 0x41, 0x60 },
    { 0xdc, 0x01 },
    { 0xf0, 0x89 },
    { 0xa8, 0x01 },
    { 0xfa, 0x91 },
    { 0x9b, 0x00 },
    { 0x00, 0x53 },
    { 0xe3, 0x00 },
    { 0x03, 0x46 },
    { 0xdc, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x39 },
    { 0x7f, 0x06 },
    { 0xfd, 0xc8 },
    { 0xf4, 0x06 },
    { 0x39, 0x0a },
    { 0x9d, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0x01 },
    { 0x0f, 0xee },
    { 0x9a, 0x00 },
    { 0x1c, 0xee },
    { 0xa1, 0x00 },
    { 0x2b, 0xa9 },
    { 0x5c, 0x7f },
    { 0xd4, 0x56 },
    { 0xa4, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x39 },
    { 0x7f, 0x01 },
    { 0xca, 0x7f },
    { 0x3d, 0x00 },
    { 0x00, 0x13 },
    { CFG_META_BURST, 4 },
    { 0x5c, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x60, 0x20 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x68, 0xe0 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 16 },
    { 0x70, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x14 },
    { CFG_META_BURST, 40 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa9, 0xfb },
    { 0xd6, 0xcb },
    { 0x11, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 16 },
    { 0x70, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x15 },
    { CFG_META_BURST, 40 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa9, 0xfb },
    { 0xd6, 0xcb },
    { 0x11, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x13 },
    { CFG_META_BURST, 4 },
    { 0x6c, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x00, 0x14 },
    { CFG_META_BURST, 4 },
    { 0x6c, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x00, 0x12 },
    { CFG_META_BURST, 20 },
    { 0x34, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x00 },
    { 0x00, 0x13 },
    { CFG_META_BURST, 20 },
    { 0x34, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x81 },
    { 0xa8, 0xc3 },
    { 0x78, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 4 },
    { 0x10, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x11 },
    { CFG_META_BURST, 20 },
    { 0x60, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 12 },
    { 0x74, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x12 },
    { CFG_META_BURST, 8 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x10, 0x01 },
    { 0x01, 0x37 },
    { 0x98, 0x00 },
    { CFG_META_BURST, 8 },
    { 0x14, 0x7f },
    { 0xff, 0x51 },
    { 0x3d, 0x41 },
    { 0x18, 0x23 },
    { 0xc9, 0x00 },
    { CFG_META_BURST, 20 },
    { 0x1c, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd3, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xba, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x30, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 4 },
    { 0x0c, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x10, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
};
