#ifndef _TAS5825M_CONFIG_H_
#define _TAS5825M_CONFIG_H_

typedef unsigned char cfg_u8;

typedef struct {
    cfg_u8 offset;   /* command */
    cfg_u8 value;    /* param   */
}cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

static cfg_reg tas5825m_init_sequence1[] = 
{
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x03, 0x02 },
    { 0x01, 0x11 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },

    { 0x7f, 0x00 },
    { 0x7d, 0x11 },
    { 0x7e, 0xff },
    { 0x00, 0x01 },
    { 0x51, 0x05 },
    { 0x00, 0x02 },
    { 0x19, 0xa0 },
    { 0x1d, 0x01 },
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x46, 0x01 },
    { 0x00, 0x00 },
    { 0x02, 0x02 },
    { 0x53, 0x00 },
    { 0x54, 0x00 },
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x03, 0x02 },
};

static cfg_reg tas5825m_init_sequence2[] = 
{		
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x7f, 0x8c },
    { 0x00, 0x06 },
    { 0x38, 0x00 },
    { 0x39, 0x00 },
    { 0x3a, 0x04 },
    { 0x3b, 0x00 },
//Tuning coeffs
    { 0x00, 0x0b },
    { 0x50, 0x00 },
    { 0x51, 0x20 },
    { 0x52, 0xc4 },
    { 0x53, 0x9c },
    { 0x5c, 0x7f },
    { 0x5d, 0xff },
    { 0x5e, 0xff },
    { 0x5f, 0xff },
// Book 0x8c
    { 0x00, 0x00 },
    { 0x7f, 0x8c },

    { 0x00, 0x01 },
    { 0x28, 0x40 },
    { 0x29, 0x00 },
    { 0x2a, 0x00 },
    { 0x2b, 0x00 },

    { 0x00, 0x0a },
    { 0x64, 0x00 },
    { 0x65, 0x80 },
    { 0x66, 0x00 },
    { 0x67, 0x00 },
    { 0x68, 0x00 },
    { 0x69, 0x00 },
    { 0x6a, 0x00 },
    { 0x6b, 0x00 },
    { 0x6c, 0x00 },
    { 0x6d, 0x00 },
    { 0x6e, 0x00 },
    { 0x6f, 0x00 },
    { 0x70, 0x00 },
    { 0x71, 0x80 },
    { 0x72, 0x00 },
    { 0x73, 0x00 },
    { 0x74, 0x00 },
    { 0x75, 0x80 },
    { 0x76, 0x00 },
    { 0x77, 0x00 },
    { 0x78, 0x00 },
    { 0x79, 0x00 },
    { 0x7a, 0x00 },
    { 0x7b, 0x00 },
    { 0x7c, 0x00 },
    { 0x7d, 0x00 },
    { 0x7e, 0x00 },
    { 0x7f, 0x00 },

    { 0x00, 0x0b },
    { 0x08, 0x00 },
    { 0x09, 0x80 },
    { 0x0a, 0x00 },
    { 0x0b, 0x00 },

    { 0x38, 0x02 },
    { 0x39, 0xa3 },
    { 0x3a, 0x9a },
    { 0x3b, 0xcc },
    { 0x3c, 0x00 },
    { 0x3d, 0x06 },
    { 0x3e, 0xd3 },
    { 0x3f, 0x72 },

    { 0x48, 0x04 },
    { 0x49, 0xc1 },
    { 0x4a, 0xff },
    { 0x4b, 0x93 },
    { 0x4c, 0x01 },
    { 0x4d, 0x12 },
    { 0x4e, 0x6e },
    { 0x4f, 0x98 },

    { 0x54, 0x7b },
    { 0x55, 0x3e },
    { 0x56, 0x00 },
    { 0x57, 0x6d },
    { 0x58, 0x00 },
    { 0x59, 0x00 },
    { 0x5a, 0xae },
    { 0x5b, 0xc3 },

    { 0x60, 0x08 },
    { 0x61, 0x13 },
    { 0x62, 0x85 },
    { 0x63, 0x62 },
    { 0x64, 0x00 },
    { 0x65, 0x80 },
    { 0x66, 0x00 },
    { 0x67, 0x00 },

    { 0x6c, 0x00 },
    { 0x6d, 0x78 },
    { 0x6e, 0xd6 },
    { 0x6f, 0xfd },
    { 0x70, 0x00 },
    { 0x71, 0x08 },
    { 0x72, 0x13 },
    { 0x73, 0x85 },

//Register Tuning
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x30, 0x00 },
    { 0x60, 0x02 },
    { 0x62, 0x09 },
    { 0x4c, 0x30 },
    { 0x03, 0x03 },
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x78, 0x80 },
};

#endif