/*
 * picopass.h
 * {PicoPass header file}
 *
 * Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Created on: Sep 12, 2014
 *      Author: a0867749
 */

#ifndef PICOPASS_H_
#define PICOPASS_H_
//================================================================

#include <msp430.h>                         // Processor specific header
#include "mcu.h"
#include "trf7970.h"
#include "types.h"
#include "uart.h"

//===============================================================
// if disabled file picopass.c may be excluded from build
//#define    ENABLEPICOPASS                            // delete to disable standard
//===============================================================
/*
Command Opcodes explanation:
|-------------------------------------------------------|
|  7   |  6   |  5   |  4   |  3   |  2   |  1   |  0   |
---------------------------------------------------------
|  P   |  M1  |  M0  |  K   |        Instruction        |
---------------------------------------------------------

Upper nibble of any command consists of:
B7 == Parity == the XOR of bits B0::B6
B6 == M1     == see table on bottom of page 26 of the PicoPass data sheet, here we are using ISO15693 air interface and FSK double sub-carrier example, so M1 will be set to 0
B5 == M0     == M0 will be set to 1, see note on M1 above
B4 == K      == 0 (for all commands except READCHECK)
B3:B0        == Lower nibble of any command is the instruction to be executed. For example, see comments below for complete list.
READ == C, READ4 == 6, etc. (this is also in a table on page 26 of PicoPass 32k(S) datasheet
*/
//===============================================================

void PicoPass_ACS(void);						//Combo String [0xAA(ACTALL) then 0xAC(identify) then 0x21(select)] this combo command must be sent before other commands attempted
void PicoPass_ACTALL(void);						//0xAA (STEP 1 of ACS)
void PicoPass_IDENTIFY(void);					//0xAC (STEP 2 of ACS)
void PicoPass_SELECT(void);						//0x21 (STEP 3 of ACS)
void PicoPass_DETECT(void);						//0xAF, for EAS mode, if card has EAS bit set to 0, it will respond with its serial number (SN) + CRC
void PicoPass_READ(void);						//0xAC + Block Address + CRC (of block address)
void PicoPass_READ4(void);						//0xA6 + Starting Block Address + CRC (of block address)
void PicoPass_ACT(void);						//0x2E shifts ASNB by three each time, can be issued after ACTALL command
void PicoPass_HALT(void);						//0xA0 (once halted, card must be removed from field or the select command used, with tag SN)

//(CODESHELLS with parity correct on command in picopass.c file on the following functions)
//void PicoPass_UPDATE(void);					//0x27, for writing single block (unsecured)
//void PicoPass_PAGESEL(void);					//0x24, for changing book or page being read from
//void PicoPass_READCHECK(void);				//0x28 or 0xB8, AUTH command, first step in authentication procedure, returns contents of address specified
//void PicoPass_CHECK(void);					//0xA5, finishes AUTH command, mutual authentication portion of the procedure
//void PicoPass_UPDATE_SECURED(void);			//0x27, issued after READCHECK, CHECK commands issued and successful
//===============================================================

#endif /* PICOPASS_H_ */
