/*
 * max5395.c
 *
 *  Created on: Nov 1, 2019
 *      Author: jwright
 */

#include "max5395.h"

#include <rf430frl152h.h>
#include <stdint.h>
#include <stdbool.h>

//#pragma CODE_SECTION (max5395_read, ".fram_driver_code")
void max5395_read(uint8_t command, uint8_t * rxData)
{
    UCB0CTL1 |= UCSWRST;                // Software reset enabled
    UCB0I2CSA  = MAX5395_I2C_ADDR;      // I2C slave address
    UCB0CTLW1 = UCASTP_1;
    UCB0TBCNT = 0x0001;
    UCB0IE = UCTXIE0 | UCRXIE0;

    UCB0CTL1  &= ~UCSWRST;          // put eUSCI out of reset mode

    UCB0CTL1 |= UCTXSTT + UCTR;     // start i2c write operation
    while(!(UCB0IFG & UCTXIFG0));   // wait until transmit is needed
    UCB0TXBUF = command;                // send the command
    while(!(UCB0IFG & UCBCNTIFG));  // wait until the stop counter

    UCB0CTL1 &= ~UCTR;              // read operation
    UCB0CTL1 |= UCTXSTT;            // repeated start
    UCB0CTLW0 |= UCTXSTP;           // send stop after next byte
    while(!(UCB0IFG & UCRXIFG0));   // wait until read data available
    *rxData = UCB0RXBUF;          // read the MSB
    while (!(UCB0IFG & UCSTPIFG));      // Ensure stop condition got sent

    UCB0CTL1  |= UCSWRST;           // put I2C in reset mode

    return;
}

//#pragma CODE_SECTION (max5395_write, ".fram_driver_code")
void max5395_write(uint8_t command, uint8_t txData)
{
    UCB0CTL1 |= UCSWRST;                // Software reset enabled
    UCB0I2CSA  = MAX5395_I2C_ADDR;                // I2C slave address
    UCB0CTLW1 = UCASTP_1;
    UCB0TBCNT = 0x0002;
    UCB0IE = UCTXIE0 | UCRXIE0;

    UCB0CTL1  &= ~UCSWRST;           // put eUSCI out of reset

    UCB0CTL1 |= UCTXSTT + UCTR;     // start i2c write operation
    while(!(UCB0IFG & UCTXIFG0));   // send the I2C address
    UCB0TXBUF = command;                // send the command
    while(!(UCB0IFG & UCTXIFG0));    // wait until the command is sent out
    UCB0TXBUF = txData;           // send the LSB
    while(!(UCB0IFG & UCBCNTIFG));  // wait until it has been transmitted
    UCB0CTL1 |= UCTXSTP;             // send the stop condition
    while(!(UCB0IFG & UCSTPIFG));   // wait until it has been received

    UCB0CTL1  |= UCSWRST;            // put the eUSCI into reset mode

    return;
}
