/*
 * max5395.h
 *
 *  Created on: Nov 1, 2019
 *      Author: jwright
 */

#ifndef MAX5395_H_
#define MAX5395_H_

#include <stdint.h>

#define MAX5395_I2C_ADDR            0x28 // with ADDR=GND

#define MAX5395_CMD_READ_WIPER      0x00
#define MAX5395_CMD_READ_CONFIG     0x80

#define MAX5395_CMD_WRITE_WIPER     0x00
#define MAX5395_CMD_WRITE_SD_CLR    0x80
#define MAX5395_CMD_WRITE_SD_H_WREF 0x90
#define MAX5395_CMD_WRITE_SD_H_ZERO 0x91
#define MAX5395_CMD_WRITE_SD_H_MID  0x92
#define MAX5395_CMD_WRITE_SD_H_FULL 0x93
#define MAX5395_CMD_WRITE_SD_L_WREG 0x88
#define MAX5395_CMD_WRITE_SD_L_ZERO 0x89
#define MAX5395_CMD_WRITE_SD_L_MID  0x8A
#define MAX5395_CMD_WRITE_SD_L_FULL 0x8B
#define MAX5395_CMD_WRITE_SD_W      0x84
#define MAX5395_CMD_WRITE_QP_OFF    0xA0
#define MAX5395_CMD_WRITE_QP_ON     0xA1
#define MAX5395_CMD_WRITE_RST       0xC0

void max5395_read(uint8_t command, uint8_t * rxData);
void max5395_write(uint8_t command, uint8_t txData);

#endif /* MAX5395_H_ */
