/*
 * main.h
 *
 *  Created on: 26 avr. 2017
 *      Author: DTPI
 */

#ifndef MAIN_H_
#define MAIN_H_


#include "msp430.h"

#define CPU_CLK 8000000
//enable UART communication; this can be used to send data to a virtual COM Port using the UART backchannel function of the MSP-FET.
//#define UART_ENABLE

//enable SPI communication;
#define SPI_ENABLE

//******************************************************************************
// Port  pins
//******************************************************************************
#define LED_GREEN_BIT                    BIT0       //P1.0
#define LED_PDIR                         P1DIR      //
#define LED_POUT                         P1OUT      //

#define ADS_CS_N_BIT                     BIT2       // P1.2
#define ADS_CS_N_PDIR                    P1DIR      // P1.2
#define ADS_CS_N_POUT                    P1OUT      // P1.2

#define ADS_CLK_BIT                      BIT3       // P3.3
#define ADS_CLK_PSEL0                    P3SEL0     // P3.3
#define ADS_CLK_PSEL1                    P3SEL1     // P3.3

#define ADS_DOUT_BIT                     BIT2       // P3.2 - SOMI
#define ADS_DOUT_PSEL0                   P3SEL0     // P3.2 - SOMI
#define ADS_DOUT_PSEL1                   P3SEL1     // P3.2 - SOMI

#define ADS_DIN_BIT                      BIT1       // P3.1 - SIMO
#define ADS_DIN_PSEL0                    P3SEL0     // P3.1 - SIMO
#define ADS_DIN_PSEL1                    P3SEL1     // P3.1 - SIMO

#define ADS_DRDY_N_BIT                   BIT2       // P2.2
#define ADS_DRDY_N_PDIR                  P2DIR      // P2.2
#define ADS_DRDY_N_PIFG                  P2IFG      // P2.2

/*#define USCIA0_RX_BIT                    BIT1       // P2.1 - RX
#define USCIA0_RX_PSEL0                  P2SEL0     // P2.1 - RX
#define USCIA0_RX_PSEL1                  P2SEL1     // P2.1 - RX

#define USCIA0_TX_BIT                    BIT0       // P2.0 - TX
#define USCIA0_TX_PSEL0                  P2SEL0     // P2.0 - TX
#define USCIA0_TX_PSEL1                  P2SEL1     // P2.0 - TX*/

#ifdef SPI_ENABLE
#define UNUSED_P1_BITS                   (BIT1 + BIT4 + BIT5)
#else
#define UNUSED_P1_BITS                   (BIT0 + BIT2 + BIT3 + BIT4 + BIT5 + BIT6 + BIT7)
#endif
#define UNUSED_P2_BITS                   (BIT0 + BIT1 + BIT3 + BIT4)
#define UNUSED_P3_BITS                   (BIT0 + BIT4 + BIT5 + BIT6 + BIT7)
#define UNUSED_PJ_BITS                   (BIT0 + BIT1 + BIT2 + BIT3 + BIT4 + BIT5)



#endif /* MAIN_H_ */
