
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
// Modified:   RMP added capture modes register, bit/byte mode for DDR capture
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module ads5463_toplevel(
			DDRClk_p_pin,
			DDRClk_n_pin,
			SysClk_p_pin,
			SysClk_n_pin,
			SysRst_pin,
			Chan_En_pin,
//
			AppUART_Sin_pin,
			AppUART_RTSn_pin,
			AppUART_DTRn_pin,
			AppUART_Sout_pin,
			AppUART_CTSn_pin,
			AppUART_DSRn_pin,
			AppUART_DCDn_pin,
			AppUART_RIn_pin,

			AppSPI_Ss_pin,
			AppSPI_Mosi_pin,
			AppSPI_Sclk_pin,
			CLKOUT_pin,

			D0_n_pin,
			D0_p_pin,
			D1_n_pin,
			D1_p_pin,
			D2_n_pin,
			D2_p_pin,
			D3_n_pin,
			D3_p_pin,
			D4_n_pin,
			D4_p_pin,
			D5_n_pin,
			D5_p_pin,
			D6_n_pin,
			D6_p_pin,
			D7_n_pin,
			D7_p_pin,
			D8_n_pin,
			D8_p_pin,
			D9_n_pin,
			D9_p_pin,
			D10_n_pin,
			D10_p_pin,
			D11_n_pin,
			D11_p_pin,
			D12_n_pin,
			D12_p_pin,
			D13_n_pin,
			D13_p_pin,
			D14_n_pin,
			D14_p_pin,

			AppDatClkCh1_pin,
			AppDatClkCh2_pin,
			AppDatClkCh3_pin,
			AppDatClkCh4_pin,
//			AppDatClkCh5_pin,
//			AppDatClkCh6_pin,
//			AppDatClkCh7_pin,
//			AppDatClkCh8_pin,
 			AppTP0_pin,
 			AppTP1_pin,
 			AppTP2_pin,
 			AppTP3_pin,
//			AppTP4_pin,
//			AppTP5_pin,
//			AppTP6_pin,
//			AppTP7_pin,
			AppLed_pin,
			Prevent_Opt_pin
			);

input			DDRClk_p_pin;
input			DDRClk_n_pin;
input			SysClk_p_pin;
input			SysClk_n_pin;
input			SysRst_pin;
input			Chan_En_pin;
input			CLKOUT_pin;

input			D0_n_pin;
input			D0_p_pin;
input			D1_n_pin;
input			D1_p_pin;
input			D2_n_pin;
input			D2_p_pin;
input			D3_n_pin;
input			D3_p_pin;
input			D4_n_pin;
input			D4_p_pin;
input			D5_n_pin;
input			D5_p_pin;
input			D6_n_pin;
input			D6_p_pin;
input			D7_n_pin;
input			D7_p_pin;
input			D8_n_pin;
input			D8_p_pin;
input			D9_n_pin;
input			D9_p_pin;
input			D10_n_pin;
input			D10_p_pin;
input			D11_n_pin;
input			D11_p_pin;
input			D12_n_pin;
input			D12_p_pin;
input			D13_n_pin;
input			D13_p_pin;
input			D14_n_pin;
input			D14_p_pin;


input			AppUART_Sin_pin;
input			AppUART_RTSn_pin;
input			AppUART_DTRn_pin;

output			AppUART_Sout_pin;
output			AppUART_CTSn_pin;
output			AppUART_DSRn_pin;
output			AppUART_DCDn_pin;
output			AppUART_RIn_pin;
output [3:0]	AppLed_pin;
output			Prevent_Opt_pin;
output			AppSPI_Ss_pin;
output			AppSPI_Mosi_pin;
output			AppSPI_Sclk_pin;
//begin uncomment JRV
output			AppDatClkCh1_pin;
output			AppDatClkCh2_pin;
output			AppDatClkCh3_pin;
output			AppDatClkCh4_pin;
//output			AppDatClkCh5_pin;
//output			AppDatClkCh6_pin;
//output			AppDatClkCh7_pin;
//output			AppDatClkCh8_pin;
output	[13:0]	AppTP0_pin;
output	[15:0]	AppTP1_pin;
output	[15:0]	AppTP2_pin;
output	[13:0]	AppTP3_pin;
//output	[13:0]	AppTP4_pin;
//output	[13:0]	AppTP5_pin;
//output	[13:0]	AppTP6_pin;
//output	[13:0]	AppTP7_pin;
//end uncomment JRV
//-----------------------------------------------------------------------------

wire			IntSysClk;
wire			IntSysRst;
wire			SysRst;
wire			Chan_En;

wire			IntDx00;
wire			IntDx01;
wire			IntDx02;
wire			IntDx03;
wire			IntDx04;
wire			IntDx05;
wire			IntDx06;
wire			IntDx07;
wire			IntDx08;
wire			IntDx09;
wire			IntDx10;
wire			IntDx11;
wire			IntDx12;
wire			IntDx13;
wire			IntDx14;
wire			C;

wire	[`data_width-1:0]	IntDx;
wire	[15:0]	dlydbit_sel;
wire	[7:0]		cap_modes;
wire	[7:0]		chan_sel;
wire	[5:0]	dlyinc_val;

wire			IntAppUART_Sin;
wire			IntAppUART_RTSn;
wire			IntAppUART_DTRn;
wire			IntAppUART_Sout;
wire			IntAppUART_CTSn;
wire			IntAppUART_DSRn;
wire			IntAppUART_DCDn;
wire			IntAppUART_RIn;
wire			IntAppSPI_Ss;
wire			IntAppSPI_Mosi;
wire			IntAppSPI_Sclk;
wire			tusb_bclk;
wire			usb_busy;
wire			usb_busy_b;
wire			SysLife;
wire			AdcLife;
wire			ch1_clk;
wire			ch2_clk;
wire			ch3_clk;
wire			ch4_clk;
wire			ch5_clk;
wire			ch6_clk;
wire			ch7_clk;
wire			ch8_clk;

reg				rts_n;
reg				dtr_n;
reg [`dq_width-1:0] Chan1_r;
reg [`dq_width-1:0] Chan2_r;
reg [`dq_width-1:0] Chan3_r;
reg [`dq_width-1:0] Chan4_r;

wire	[7:0]			chen;

wire	[15:0]	Chan_1;
wire	[15:0]	Chan_2;
wire	[15:0]	Chan_3;
wire	[15:0]	Chan_4;
wire	[15:0]	Chan_5;
wire	[15:0]	Chan_6;
wire	[15:0]	Chan_7;
wire	[15:0]	Chan_8;

assign chen = 8'b00000000;

//-----------------------------------------------------------------------------

IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst00(.I(D0_p_pin) , .IB(D0_n_pin) , .O(IntDx00));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst01(.I(D1_p_pin) , .IB(D1_n_pin) , .O(IntDx01));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst02(.I(D2_p_pin) , .IB(D2_n_pin) , .O(IntDx02));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst03(.I(D3_p_pin) , .IB(D3_n_pin) , .O(IntDx03));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst04(.I(D4_p_pin) , .IB(D4_n_pin) , .O(IntDx04));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst05(.I(D5_p_pin) , .IB(D5_n_pin) , .O(IntDx05));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst06(.I(D6_p_pin) , .IB(D6_n_pin) , .O(IntDx06));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst07(.I(D7_p_pin) , .IB(D7_n_pin) , .O(IntDx07));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst08(.I(D8_p_pin) , .IB(D8_n_pin) , .O(IntDx08));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst09(.I(D9_p_pin) , .IB(D9_n_pin) , .O(IntDx09));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst10(.I(D10_p_pin), .IB(D10_n_pin), .O(IntDx10));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst11(.I(D11_p_pin), .IB(D11_n_pin), .O(IntDx11));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst12(.I(D12_p_pin), .IB(D12_n_pin), .O(IntDx12));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst13(.I(D13_p_pin), .IB(D13_n_pin), .O(IntDx13));
IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_inst14(.I(D14_p_pin), .IB(D14_n_pin), .O(IntDx14));

IBUF #(.IOSTANDARD("LVCMOS33")) AppsToplevel_I_IbufRst(.I(SysRst_pin), .O(IntSysRst));
IBUF #(.IOSTANDARD("LVCMOS33")) AppsToplevel_I_IbufEn(.I(Chan_En_pin), .O(Chan_En));
IBUF #(.IOSTANDARD("LVCMOS33")) Ibuf_UART_Sin(.I(AppUART_Sin_pin), .O(IntAppUART_Sin));
IBUF #(.IOSTANDARD("LVCMOS33")) Ibuf_UART_RTSn(.I(AppUART_RTSn_pin), .O(IntAppUART_RTSn));
IBUF #(.IOSTANDARD("LVCMOS33")) Ibuf_UART_DTRn(.I(AppUART_DTRn_pin), .O(IntAppUART_DTRn));
IBUF #(.IOSTANDARD("LVCMOS33")) AppsToplevel_I_USBClk(.I(CLKOUT_pin), .O(tusb_bclk));
//
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_UART_Sout(.I(IntAppUART_Sout), .O(AppUART_Sout_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_UART_CTSn(.I(IntAppUART_CTSn), .O(AppUART_CTSn_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_UART_DSRn(.I(IntAppUART_DSRn), .O(AppUART_DSRn_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_UART_DCDn(.I(IntAppUART_DCDn), .O(AppUART_DCDn_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_UART_RIn(.I(IntAppUART_RIn), .O(AppUART_RIn_pin));
//
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_SPI_Ss(.I(IntAppSPI_Ss), .O(AppSPI_Ss_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_SPI_Mosi(.I(IntAppSPI_Mosi), .O(AppSPI_Mosi_pin));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Obuf_SPI_Sclk(.I(IntAppSPI_Sclk), .O(AppSPI_Sclk_pin));
//
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh1Clk(.I(OO), .T(~Chan_En), .O(AppDatClkCh1_pin));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_0(.I(Chan_1[00]), .T(~Chan_En), .O(AppTP0_pin[0]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_1(.I(Chan_1[01]), .T(~Chan_En), .O(AppTP0_pin[1]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_2(.I(Chan_1[02]), .T(~Chan_En), .O(AppTP0_pin[2]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_3(.I(Chan_1[03]), .T(~Chan_En), .O(AppTP0_pin[3]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_4(.I(Chan_1[04]), .T(~Chan_En), .O(AppTP0_pin[4]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_5(.I(Chan_1[05]), .T(~Chan_En), .O(AppTP0_pin[5]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_6(.I(Chan_1[06]), .T(~Chan_En), .O(AppTP0_pin[6]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_7(.I(Chan_1[07]), .T(~Chan_En), .O(AppTP0_pin[7]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_8(.I(Chan_1[08]), .T(~Chan_En), .O(AppTP0_pin[8]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_9(.I(Chan_1[09]), .T(~Chan_En), .O(AppTP0_pin[9]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_10(.I(Chan_1[10]), .T(~Chan_En), .O(AppTP0_pin[10]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_11(.I(Chan_1[11]), .T(~Chan_En), .O(AppTP0_pin[11]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_12(.I(Chan_1[12]), .T(~Chan_En), .O(AppTP0_pin[12]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP0_13(.I(Chan_1[13]), .T(~Chan_En), .O(AppTP0_pin[13]));
//
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh2Clk(.I(OO), .T(~Chan_En), .O(AppDatClkCh2_pin));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_0(.I(Chan_2[00]), .T(~Chan_En), .O(AppTP1_pin[0]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_1(.I(Chan_2[01]), .T(~Chan_En), .O(AppTP1_pin[1]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_2(.I(Chan_2[02]), .T(~Chan_En), .O(AppTP1_pin[2]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_3(.I(Chan_2[03]), .T(~Chan_En), .O(AppTP1_pin[3]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_4(.I(Chan_2[04]), .T(~Chan_En), .O(AppTP1_pin[4]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_5(.I(Chan_2[05]), .T(~Chan_En), .O(AppTP1_pin[5]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_6(.I(Chan_2[06]), .T(~Chan_En), .O(AppTP1_pin[6]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_7(.I(Chan_2[07]), .T(~Chan_En), .O(AppTP1_pin[7]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_8(.I(Chan_2[08]), .T(~Chan_En), .O(AppTP1_pin[8]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_9(.I(Chan_2[09]), .T(~Chan_En), .O(AppTP1_pin[9]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_10(.I(Chan_2[10]), .T(~Chan_En), .O(AppTP1_pin[10]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_11(.I(Chan_2[11]), .T(~Chan_En), .O(AppTP1_pin[11]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_12(.I(Chan_2[12]), .T(~Chan_En), .O(AppTP1_pin[12]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_13(.I(Chan_2[13]), .T(~Chan_En), .O(AppTP1_pin[13]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_14(.I(Chan_2[14]), .T(~Chan_En), .O(AppTP1_pin[14]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP1_15(.I(Chan_2[15]), .T(~Chan_En), .O(AppTP1_pin[15]));
//
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh3Clk(.I(OO), .T(~Chan_En), .O(AppDatClkCh3_pin));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_0(.I(Chan_3[00]), .T(~Chan_En), .O(AppTP2_pin[0]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_1(.I(Chan_3[01]), .T(~Chan_En), .O(AppTP2_pin[1]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_2(.I(Chan_3[02]), .T(~Chan_En), .O(AppTP2_pin[2]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_3(.I(Chan_3[03]), .T(~Chan_En), .O(AppTP2_pin[3]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_4(.I(Chan_3[04]), .T(~Chan_En), .O(AppTP2_pin[4]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_5(.I(Chan_3[05]), .T(~Chan_En), .O(AppTP2_pin[5]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_6(.I(Chan_3[06]), .T(~Chan_En), .O(AppTP2_pin[6]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_7(.I(Chan_3[07]), .T(~Chan_En), .O(AppTP2_pin[7]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_8(.I(Chan_3[08]), .T(~Chan_En), .O(AppTP2_pin[8]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_9(.I(Chan_3[09]), .T(~Chan_En), .O(AppTP2_pin[9]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_10(.I(Chan_3[10]), .T(~Chan_En), .O(AppTP2_pin[10]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_11(.I(Chan_3[11]), .T(~Chan_En), .O(AppTP2_pin[11]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_12(.I(Chan_3[12]), .T(~Chan_En), .O(AppTP2_pin[12]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_13(.I(Chan_3[13]), .T(~Chan_En), .O(AppTP2_pin[13]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_14(.I(Chan_3[14]), .T(~Chan_En), .O(AppTP2_pin[14]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP2_15(.I(Chan_3[15]), .T(~Chan_En), .O(AppTP2_pin[15]));
//
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh4Clk(.I(OO), .T(~Chan_En), .O(AppDatClkCh4_pin));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_0(.I(Chan_4[00]), .T(~Chan_En), .O(AppTP3_pin[0]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_1(.I(Chan_4[01]), .T(~Chan_En), .O(AppTP3_pin[1]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_2(.I(Chan_4[02]), .T(~Chan_En), .O(AppTP3_pin[2]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_3(.I(Chan_4[03]), .T(~Chan_En), .O(AppTP3_pin[3]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_4(.I(Chan_4[04]), .T(~Chan_En), .O(AppTP3_pin[4]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_5(.I(Chan_4[05]), .T(~Chan_En), .O(AppTP3_pin[5]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_6(.I(Chan_4[06]), .T(~Chan_En), .O(AppTP3_pin[6]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_7(.I(Chan_4[07]), .T(~Chan_En), .O(AppTP3_pin[7]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_8(.I(Chan_4[08]), .T(~Chan_En), .O(AppTP3_pin[8]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_9(.I(Chan_4[09]), .T(~Chan_En), .O(AppTP3_pin[9]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_10(.I(Chan_4[10]), .T(~Chan_En), .O(AppTP3_pin[10]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_11(.I(Chan_4[11]), .T(~Chan_En), .O(AppTP3_pin[11]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_12(.I(Chan_4[12]), .T(~Chan_En), .O(AppTP3_pin[12]));
OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP3_13(.I(Chan_4[13]), .T(~Chan_En), .O(AppTP3_pin[13]));
//
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppCh5Clk(.I(OO), .T(chen[4]), .O(AppDatClkCh5_pin));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_0(.I(Chan_5[00]), .T(ch5en), .O(AppTP4_pin[0]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_1(.I(Chan_5[01]), .T(ch5en), .O(AppTP4_pin[1]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_2(.I(Chan_5[02]), .T(ch5en), .O(AppTP4_pin[2]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_3(.I(Chan_5[03]), .T(ch5en), .O(AppTP4_pin[3]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_4(.I(Chan_5[04]), .T(ch5en), .O(AppTP4_pin[4]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP4_5(.I(Chan_5[05]), .T(ch5en), .O(AppTP4_pin[5]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_6(.I(Chan_5[06]), .T(ch5en), .O(AppTP4_pin[6]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_7(.I(Chan_5[07]), .T(ch5en), .O(AppTP4_pin[7]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_8(.I(Chan_5[08]), .T(ch5en), .O(AppTP4_pin[8]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_9(.I(Chan_5[09]), .T(ch5en), .O(AppTP4_pin[9]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_10(.I(Chan_5[10]), .T(ch5en), .O(AppTP4_pin[10]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_11(.I(Chan_5[11]), .T(ch5en), .O(AppTP4_pin[11]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_12(.I(Chan_5[12]), .T(ch5en), .O(AppTP4_pin[12]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP4_13(.I(Chan_5[13]), .T(ch5en), .O(AppTP4_pin[13]));
//
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh6Clk(.I(OO), .T(chen[5]), .O(AppDatClkCh6_pin));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_0(.I(Chan_6[00]), .T(ch6en), .O(AppTP5_pin[0]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_1(.I(Chan_6[01]), .T(ch6en), .O(AppTP5_pin[1]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_2(.I(Chan_6[02]), .T(ch6en), .O(AppTP5_pin[2]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_3(.I(Chan_6[03]), .T(ch6en), .O(AppTP5_pin[3]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_4(.I(Chan_6[04]), .T(ch6en), .O(AppTP5_pin[4]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_5(.I(Chan_6[05]), .T(ch6en), .O(AppTP5_pin[5]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_6(.I(Chan_6[06]), .T(ch6en), .O(AppTP5_pin[6]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_7(.I(Chan_6[07]), .T(ch6en), .O(AppTP5_pin[7]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_8(.I(Chan_6[08]), .T(ch6en), .O(AppTP5_pin[8]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_9(.I(Chan_6[09]), .T(ch6en), .O(AppTP5_pin[9]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP5_10(.I(Chan_6[10]), .T(ch6en), .O(AppTP5_pin[10]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_11(.I(Chan_6[11]), .T(ch6en), .O(AppTP5_pin[11]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_12(.I(Chan_6[12]), .T(ch6en), .O(AppTP5_pin[12]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS25"),.DRIVE(12)) AppTP5_13(.I(Chan_6[13]), .T(ch6en), .O(AppTP5_pin[13]));
//
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh7Clk(.I(OO), .T(chen[6]), .O(AppDatClkCh7_pin));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_0(.I(Chan_7[00]), .T(ch7en), .O(AppTP6_pin[0]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_1(.I(Chan_7[01]), .T(ch7en), .O(AppTP6_pin[1]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_2(.I(Chan_7[02]), .T(ch7en), .O(AppTP6_pin[2]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_3(.I(Chan_7[03]), .T(ch7en), .O(AppTP6_pin[3]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_4(.I(Chan_7[04]), .T(ch7en), .O(AppTP6_pin[4]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_5(.I(Chan_7[05]), .T(ch7en), .O(AppTP6_pin[5]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_6(.I(Chan_7[06]), .T(ch7en), .O(AppTP6_pin[6]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_7(.I(Chan_7[07]), .T(ch7en), .O(AppTP6_pin[7]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_8(.I(Chan_7[08]), .T(ch7en), .O(AppTP6_pin[8]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_9(.I(Chan_7[09]), .T(ch7en), .O(AppTP6_pin[9]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_10(.I(Chan_7[10]), .T(ch7en), .O(AppTP6_pin[10]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_11(.I(Chan_7[11]), .T(ch7en), .O(AppTP6_pin[11]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_12(.I(Chan_7[12]), .T(ch7en), .O(AppTP6_pin[12]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP6_13(.I(Chan_7[13]), .T(ch7en), .O(AppTP6_pin[13]));
//
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppCh8Clk(.I(OO), .T(chen[7]), .O(AppDatClkCh8_pin));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_0(.I(Chan_8[00]), .T(ch8en), .O(AppTP7_pin[0]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_1(.I(Chan_8[01]), .T(ch8en), .O(AppTP7_pin[1]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_2(.I(Chan_8[02]), .T(ch8en), .O(AppTP7_pin[2]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_3(.I(Chan_8[03]), .T(ch8en), .O(AppTP7_pin[3]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_4(.I(Chan_8[04]), .T(ch8en), .O(AppTP7_pin[4]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_5(.I(Chan_8[05]), .T(ch8en), .O(AppTP7_pin[5]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_6(.I(Chan_8[06]), .T(ch8en), .O(AppTP7_pin[6]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_7(.I(Chan_8[07]), .T(ch8en), .O(AppTP7_pin[7]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_8(.I(Chan_8[08]), .T(ch8en), .O(AppTP7_pin[8]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_9(.I(Chan_8[09]), .T(ch8en), .O(AppTP7_pin[9]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_10(.I(Chan_8[10]), .T(ch8en), .O(AppTP7_pin[10]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_11(.I(Chan_8[11]), .T(ch8en), .O(AppTP7_pin[11]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_12(.I(Chan_8[12]), .T(ch8en), .O(AppTP7_pin[12]));
//OBUFT #(.SLEW("fast"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppTP7_13(.I(Chan_8[13]), .T(ch8en), .O(AppTP7_pin[13]));

OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppAppLed_0(.I(AdcLife), .O(AppLed_pin[2]));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppAppLed_1(.I(usb_busy_b), .O(AppLed_pin[1]));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppAppLed_2(.I(SysRst), .O(AppLed_pin[0]));
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) AppAppLed_3(.I(SysLife), .O(AppLed_pin[3]));

// run LVDS input D2 to an unconnected output to prevent input buffer and term resistor from being optimized out
// could gate other logic with it to prevent logic from being removed if desired.
OBUF #(.SLEW("slow"),.IOSTANDARD("LVCMOS33"),.DRIVE(12)) Prevent_Opt(.I(IntDx02), .O(Prevent_Opt_pin));

//------------------------------------------------------------------------------

assign IntDx = {IntDx14,IntDx13,IntDx12,IntDx11,IntDx10,IntDx09,IntDx08,IntDx07,IntDx06,IntDx05,IntDx04,IntDx03,IntDx02,IntDx01,IntDx00};

//------------------------------------------------------------------------------

IBUFDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_instDDRClk(.I(DDRClk_p_pin),.IB(DDRClk_n_pin),.O(CLKIN_DDR));
IBUFGDS #(.DIFF_TERM("TRUE"),.IOSTANDARD("LVDS_25")) 	IBUFDS_instSysClk(.I(SysClk_p_pin),.IB(SysClk_n_pin),.O(CLKIN_OSC));

wire	CLKDLY_DDR;
ads5463_ddrif ads5463_ddrif_inst
       (
			.cntrl0_DDR2_DQ		(IntDx),
			.REF_CLK200_IN		(CLKIN_OSC),
			.SYS_RESET_IN_N		(IntSysRst),
			.cntrl0_DDR2_DQS	(CLKIN_DDR),
			.dlyen				(dlyen),
			.dlyinc				(dlyinc),
			.dlyrst				(dlyrst),
			.dlyinc_val			(dlyinc_val),
			.dlydbit_sel		(dlydbit_sel[`data_width-1:0]),
			.dlyclk_sel			(dlyclk_sel),
			.capture_modes		(cap_modes),
			.channel_sel		(chan_sel),

			.CLK				(IntSysClk),
			.CLK90				(CLK90),
			.CLKDIV_0			(),
			.CLKDIV_90			(),
			.RESET0				(SysRst),
			.RESET90			(RESET90),
			.RESET270			(),

			.dqs_div			(CLKDLY_DDR),
			.cntrl0_READ_DATA0	(Chan_1),
			.cntrl0_READ_DATA1	(Chan_2),
			.cntrl0_READ_DATA2	(Chan_3),
			.cntrl0_READ_DATA3	(Chan_4),
			.cntrl0_READ_DATA4	(Chan_5),
			.cntrl0_READ_DATA5	(Chan_6),
			.cntrl0_READ_DATA6	(Chan_7),
			.cntrl0_READ_DATA7	(Chan_8)

        );

always @ (Chan_1 or Chan_2 or Chan_3 or Chan_4 or Chan_5 or Chan_6 or Chan_7 or Chan_8 or chan_sel)
begin

	if (chan_sel[7] || chan_sel[6] || chan_sel[5] || chan_sel[4])  // mux upper 4 ch down to lower 4 ch to get to fifos
	begin
		Chan1_r <= Chan_5;
		Chan2_r <= Chan_6;
		Chan3_r <= Chan_7;
		Chan4_r <= Chan_8;
	end

	else

	begin
		Chan1_r <= Chan_1;
		Chan2_r <= Chan_2;
		Chan3_r <= Chan_3;
		Chan4_r <= Chan_4;
	end

end





assign	ch1_clk = CLKDLY_DDR;
assign	ch2_clk = CLKDLY_DDR;
assign	ch3_clk = CLKDLY_DDR;
assign	ch4_clk = CLKDLY_DDR;
assign	ch5_clk = CLKDLY_DDR;
assign	ch6_clk = CLKDLY_DDR;
assign	ch7_clk = CLKDLY_DDR;
assign	ch8_clk = CLKDLY_DDR;

evbif evbif_inst(
			.sys_clk	(IntSysClk),
			.reset		(SysRst),
			.ext_trig	(IntSysRst),		// hf@091009
			.tusb_bclk	(tusb_bclk),
			.sin		(IntAppUART_Sin),
			.rts_n		(rts_n),
			.dtr_n		(dtr_n),
			.ch1_clk	(ch1_clk),
			.ch2_clk	(ch2_clk),
			.ch3_clk	(ch3_clk),
			.ch4_clk	(ch4_clk),
			.ch1_din	(Chan1_r),
			.ch2_din	(Chan2_r),
			.ch3_din	(Chan3_r),
			.ch4_din	(Chan4_r),
// synthesis translate_off
			.full4		(),
			.full3		(),
			.full2		(),
			.full1		(),
			.empty		(),
			.fifo1_we	(),
			.fifo2_we	(),
			.fifo3_we	(),
			.fifo4_we	(),
			.fifo1_din	(),
			.fifo2_din	(),
			.fifo3_din	(),
			.fifo4_din	(),
// synthesis translate_on
			.dlyen		(dlyen),
			.dlyinc		(dlyinc),
			.dlyrst		(dlyrst),
			.dlyinc_val	(dlyinc_val),
			.dlydbit_sel(dlydbit_sel),
			.dlyclk_sel	(dlyclk_sel),
			.spi_ss		(IntAppSPI_Ss),
			.spi_sclk	(IntAppSPI_Sclk),
			.spi_mosi	(IntAppSPI_Mosi),
			.spi_miso	(1'b0),
			.cts_n		(IntAppUART_CTSn),
			.dsr_n		(IntAppUART_DSRn),
			.dcd_n		(IntAppUART_DCDn),
			.ri_n		(IntAppUART_RIn),
			.sout		(IntAppUART_Sout),
			.ibz		(usb_busy),
			.channel_sel (chan_sel),
			.capture_modes (cap_modes)
			);

assign 	usb_busy_b = ~usb_busy;

Life_Pulse life_pulse_sys_inst(
			.clkin		(IntSysClk),
			.enable 		(SysRst),
			.life_out	(SysLife)
			);


Life_Pulse life_pulse_adc_inst(
			.clkin		(CLKDLY_DDR),
			.enable 		(SysRst),
			.life_out	(AdcLife)
			);

//-----------------------------------------------------------------------------

always @(posedge IntSysClk)
begin
	rts_n		<=`DLY IntAppUART_RTSn;
	dtr_n		<=`DLY IntAppUART_DTRn;
end

//-----------------------------------------------------------------------------

assign	C = CLKDLY_DDR ? 1'b0 : 1'b1; //invert
BUFG	BUFG_inst(.I	(C), .O	(OO));
//ODDR ODDR_inst (
//      .Q(),   // 1-bit DDR output
//      .C(1'b0),   // 1-bit clock input
//      .CE(1'b1), // 1-bit clock enable input
//      .D1(1'b0), // 1-bit data input (positive edge)
//      .D2(1'b1), // 1-bit data input (negative edge)
//     .R(1'b0),   // 1-bit reset
//      .S(1'b0)    // 1-bit set
//     );
//
// The following defparams specify the behavior of the ODDR
// component.  If the instance name is changed, that
// change needs to be reflected in the defparam statements.

//   defparam ODDR_inst.DDR_CLK_EDGE = "OPPOSITE_EDGE"; // "OPPOSITE_EDGE" or "SAME_EDGE"
//   defparam ODDR_inst.INIT = 1'b0; // Initial value of Q: 1'b0 or 1'b1
//   defparam ODDR_inst.SRTYPE = "SYNC"; // Set/Reset type: "SYNC" or "ASYNC"

//-----------------------------------------------------------------------------

endmodule
