//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : $Name: i+IP+125372 $
//  \   \        Application        : MIG
//  /   /        Filename           : ddrif_data_path_iobs_0.v
// /___/   /\    Date Last Modified : $Date: 2007/04/18 13:49:24 $
// \   \  /  \   Date Created       : Mon May 2 2005
//  \___\/\___\
//
// Device      : Virtex-4
// Design Name : DDR2 SERDES
// Purpose     : This module instantiates ddrif_v4_dq_iob,
//               ddrif_v4_dqs_iob,ddrif_v4_dm_iob,ddrif_idelay_rd_en_io
//               which provides DQ,DQS,DM signals to the memory and enable signals
//               for read data.
///////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module ddrif_data_path_iobs_0
  (
   input                            CLK,
   input                            CLK90,
   input                            CLKDIV_0,
   input                            CLKDIV_90,
   input                            RESET0,
   input                            RESET90,
   input                            RESET270,
   input [`data_strobe_width-1:0]   dqs_idelay_inc,
   input [`data_strobe_width-1:0]   dqs_idelay_ce,
   input [`data_strobe_width-1:0]   dqs_idelay_rst,
   input [`data_width-1:0]          dq_idelay_inc,
   input [`data_width-1:0]          dq_idelay_ce,
   input [`data_width-1:0]          dq_idelay_rst,
   input [`data_width-1:0]          DDR_DQ,
   input [`data_strobe_width-1:0]   DDR_DQS, // Add second clock signal for QDR

   output							dqs_div,
   output [`dq_width-1:0]         dp_iobs_read_data0,
   output [`dq_width-1:0]         dp_iobs_read_data1,
   output [`dq_width-1:0]         dp_iobs_read_data2,
   output [`dq_width-1:0]         dp_iobs_read_data3,
	output [`dq_width-1:0]         dp_iobs_read_data4,
   output [`dq_width-1:0]         dp_iobs_read_data5,
   output [`dq_width-1:0]         dp_iobs_read_data6,
   output [`dq_width-1:0]         dp_iobs_read_data7

   );



   wire [`data_strobe_width-1:0]  	dqs_bufio_out;
   wire [`data_strobe_width-1:0]  	dqs_bufr_out;
   wire [`data_strobe_width-1:0]    dqs_delayed;
   wire [`data_strobe_width-1:0]    dqs_bufio_out_w;
   wire	[`data_width-1:0]			  	idly_out;
   wire                             clk_en;
   wire                             clk_en90;
	wire	[`dq_width-1:0]				read_data0;
	wire	[`dq_width-1:0]				read_data1;

	reg	[15:0]							shf_reg_0;
	reg	[15:0]							shf_reg_1;
	reg	[15:0]							shf_reg_2;
	reg	[15:0]							shf_reg_3;
	reg	[15:0]							shf_reg_4;
	reg	[15:0]							shf_reg_5;
	reg	[15:0]							shf_reg_6;
	reg	[15:0]							shf_reg_7;
	reg	[15:0]							shf_reg_8;
	reg	[15:0]							shf_reg_9;
	reg   [15:0]							par_data0;
	reg   [15:0]							par_data1;
	reg   [15:0]							par_data2;
	reg   [15:0]							par_data3;
	reg   [15:0]							par_data4;
	reg   [15:0]							par_data5;
	reg   [15:0]							par_data6;
	reg   [15:0]							par_data7;
	reg										frame_del;
	reg										frame_out;
	reg										load_data;

   assign                           clk_en = ~RESET0;
   assign                           clk_en90 = ~RESET90;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// DQS instances
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   IDELAY #(
		.IOBDELAY_TYPE	("VARIABLE"),
		.IOBDELAY_VALUE	(`DQS_DEFAULT_DLY)
   	)
	idelay_dqs  // For QDR: idelay_dqs[`data_strobe_width-1:0] or just copy twice with [1]
	(
		.O          (dqs_delayed[0]),
		.I          (DDR_DQS[0]),  //ADC Clk (DRY)
		.C          (CLK),
		.CE         (dqs_idelay_ce[0]),
		.INC        (dqs_idelay_inc[0]),
		.RST        (dqs_idelay_rst[0])
	);


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// BUFIO Instances
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   BUFIO bufio_dqs0
     (
      .O                   (dqs_bufio_out_w[0]),
      .I                   (dqs_delayed[0])
      );

assign #0.595 dqs_bufio_out  = dqs_bufio_out_w;  // Added for simulation only to account for round trip delay and BUFIO/clock route delay

BUFR #(
		.BUFR_DIVIDE("1")
	)
	BUFR_inst(
		.O(dqs_bufr_out),
		.CE(1'b1),
		.CLR(1'b0),
		.I(dqs_bufio_out)
	);

// deserialization factor in DDR mode.
BUFR #(
		.BUFR_DIVIDE("1")
	)
	BUFR_deser_inst(
		.O(dqs_div),
		.CE(1'b1),
		.CLR(1'b0),
		.I(frame_out)
	);
// synthesis attribute buffer_type of dqs_div is none

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//DQ_IOB instances
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wire gnd;

assign gnd = 1'b0;

IDELAY	#(
	.IOBDELAY_TYPE	("VARIABLE"),
	.IOBDELAY_VALUE	(`DQ_DEFAULT_DLY)
)
	IDLY_inst_[`data_width-1:0]
	(
		.O		(idly_out[`data_width-1:0]),
		.I		(DDR_DQ[`data_width-1:0]), //ADC Data
		.C		(CLK),
		.CE		(dq_idelay_ce[`data_width-1:0]),
		.INC	(dq_idelay_inc[`data_width-1:0]),
		.RST	(dq_idelay_rst[`data_width-1:0])
	);

	IDDR #(
		.DDR_CLK_EDGE	("SAME_EDGE_PIPELINED"),
		.INIT_Q1		(1'b0),		// Initial value of Q1: 1'b0 or 1'b1
		.INIT_Q2		(1'b0),		// Initial value of Q2: 1'b0 or 1'b1
		.SRTYPE			("SYNC")	// Set/Reset type: "SYNC" or "ASYNC"
		)
	IDDR_inst_[`data_width-1:0]
	(
		.Q1	(read_data0[`data_width-1:0]),	// 1-bit output for positive edge of clock
		.Q2	(read_data1[`data_width-1:0]),	// 1-bit output for negative edge of clock
		.C	(dqs_bufio_out[0]),					// 1-bit clock input
		.CE	(1'b1),									// 1-bit clock enable input
		.D	(idly_out[`data_width-1:0]),			// 1-bit DDR data input
		.R	(1'b0),									// 1-bit reset
		.S	(1'b0)									// 1-bit set
		);


assign dp_iobs_read_data0 = par_data0;
assign dp_iobs_read_data1 = par_data1;
assign dp_iobs_read_data2 = par_data2;
assign dp_iobs_read_data3 = par_data3;
assign dp_iobs_read_data4 = par_data4;
assign dp_iobs_read_data5 = par_data5;
assign dp_iobs_read_data6 = par_data6;
assign dp_iobs_read_data7 = par_data7;


always @ (posedge dqs_bufr_out[0])
begin
	shf_reg_1 <= {read_data1[11], read_data0[11], read_data1[10], read_data0[10],
							read_data1[9], read_data0[9], read_data1[8], read_data0[8],
							read_data1[6], read_data0[6], read_data1[5], read_data0[5],
							read_data1[4], read_data0[4], read_data1[3], read_data0[3]};
//	shf_reg_1 <= shf_reg_0;
	shf_reg_2 <= shf_reg_1;
	shf_reg_3 <= shf_reg_2;
	shf_reg_4 <= shf_reg_3;
	shf_reg_5 <= shf_reg_4;
	shf_reg_6 <= shf_reg_5;
	shf_reg_7 <= shf_reg_6;
	shf_reg_8 <= shf_reg_7;
	shf_reg_9 <= shf_reg_8;

	load_data <= read_data0[7] & frame_del;

	frame_del <= ~read_data0[7];
	frame_out <= ~frame_del;

	if (load_data)
		begin
		par_data0[15:0] <= {shf_reg_9[0], shf_reg_9[1], shf_reg_8[0], shf_reg_8[1], shf_reg_7[0],
							shf_reg_7[1], shf_reg_6[0], shf_reg_6[1], shf_reg_5[0], shf_reg_5[1],
							shf_reg_4[0], shf_reg_4[1], shf_reg_3[0], shf_reg_3[1], shf_reg_2[0], shf_reg_2[1]};
		par_data1[15:0] <= {shf_reg_9[2], shf_reg_9[3], shf_reg_8[2], shf_reg_8[3], shf_reg_7[2],
							shf_reg_7[3], shf_reg_6[2], shf_reg_6[3], shf_reg_5[2], shf_reg_5[3],
							shf_reg_4[2], shf_reg_4[3], shf_reg_3[2], shf_reg_3[3], shf_reg_2[2], shf_reg_2[3]};
		par_data2[15:0] <= {shf_reg_9[4], shf_reg_9[5], shf_reg_8[4], shf_reg_8[5], shf_reg_7[4],
							shf_reg_7[5], shf_reg_6[4], shf_reg_6[5], shf_reg_5[4], shf_reg_5[5],
							shf_reg_4[4], shf_reg_4[5], shf_reg_3[4], shf_reg_3[5], shf_reg_2[4], shf_reg_2[5]};
		par_data3[15:0] <= {shf_reg_9[6], shf_reg_9[7], shf_reg_8[6], shf_reg_8[7], shf_reg_7[6],
							shf_reg_7[7], shf_reg_6[6], shf_reg_6[7], shf_reg_5[6], shf_reg_5[7],
							shf_reg_4[6], shf_reg_4[7], shf_reg_3[6], shf_reg_3[7], shf_reg_2[6], shf_reg_2[7]};
		par_data4[15:0] <= {shf_reg_9[8], shf_reg_9[9], shf_reg_8[8], shf_reg_8[9], shf_reg_7[8],
							shf_reg_7[9], shf_reg_6[8], shf_reg_6[9], shf_reg_5[8], shf_reg_5[9],
							shf_reg_4[8], shf_reg_4[9], shf_reg_3[8], shf_reg_3[9], shf_reg_2[8], shf_reg_2[9]};
		par_data5[15:0] <= {shf_reg_9[10], shf_reg_9[11], shf_reg_8[10], shf_reg_8[11], shf_reg_7[10],
							shf_reg_7[11], shf_reg_6[10], shf_reg_6[11], shf_reg_5[10], shf_reg_5[11],
							shf_reg_4[10], shf_reg_4[11], shf_reg_3[10], shf_reg_3[11], shf_reg_2[10], shf_reg_2[11]};
		par_data6[15:0] <= {shf_reg_9[12], shf_reg_9[13], shf_reg_8[12], shf_reg_8[13], shf_reg_7[12],
							shf_reg_7[13], shf_reg_6[12], shf_reg_6[13], shf_reg_5[12], shf_reg_5[13],
							shf_reg_4[12], shf_reg_4[13], shf_reg_3[12], shf_reg_3[13], shf_reg_2[12], shf_reg_2[13]};
		par_data7[15:0] <= {shf_reg_9[14], shf_reg_9[15], shf_reg_8[14], shf_reg_8[15], shf_reg_7[14],
							shf_reg_7[15], shf_reg_6[14], shf_reg_6[15], shf_reg_5[14], shf_reg_5[15],
							shf_reg_4[14], shf_reg_4[15], shf_reg_3[14], shf_reg_3[15], shf_reg_2[14], shf_reg_2[15]};
		end
	else
		begin
		par_data0 <= par_data0;
		par_data1 <= par_data1;
		par_data2 <= par_data2;
		par_data3 <= par_data3;
		par_data4 <= par_data4;
		par_data5 <= par_data5;
		par_data6 <= par_data6;
		par_data7 <= par_data7;
		end
end

endmodule
