//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : $Name: i+IP+125372 $
//  \   \        Application        : MIG
//  /   /        Filename           : ddrif_top_0.v
// /___/   /\    Date Last Modified : $Date: 2007/04/18 13:49:24 $
// \   \  /  \   Date Created       : Mon May 2 2005
//  \___\/\___\
//
// Device      : Virtex-4
// Design Name : DDR2 SERDES
// Purpose     : This module is the top level for the physical layer and
//               instantiates the following modules:ddrif_Data_path,
//               ddrif_ddr2_controller,ddrif_iobs,
//               ddrif_user_interface.
///////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module ddrif_top_0
  (
   input	                       CLK,
   input                           CLK90,
   input                           CLKDIV_0,
   input                           CLKDIV_90,
   input                           RESET0,
   input                           RESET90,
   input                           RESET270,   

   input [`data_width-1:0]         DDR2_DQ,
   input [`data_strobe_width-1:0]  DDR2_DQS,
   input [`data_strobe_width-1:0]  dqs_idelay_inc,
   input [`data_strobe_width-1:0]  dqs_idelay_ce,
   input [`data_strobe_width-1:0]  dqs_idelay_rst,
   input [`data_width-1:0]         dq_idelay_inc,
   input [`data_width-1:0]         dq_idelay_ce,
   input [`data_width-1:0]         dq_idelay_rst,

   output						   dqs_div,
   output [`dq_width-1:0]        READ_DATA0,
   output [`dq_width-1:0]        READ_DATA1,
   output [`dq_width-1:0]        READ_DATA2,
   output [`dq_width-1:0]        READ_DATA3,
	output [`dq_width-1:0]        READ_DATA4,
   output [`dq_width-1:0]        READ_DATA5,
   output [`dq_width-1:0]        READ_DATA6,
   output [`dq_width-1:0]        READ_DATA7

   );

   ddrif_iobs_0 iobs_0
     (
      .CLKDIV_0               (CLKDIV_0),
      .CLKDIV_90              (CLKDIV_90),
      .CLK                    (CLK),
      .CLK90                  (CLK90),
      .RESET0                 (RESET0),
      .RESET90                (RESET90),
      .RESET270               (RESET270),
	  .dp_dqs_idelay_inc      (dqs_idelay_inc),
	  .dp_dqs_idelay_ce       (dqs_idelay_ce),
	  .dp_dqs_idelay_rst      (dqs_idelay_rst),
	  .dp_dq_idelay_inc       (dq_idelay_inc),
	  .dp_dq_idelay_ce        (dq_idelay_ce),
	  .dp_dq_idelay_rst       (dq_idelay_rst),
	  .dqs_div		 		  (dqs_div),
      .iobs_read_data0        (READ_DATA0),
      .iobs_read_data1        (READ_DATA1),
      .iobs_read_data2        (READ_DATA2),
      .iobs_read_data3        (READ_DATA3),
		.iobs_read_data4        (READ_DATA4),
      .iobs_read_data5        (READ_DATA5),
      .iobs_read_data6        (READ_DATA6),
      .iobs_read_data7        (READ_DATA7),

      .DDR_DQ                 (DDR2_DQ),
      .DDR_DQS                (DDR2_DQS)
      );


endmodule
