
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
// Modified:	RMP added reg 18 for capture modes 4/3/08
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module evbif_ctrl(
				clk,
				reset,

				spi_dout,  //SPI finnished (used for ADC SPI readback)?
				spi_dp,//SPI finnished? (dp=data present)
				uart_dout,//UART (used for UART readback)?
				uart_dp,//UART finnished?
				tx_done_p, // UART is done with transferring all memories (LED goes off)
				tx_buffer_full, //Dont disturb the UART until tx buffer full
				ext_trig_p,		// hf@091009

				v5_r,
				uart_oe_r,
				uart_din,
				uart_we,
				ctrl0_r,	// reset capture buffers (Reset all bits = FF)
				copy_ctrl0_r,
				copy_ctrl2_r,
				copy1_ctrl2_r,
				copy2_ctrl2_r,
				copy3_ctrl2_r,
				copy4_ctrl2_r,
				ctrl1_r,	// go capture and tx data
				ctrl2_r,	// channel configuration
				ctrl3_r,	// address register for read commands
				ctrl4_r,	// MAX Reads on UART
				ctrl5_r,	// {reset delay for deskew, inc/dec tap, inc/dec value[5:0]}
				ctrl6_r,	// uart baud rate
				ctrl7_r,	// uart modem control signals
				ctrl8_r,	// spi ctrl
				ctrl9_r,	// spi baud rate  (default = sys_clk/200)
				ctrl10_r,	// to spi transmit data[7:0]
				ctrl11_r,	// to spi transmit data[15:8]
				ctrl12_r,	// to spi transmit address[23:16]
				ctrl13_r,	// select for deskew ddr data lines[7:0]
				ctrl14_r,	// select for deskew ddr data lines[11:8]
				ctrl15_r,	// select for deskew ddr clk line
				ctrl18_r,	// capture modes for front end such as bit/byte, msb/lsb, etc
				ctrl19_r		// slk edge select split out from reg 18 to make gui cleaner
				);

input			clk;
input			reset;
input			tx_done_p;
input			tx_buffer_full;

input	[23:0]	spi_dout;
input	[7:0]	uart_dout;
input			spi_dp;
input			uart_dp;

input			ext_trig_p;		// hf@091009

output			v5_r;
output			uart_oe_r;
output			uart_we;
output	[7:0]	ctrl0_r;
output	[11:0]	copy_ctrl0_r;
output	[7:0]	copy_ctrl2_r;
output	[7:0]	copy1_ctrl2_r;
output	[7:0]	copy2_ctrl2_r;
output	[7:0]	copy3_ctrl2_r;
output	[7:0]	copy4_ctrl2_r;
output	[7:0]	ctrl1_r;
output	[7:0]	ctrl2_r;
output	[7:0]	ctrl3_r;
output	[7:0]	ctrl4_r;
output	[7:0]	ctrl5_r;
output	[7:0]	ctrl6_r;
output	[7:0]	ctrl7_r;
output	[7:0]	ctrl8_r;
output	[7:0]	ctrl9_r;
output	[7:0]	ctrl10_r;
output	[7:0]	ctrl11_r;
output	[7:0]	ctrl12_r;
output	[7:0]	ctrl13_r;
output	[7:0]	ctrl14_r;
output	[7:0]	ctrl15_r;
output 	[7:0] ctrl18_r;
output	[7:0] ctrl19_r;
output	[7:0]	uart_din;

//-----------------------------------------------------------------------------

reg				v5_r;
reg				uart_we;
reg				uart_oe_r;
reg				uart_we_r;
reg				cnt_r;
reg		[7:0]	addr_r;
reg		[7:0]	data_r;
reg		[11:0]	copy_ctrl0_r;
reg		[7:0]	copy_ctrl2_r;
reg		[7:0]	copy1_ctrl2_r;
reg		[7:0]	copy2_ctrl2_r;
reg		[7:0]	copy3_ctrl2_r;
reg		[7:0]	copy4_ctrl2_r;
reg		[7:0]	ctrl0_r;
reg		[7:0]	ctrl1_r;
reg		[7:0]	ctrl2_r;
reg		[7:0]	ctrl3_r;
reg		[7:0]	ctrl4_r;
reg		[7:0]	ctrl5_r;
reg		[7:0]	ctrl6_r;
reg		[7:0]	ctrl7_r;
reg		[7:0]	ctrl8_r;
reg		[7:0]	ctrl9_r;
reg		[7:0]	ctrl10_r;
reg		[7:0]	ctrl11_r;
reg		[7:0]	ctrl12_r;
reg		[7:0]	ctrl13_r;
reg		[7:0]	ctrl14_r;
reg		[7:0]	ctrl15_r;
reg		[7:0]	ctrl16_r;	// Firmware Version Number
reg		[7:0]	ctrl17_r;	// ADC Specific number
reg		[7:0] ctrl18_r;	// capture modes
reg		[7:0] ctrl19_r;	// clk edge sel
reg		[7:0]	uart_din;
reg				addr_r0;
reg				addr_r1;
reg				addr_r2;
reg				addr_r3;
reg				addr_r4;
reg				addr_r5;
reg				addr_r6;
reg				addr_r7;
reg				addr_r8;
reg				addr_r9;
reg				addr_r10;
reg				addr_r11;
reg				addr_r12;
reg				addr_r13;
reg				addr_r14;
reg				addr_r15;
reg				addr_r16;
reg				addr_r17;
reg 				addr_r18;
reg				addr_r19;
reg				write_en;

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(uart_dp && !uart_oe_r)
		uart_oe_r <=`DLY 1'b1;
	else
		uart_oe_r <=`DLY 1'b0;
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(reset)
		cnt_r <=`DLY 1'b0;
	else if(uart_oe_r)
		cnt_r <=`DLY ~cnt_r;
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(uart_oe_r && ~cnt_r)  // was if(uart_dp &&  ~cnt_r)
		addr_r <=`DLY uart_dout;

	if(uart_oe_r &&  cnt_r)  // if(uart_dp &&  cnt_r)
	begin
		data_r <=`DLY uart_dout;  // catch data
		write_en <= 1'b1;  //  make a write pulse for moving data to register
	end

	if (write_en)
		write_en <= 1'b0;

end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(reset)
	begin
		ctrl0_r <=`DLY 8'hFF;
		copy_ctrl0_r <=`DLY 12'hFFF;

		ctrl1_r <=`DLY 8'b0;

		ctrl2_r <=`DLY 8'b0;
		copy_ctrl2_r <=`DLY 8'b0;
		copy1_ctrl2_r <=`DLY 8'b0;
		copy2_ctrl2_r <=`DLY 8'b0;
		copy3_ctrl2_r <=`DLY 8'b0;
		copy4_ctrl2_r <=`DLY 8'b0;

		ctrl3_r <=`DLY 8'b0;

		ctrl4_r <=`DLY 8'b1111_1000;

		ctrl5_r <=`DLY 8'b0;

// Set baud rate to 115200 for the UART communications
// Requires en_16_x_baud to be 1843200 Hz which is a single cycle pulse every 136 cycles at 250MHz
		ctrl6_r <=`DLY 8'd135;
//		ctrl6_r <=`DLY 8'd16;	// 921600*16 Hz which is a single cycle pulse every 17 cycles at 250MHz

		ctrl7_r <=`DLY 8'h0F;

		ctrl8_r <=`DLY 8'b0;

// Set baud rate to ? for the SPI communications
		ctrl9_r <=`DLY 8'd99;

		ctrl10_r <=`DLY 8'b0;

		ctrl11_r <=`DLY 8'b0;

		ctrl12_r <=`DLY 8'b0;

		ctrl13_r <=`DLY 8'b0;

		ctrl14_r <=`DLY 8'b0;

		ctrl15_r <=`DLY 8'b0;

		ctrl16_r <=`DLY 8'h15;  		// HIGH NIBBLE = MAJOR REVISION LOW NIBBLE = MINOR REVISION
										// version 1.0 usb initial ver of 1w/2w serial with IDDR input
										// version 1.1 added 4-wire format
										// version 1.2 added control of output enable for posts
										// ver 1.5 supports externally triggered capture, in addition to normal capture
										// software modification is needed for ext. trig. capture

		ctrl17_r <=`DLY 8'h04;  //  ADC format 1=DDR Parallel, 2=14/16b serial, 3=12b serial, 4=serial 1 or 2w

		ctrl18_r <=`DLY 8'h00;
			// rsvd
			// bit1 0 = msb 1st,  	1 = lsb 1st  not yet used
			// bit2 0 = offset b		1 = 2s complement  not yet used
			// bit3 0 = 1-wire		1 = 2-wire
			// bit45 00 = 16b 		01 = 14b		10 = 12b		11 = 11b  # bits to not mask out   only used for 2wire
			// bit6 1 = 4-wire  		0 = 1 or 2 wire = default
			// bit7 rsvd

		ctrl19_r <= `DLY 8'h00;
			// bit7 ddr clk edge select not used yet in deser, could be good for ads528x in future.

	end
	else
	begin
		if(write_en && addr_r0)  // write enable
		begin
			ctrl0_r <=`DLY data_r;
			copy_ctrl0_r <=`DLY {data_r[3:0],data_r};
		end

// hf@091009 begin
		if(write_en && addr_r1)
			ctrl1_r <=`DLY data_r;
		else if(tx_done_p)
			ctrl1_r <=`DLY 8'b0;
		else if(ext_trig_p)
			ctrl1_r <=`DLY {ctrl1_r[7:4],ctrl1_r[7:4]};
// hf@091009 end

		if(write_en && addr_r2)
		begin
			ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			copy_ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			copy1_ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			copy2_ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			copy3_ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			copy4_ctrl2_r <=`DLY {data_r[7:4], data_r[7:4] | data_r[3:0]};
			// messy, if upper 4 channels selected copy that into a lower 4 selection
			// don't have 8 data pipes defined from ddrif to evbif, so if upper 4 ch are
			// selelcted reflect that selection down to lower 4, and ddrif will see the upper
			// 4 select bits and will mux upper 4 channels down to lower 4 data lanes from ddrif
			// would be cleaner to someday define 4 more data lanes between ddrif and evbif and
			// let evbif do an 8:1 muxing of data lanes into fifos.
			// assumes only one channel is selected at a time to do the or function.  FIFOs will
			// allow multiple channels into fifos, but not now.  May want to clean up later.
		end

		if(write_en && addr_r3)
			ctrl3_r <=`DLY data_r;

		if(write_en && addr_r4)
			ctrl4_r <=`DLY data_r;

		if(write_en && addr_r5)
			ctrl5_r <=`DLY data_r;
		else ctrl5_r <= {1'b0, ctrl5_r[6:0]};  // make idelay rst one clock in length  rmp

		if(write_en && addr_r6)
			ctrl6_r <=`DLY data_r;

		if(write_en && addr_r7)
			ctrl7_r <=`DLY data_r;

		if(write_en && addr_r8)
			ctrl8_r <=`DLY data_r;
		else if(spi_dp)
			ctrl8_r <=`DLY 8'b0;

		if(write_en && addr_r9)
			ctrl9_r <=`DLY data_r;

		if(write_en && addr_r10)
			ctrl10_r <=`DLY data_r;

		if(write_en && addr_r11)
			ctrl11_r <=`DLY data_r;

		if(write_en && addr_r12)
			ctrl12_r <=`DLY data_r;

		if(write_en && addr_r13)
			ctrl13_r <=`DLY data_r;

		if(write_en && addr_r14)
			ctrl14_r <=`DLY data_r;

		if(write_en && addr_r15)
			ctrl15_r <=`DLY data_r;

		if(write_en && addr_r16)
			ctrl16_r <=`DLY data_r;

		if(write_en && addr_r17)
			ctrl17_r <=`DLY data_r;

		if(write_en && addr_r18)
			ctrl18_r <=`DLY data_r;

		if(write_en && addr_r19)
			ctrl19_r <=`DLY data_r;
	end
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(write_en && addr_r5)
		v5_r <=`DLY 1'b1;
	else
		v5_r <=`DLY 1'b0;
end

//-----------------------------------------------------------------------------
// address to write
always @(addr_r)
begin
		case(addr_r[4:0])	// synopsys parallel_case full_case
			5'd0	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000000001;
			5'd1	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000000010;
			5'd2	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000000100;
			5'd3	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000001000;
			5'd4	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000010000;
			5'd5	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000000100000;
			5'd6	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000001000000;
			5'd7	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000010000000;
			5'd8	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000000100000000;
			5'd9	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000001000000000;
			5'd10	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000010000000000;
			5'd11	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000000100000000000;
			5'd12	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000001000000000000;
			5'd13	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000010000000000000;
			5'd14	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00000100000000000000;
			5'd15	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00001000000000000000;
			5'd16	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00010000000000000000;
			5'd17	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b00100000000000000000;
			5'd18	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b01000000000000000000;
			5'd19	:	{addr_r19,addr_r18,addr_r17,addr_r16,addr_r15,addr_r14,addr_r13,addr_r12,addr_r11,addr_r10,addr_r9,addr_r8,addr_r7,addr_r6,addr_r5,addr_r4,addr_r3,addr_r2,addr_r1,addr_r0} = 20'b10000000000000000000;
		endcase
end

//-----------------------------------------------------------------------------
// register to read
always @(ctrl0_r or ctrl1_r or ctrl2_r or ctrl3_r or ctrl4_r or ctrl5_r or ctrl6_r or ctrl7_r or
ctrl8_r or ctrl9_r or ctrl10_r or ctrl11_r or ctrl12_r or ctrl13_r or ctrl14_r or ctrl15_r or ctrl16_r or ctrl17_r or ctrl18_r or ctrl19_r)
begin
		case(ctrl3_r[4:0])	// synopsys parallel_case full_case
			5'd0	:	uart_din = ctrl0_r;
			5'd1	:	uart_din = ctrl1_r;
			5'd2	:	uart_din = ctrl2_r;
			5'd3	:	uart_din = ctrl3_r;
			5'd4	:	uart_din = ctrl4_r;
			5'd5	:	uart_din = ctrl5_r;
			5'd6	:	uart_din = ctrl6_r;
			5'd7	:	uart_din = ctrl7_r;
			5'd8	:	uart_din = ctrl8_r;
			5'd9	:	uart_din = ctrl9_r;
			5'd10	:	uart_din = ctrl10_r;
			5'd11	:	uart_din = ctrl11_r;
			5'd12	:	uart_din = ctrl12_r;
			5'd13	:	uart_din = ctrl13_r;
			5'd14	:	uart_din = ctrl14_r;
			5'd15	:	uart_din = ctrl15_r;
			5'd16	:	uart_din = ctrl16_r;
			5'd17	:	uart_din = ctrl17_r;
			5'd18 : 	uart_din = ctrl18_r;
			5'd19 : 	uart_din = ctrl19_r;
		endcase
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(write_en && addr_r3)
		uart_we_r <=`DLY 1'b1;
	else
		uart_we_r <=`DLY 1'b0;
end

//-----------------------------------------------------------------------------
// transfers each register 8 times
reg		[3:0]	tmp_cnt_r;
always @(posedge clk)
begin
	if(uart_we_r)
		tmp_cnt_r <=`DLY 4'h8;
	else if(uart_we)
		tmp_cnt_r <=`DLY tmp_cnt_r - 1'b1;
	else if(|tmp_cnt_r)
		tmp_cnt_r <=`DLY tmp_cnt_r;
	else
		tmp_cnt_r <=`DLY 4'h0;
end

always @(tmp_cnt_r or tx_buffer_full)
	uart_we = |tmp_cnt_r && !tx_buffer_full; // transfer data when TX buffer not full

//-----------------------------------------------------------------------------

endmodule
