
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module obufdes_safifo(
			wreset,				// reset input
			rreset,				// reset input

			wr_clk,				// write clock input
			rd_clk,				// read	clock input

			din,				// data	input
			we,					// write enable	input
			dvalid,				// output data is valid
			dout				// output data
			);

input			wr_clk;
input			rd_clk;
input			wreset;
input			rreset;
input			we;
input	[15:0]	din;

output			dvalid;
output	[15:0]	dout;

//-----------------------------------------------------------------------------

reg	 			enb;
reg	 			ena;
reg				oei_r;
reg				dvalid;
reg		[15:0]	din_r;
reg		[15:0]	dout;
reg 	[2:0] 	flag_r;
reg 	[2:0] 	flag;
reg		[3:0]	addra_cur;
reg		[3:0]	addra_nxt;
reg		[3:0]	addrb_cur;

//-----------------------------------------------------------------------------

reg		[3:0]	addra_cur_sync_r;
reg		[3:0]	addra_cur_r;
reg		[3:0]	addrb_cur_r;

wire	[35:0]	douta;
wire	[35:0]	doutb;

//-----------------------------------------------------------------------------

always @(posedge wr_clk)
begin
	addra_cur_r	<=`DLY addra_cur;
	din_r		<=`DLY din;
end

//-----------------------------------------------------------------------------

always @(rreset or oei_r)
begin
	enb = oei_r | rreset; //needed to make sure the ram enable is high during reset (because its a synchronous reset)
end

always @(wreset or we)
begin
	ena = we | wreset; //needed to make sure the ram enable is high during reset (because its a synchronous reset)
end

//-----------------------------------------------------------------------------

always @(douta)
begin
	addra_cur = douta[35:32];
end

always @(doutb)
begin
	addrb_cur = doutb[35:32];
end

//-----------------------------------------------------------------------------

always @(addra_cur)	// next address = current_address + 1 with 2 MSBs gray coded
begin
	case(addra_cur)	// synopsys parallel_case
		4'b0000	:	addra_nxt = 4'b0001;
		4'b0001	:	addra_nxt = 4'b0010;
		4'b0010	:	addra_nxt = 4'b0011;
		4'b0011	:	addra_nxt = 4'b0100;
		4'b0100	:	addra_nxt = 4'b0101;
		4'b0101	:	addra_nxt = 4'b0110;
		4'b0110	:	addra_nxt = 4'b0111;
		4'b0111	:	addra_nxt = 4'b1100;
		4'b1000	:	addra_nxt = 4'b1001;
		4'b1001	:	addra_nxt = 4'b1010;
		4'b1010	:	addra_nxt = 4'b1011;
		4'b1011	:	addra_nxt = 4'b0000;
		4'b1100	:	addra_nxt = 4'b1101;
		4'b1101	:	addra_nxt = 4'b1110;
		4'b1110	:	addra_nxt = 4'b1111;
		4'b1111	:	addra_nxt = 4'b1000;
	endcase
end

//-----------------------------------------------------------------------------

always @(doutb)
begin
	dout = doutb[31:16];
end

//-----------------------------------------------------------------------------
//Coregen block
bram16x36 safifo_bram16x36_inst(
		.clka			(wr_clk),
		.dina			({addra_nxt,din_r,16'b0}),	// Bus [35 : 0]
		.addra			(addra_cur),				// Bus [3 : 0]
		.ena			(ena),
		.wea			(we),						// Bus [0 : 0]
		.ssra			(wreset),
		.douta			(douta),					// Bus [35 : 0]
		.clkb			(rd_clk),
		.dinb			(36'b0),					// Bus [35 : 0]
		.addrb			(addrb_cur),				// Bus [3 : 0]
		.enb			(enb),
		.web			(1'b0),						// Bus [0 : 0]
		.ssrb			(rreset),
		.doutb			(doutb)						// Bus [35 : 0]
		);

//-----------------------------------------------------------------------------

always @(addrb_cur or addra_cur)
begin
	flag[2]	=	(((addrb_cur[3:2] == 2'b00) && (addra_cur[3] == 1'b1)) |
				 ((addrb_cur[3:2] == 2'b01) && (addra_cur[2] == 1'b0)) |
				 ((addrb_cur[3:2] == 2'b11) && (addra_cur[3] == 1'b0)) |
				 ((addrb_cur[3:2] == 2'b10) && (addra_cur[2] == 1'b1)))
				? 1'b1 : 1'b0;	// The FIFO being between one-half to full

	flag[1] =	(((addrb_cur[3:2] == 2'b00) && (addra_cur[3:2] == 2'b01)) |
				 ((addrb_cur[3:2] == 2'b01) && (addra_cur[3:2] == 2'b11)) |
				 ((addrb_cur[3:2] == 2'b11) && (addra_cur[3:2] == 2'b10)) |
				 ((addrb_cur[3:2] == 2'b10) && (addra_cur[3:2] == 2'b00)))
				? 1'b1 : 1'b0;	// The FIFO being between one-quarter to three-quarters full

	flag[0] =	(((addrb_cur[3:2] == 2'b00) && (addra_cur[3:2] == 2'b00)) |
				 ((addrb_cur[3:2] == 2'b01) && (addra_cur[3:2] == 2'b01)) |
				 ((addrb_cur[3:2] == 2'b11) && (addra_cur[3:2] == 2'b11)) |
				 ((addrb_cur[3:2] == 2'b10) && (addra_cur[3:2] == 2'b10)))
				? 1'b1 : 1'b0;	// The FIFO being between empty and one-half full
end

//-----------------------------------------------------------------------------

always @(posedge rd_clk)
begin
	addra_cur_sync_r	<=`DLY addra_cur_r;
	addrb_cur_r			<=`DLY addrb_cur;
	flag_r				<=`DLY flag;
end

always @(posedge rd_clk)
begin
	oei_r <=`DLY flag_r[2];
end

always @(posedge rd_clk)
begin
	dvalid <=`DLY oei_r;
end

//-----------------------------------------------------------------------------

endmodule