
//============================================================================
//
//This confidential	and	proprietary	software may be	used only as authorized
//by a licensing agreement from	Texas Instruments, US.
//
//	   In the event	of publication,	the	following notice is	applicable:
//
//						  (C) COPYRIGHT	2007 TI
//							ALL	RIGHTS RESERVED
//
// Entire notice above must	be reproduced on all authorized	copies.
//
//
// Title:	   %M%
// Version:	   %I%
// Date:	   %G%
// Author:	   Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module spi_clkgen(
				clk_in,
				rst,
				enable,
				last_clk,
				divider,
				clk_out,
				pos_edge,
				neg_edge
				);

input			clk_in;   // input	clock (system clock)
input			rst;	  // reset
input			enable;   // clock	enable
input			last_clk; // last clock
input	[7:0]	divider;  // clock divider (output clock is	divided	by this	value)

output			clk_out;  // output clock
output			pos_edge; // pulse	marking	positive edge of clk_out
output			neg_edge; // pulse	marking	negative edge of clk_out

//-----------------------------------------------------------------------------
							
reg				clk_out;
reg				pos_edge;
reg				neg_edge;
							
reg		[7:0]	cnt;		// clock counter 
wire			cnt_zero;	//	conter is equal	to zero

//-----------------------------------------------------------------------------
  
assign cnt_zero =	~|cnt;

// Counter counts	half period
always @(posedge clk_in)
begin
	if(enable && !cnt_zero)
		cnt <=`DLY cnt - 1'b1;
	else 
		cnt <=`DLY divider;
end

// clk_out is asserted every other half period
always @(posedge clk_in or posedge rst)
begin
	if(rst)
		clk_out <=`DLY 1'b1;
	else
		clk_out <=`DLY (enable && cnt_zero) ? ~clk_out : clk_out;
end

//-----------------------------------------------------------------------------

always @(clk_out or	cnt_zero)
begin
	pos_edge  =	cnt_zero &&	~clk_out;
	neg_edge  =	cnt_zero &&	 clk_out;
end

//-----------------------------------------------------------------------------

endmodule
