
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module uart_baudgen(
				clk,
				tusb_bclk,	// tusb_bclk = 14.76923077M as per datasheet //Move to input declaration for TUSB3410 change
				reset,
				div_val,
				en_16_x_baud
				); 

input			clk;
input			reset;
input	[7:0]	div_val;

output			en_16_x_baud;
input			tusb_bclk;

//-----------------------------------------------------------------------------

// 921600 -> 14.76923077M / (16 * 921600) = 1.0016 ~= 1
// 14.76923077M / (16 * 1) = 923 076.92 -> Error 0.16%
// Therefore, en_16_x_baud = tusb_bclk;
// We just need to synchronize it to 'clk' & make its duration = 1 'clk' cycle
// i.e. IF WE USE THE TUSB_BCLK AT ALL!!

reg				tusb_bclk_d1_r;
reg				tusb_bclk_d2_r;
reg				tusb_bclk_d3_r;
reg				en_16_x_baud;
reg		[7:0]	baud_count;

//-----------------------------------------------------------------------------

// assign	tusb_bclk = en_16_x_baud;  not needed if we take tusb_bclk in from usb chip

always @(posedge clk)
begin
	tusb_bclk_d1_r <=`DLY tusb_bclk;
	tusb_bclk_d2_r <=`DLY tusb_bclk_d1_r;
	tusb_bclk_d3_r <=`DLY tusb_bclk_d2_r;
end
//ENABLE for using TUSB3410 CLKOUT
always @(tusb_bclk_d2_r or tusb_bclk_d3_r)
begin
	en_16_x_baud = tusb_bclk_d2_r & ~tusb_bclk_d3_r;
end

// Set baud rate to 115200 for the UART communications
// Requires en_16_x_baud to be 1843200Hz which is a single cycle pulse every 108 cycles at 200MHz 

//comment starting here when CLKOUT used
// always @(posedge clk)
// begin
// 	if(reset)
// 	begin
// 		baud_count <=`DLY 8'd0;
// 		en_16_x_baud <=`DLY 1'b0;
// 	end
// `ifdef SIMULATE_IN_MODELSIM
// 	else if (baud_count == 8'd10) // Just to make the simulation fast!
// `else
// 	else if (baud_count == div_val) 
// `endif
// 	begin
// 		baud_count <=`DLY 8'd0;
// 		en_16_x_baud <=`DLY 1'b1;
// 	end
// 	else
// 	begin
// 		baud_count <=`DLY baud_count + 1'b1;
// 		en_16_x_baud <=`DLY 1'b0;
// 	end
// end
//comment end here when CLKOUT used
//-----------------------------------------------------------------------------

endmodule
