/*************************************************************************************************************************************************/
/*!     DAC8760.h
 *
 *
 */
/**************************************************************************************************************************************************
 *       Copyright  2014 Texas Instruments Incorporated - http://www.ti.com/                                                                      *
 ***************************************************************************************************************************************************
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
 *                                                                                                                                                 *
 *    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
 *                                                                                                                                                 *
 *    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
 *    documentation and/or other materials provided with the distribution.                                                                         *
 *                                                                                                                                                 *
 *    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
 *    from this software without specific prior written permission.                                                                                *
 *                                                                                                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
 **************************************************************************************************************************************************/
//
//
//   Thomas Schneider
//   Texas Instruments Inc.
//   July 2014
//   Built with Code Composer Studio V6.0
//***************************************************************************************************************************************************
#ifndef DAC8760_H_
#define DAC8760_H_

// DAC8760 Address Functions
#define DAC8760_WRITE_NOP_REGISTER			         0x00
#define DAC8760_WRITE_DATA_REGISTER			         0x01
#define DAC8760_READ_REGISTER    			         0x02
#define DAC8760_WRITE_CONTROL_REGISTER			     0x55
#define DAC8760_WRITE_RESET_REGISTER		     	 0x56
#define DAC8760_WRITE_CONFIGURATION_REGISTER		 0x57
#define DAC8760_WRITE_GAIN_CALIBRATION_REGISTER		 0x58
#define DAC8760_WRITE_ZERO_CALIBRATION_REGISTER		 0x59
#define DAC8760_WRITE_WATCHDOG_TIMER_RESET		     0x95

// DAC8760 Register Read Address Functions
#define DAC8760_READ_STATUS_REGISTER                 0x00
#define DAC8760_READ_DATA_REGISTER                   0x01
#define DAC8760_READ_CONTROL_REGISTER                0x02
#define DAC8760_READ_CONFIGURATION_REGISTER          0x0B
#define DAC8760_READ_GAIN_CALIBRATION_REGISTER       0x13
#define DAC8760_READ_ZERO_CALIBRATION_REGISTER       0x17

// Control Register Settings
#define DAC8760_CLRSEL_SHIFT                         15
#define DAC8760_CLRSEL                               (1 << DAC8760_CLRSEL_SHIFT)
#define DAC8760_OVR_SHIFT                            14
#define DAC8760_OVR                                  (1 << DAC8760_OVR_SHIFT)
#define DAC8760_REXT_SHIFT                           13
#define DAC8760_REXT                                 (1 << DAC8760_REXT_SHIFT)
#define DAC8760_OUTEN_SHIFT                          12
#define DAC8760_OUTEN                                (1 << DAC8760_OUTEN_SHIFT)
#define DAC8760_SRCLK_SHIFT                          8
#define DAC8760_UPDATE_FREQUENCY_258065              (0 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_200000              (1 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_153845              (2 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_131145              (3 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_115940              (4 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_69565               (5 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_37560               (6 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_25805               (7 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_20150               (8 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_16030               (9 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_10295               (10 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_8280                (11 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_6900                (12 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_5530                (13 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_4240                (14 << DAC8760_SRCLK_SHIFT)
#define DAC8760_UPDATE_FREQUENCY_3300                (15 << DAC8760_SRCLK_SHIFT)
#define DAC8760_SRSTEP_SHIFT                         5
#define DAC8760_SLEW_RATE_STEP_SIZE_1                (0 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_2                (1 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_4                (2 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_8                (3 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_16               (4 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_32               (5 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_64               (6 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SLEW_RATE_STEP_SIZE_128              (7 << DAC8760_SRSTEP_SHIFT)
#define DAC8760_SREN_SHIFT                           4
#define DAC8760_SLEW_RATE_ENABLE                     (1 << DAC8760_SREN_SHIFT)
#define DAC8760_DCEN_SHIFT                           3
#define DAC8760_DAISY_CHAIN_ENABLE                   (1 << DAC8760_DCEN_SHIFT)
#define DAC8760_RANGE_SHIFT                          0
#define DAC8760_RANGE_0V_5V                          (0 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_0V_10V                         (1 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_M5V_P5V                        (2 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_M10V_P10V                      (3 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_NOT_ALLOWED                    (4 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_4MA_20MA                       (5 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_0MA_20MA                       (6 << DAC8760_RANGE_SHIFT)
#define DAC8760_RANGE_0MA_24MA                       (7 << DAC8760_RANGE_SHIFT)

// Configuration Register Settings
#define DAC8760_IOUT_RANGE_SHIFT                     9
#define DAC8760_IOUT_RANGE_DISABLED                  (0 << DAC8760_IOUT_RANGE_SHIFT)
#define DAC8760_IOUT_RANGE_4MA_20MA                  (1 << DAC8760_IOUT_RANGE_SHIFT)
#define DAC8760_IOUT_RANGE_0MA_20MA                  (2 << DAC8760_IOUT_RANGE_SHIFT)
#define DAC8760_IOUT_RANGE_0MA_24MA                  (3 << DAC8760_IOUT_RANGE_SHIFT)
#define DAC8760_DUAL_OUTEN_SHIFT                     8
#define DAC8760_DUAL_OUT_ENABLE                      (1 << DAC8760_DUAL_OUTEN_SHIFT)
#define DAC8760_APD_SHIFT                            7
#define DAC8760_APD                                  (1 << DAC8760_APD_SHIFT)
#define DAC8760_CALEN_SHIFT                          5
#define DAC8760_CAL_ENABLE                           (1 << DAC8760_CALEN_SHIFT)
#define DAC8760_HARTEN_SHIFT                         4
#define DAC8760_HART_ENABLE                          (1 << DAC8760_HARTEN_SHIFT)
#define DAC8760_CRCEN_SHIFT                          3
#define DAC8760_CRC_ENABLE                           (1 << DAC8760_CRCEN_SHIFT)
#define DAC8760_WDEN_SHIFT                           2
#define DAC8760_WD_ENABLE                            (1 << DAC8760_WDEN_SHIFT)
#define DAC8760_WDPD_SHIFT                           0
#define DAC8760_WD_TIMEOUT_10MS                     (0 << DAC8760_WDPD_SHIFT)
#define DAC8760_WD_TIMEOUT_51MS                     (1 << DAC8760_WDPD_SHIFT)
#define DAC8760_WD_TIMEOUT_102MS                    (2 << DAC8760_WDPD_SHIFT)
#define DAC8760_WD_TIMEOUT_204MS                    (3 << DAC8760_WDPD_SHIFT)

// Reset Register Settings
#define DAC8760_RESET_SHIFT                         0
#define DAC8760_RESET                               (1 << DAC8760_RESET_SHIFT)

// STATUS Register Settings
#define DAC8760_CRC_FLT_SHIFT                       4
#define DAC8760_CRC_ERROR                           (1 << DAC8760_CRC_FLT_SHIFT)
#define DAC8760_WDT_FLT_SHIFT                       3
#define DAC8760_WDT_TIMEOUT                         (1 << DAC8760_WDT_FLT_SHIFT)
#define DAC8760_I_FLT_SHIFT                         2
#define DAC8760_IOUT_ERROR                          (1 << DAC8760_I_FLT_SHIFT)
#define DAC8760_SR_ON_SHIFT                         1
#define DAC8760_SR_ON                               (1 << DAC8760_SR_ON_SHIFT)
#define DAC8760_T_FLT_SHIFT                         0
#define DAC8760_TEMP_ERROR                          (1 << DAC8760_T_FLT_SHIFT)

/**********************************************************************************************************************************/
/*                              PROTOTYPES                                                                                        */
/**********************************************************************************************************************************/

void DAC8760_WriteReg (uint16_t writeValues, uint8_t address);
void DAC8760_ReadReg (uint8_t *readValues, uint8_t startReg);
void DAC8760_Setup (uint16_t controlReg, uint16_t configurationReg, uint16_t gainCalReg, uint16_t zeroCalReg);
void DAC8760_Reset (void);
void DAC8760_Nop (void);
void DAC8760_SetOutValue (uint16_t value);
uint8_t DAC8760_ReadStatus (void);

#endif /* DAC8760_H_ */
